/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import com.fathzer.jlocal.Formatter;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JToggleButton;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.transactiontable.TransactionsPreferencePanel;

public class BalanceReportField
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    static Color POSITIVE_COLOR;
    static Color NEGATIVE_COLOR;
    private String contentPattern;

    public BalanceReportField(String contentPattern) {
        this.contentPattern = contentPattern;
        this.setOpaque(true);
        this.setFont(this.getFont().deriveFont(1));
        this.setHorizontalAlignment(0);
        this.setFocusable(false);
        this.setValue(0.0, true);
        Dimension size = this.getPreferredSize();
        size.height += size.height / 2;
        this.setPreferredSize(size);
    }

    public void setValue(double balance, boolean absolute) {
        this.setFont(this.getFont().deriveFont(absolute ? 1 : 3));
        this.setForeground(balance < 0.0 ? NEGATIVE_COLOR : POSITIVE_COLOR);
        String text = Formatter.format(this.contentPattern, LocalizationData.getCurrencyInstance().format(balance));
        this.setText(text);
    }

    static {
        try {
            POSITIVE_COLOR = new Color(Integer.parseInt(Preferences.INSTANCE.getProperty(TransactionsPreferencePanel.POSITIVE_KEY)));
            NEGATIVE_COLOR = new Color(Integer.parseInt(Preferences.INSTANCE.getProperty(TransactionsPreferencePanel.NEGATIVE_KEY)));
        }
        catch (Exception e) {
            POSITIVE_COLOR = TransactionsPreferencePanel.DEFAULT_POSITIVE;
            NEGATIVE_COLOR = TransactionsPreferencePanel.DEFAULT_NEGATIVE;
        }
    }
}

