/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import net.yapbam.gui.transactiontable.SpreadableTableModel;

public class SpreadableMouseAdapter
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point p = e.getPoint();
        int viewColumn = table.columnAtPoint(p);
        int viewRow = table.rowAtPoint(p);
        if (viewColumn < 0 || viewRow < 0) {
            return;
        }
        int column = table.convertColumnIndexToModel(viewColumn);
        int row = table.convertRowIndexToModel(viewRow);
        SpreadableTableModel model = (SpreadableTableModel)((Object)table.getModel());
        if (column == model.getSpreadColumnNumber() && row >= 0 && model.isSpreadable(row)) {
            boolean spread = model.isSpread(row);
            model.setSpread(row, !spread);
            if (spread) {
                table.setRowHeight(viewRow, table.getRowHeight());
            } else {
                int numberOfLines = model.getSpreadLines(row);
                table.setRowHeight(viewRow, table.getRowHeight() * numberOfLines);
            }
        }
    }
}

