/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transfer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.yapbam.data.AbstractTransactionWizard;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;

public class DestinationAccountWizard
extends AbstractTransactionWizard<Account> {
    private Account sourceAccount;
    private Map<DateAmount, List<Account>> destReceipts;
    private DateAmount key;

    protected DestinationAccountWizard(GlobalData data, Account sourceAccount) {
        super(data);
        this.sourceAccount = sourceAccount;
        this.destReceipts = new HashMap<DateAmount, List<Account>>();
        for (int i = 0; i < data.getTransactionsNumber(); ++i) {
            Transaction transaction = data.getTransaction(i);
            if (!(transaction.getAmount() > 0.0) || transaction.getAccount().equals(sourceAccount)) continue;
            DateAmount dateAmount = new DateAmount(transaction.getDateAsInteger(), transaction.getAmount());
            List<Account> accounts = this.destReceipts.get(dateAmount);
            if (accounts == null) {
                accounts = new LinkedList<Account>();
                this.destReceipts.put(dateAmount, accounts);
            }
            accounts.add(transaction.getAccount());
        }
        this.key = new DateAmount(0, 0.0);
    }

    @Override
    protected Account getValue(Transaction transaction) {
        throw new UnsupportedOperationException();
    }

    private List<Account> getValues(Transaction transaction) {
        this.key.date = transaction.getDateAsInteger();
        this.key.amount = -transaction.getAmount();
        return this.destReceipts.get(this.key);
    }

    @Override
    public Account get() {
        if (!this.inited) {
            HashMap<Account, Double> toProbability = new HashMap<Account, Double>();
            for (int i = 0; i < this.data.getTransactionsNumber(); ++i) {
                List<Account> transactionValues;
                Transaction transaction = this.data.getTransaction(i);
                if (!this.isValid(transaction) || (transactionValues = this.getValues(transaction)) == null) continue;
                for (Account account : transactionValues) {
                    Double weight = (Double)toProbability.get(account);
                    double transactionWeight = this.getRanking(transaction);
                    toProbability.put(account, transactionWeight + (weight == null ? 0.0 : weight));
                }
            }
            this.value = DestinationAccountWizard.getHeaviest(toProbability);
        }
        return (Account)this.value;
    }

    @Override
    protected boolean isValid(Transaction transaction) {
        return transaction.getAmount() < 0.0 && transaction.getAccount().equals(this.sourceAccount);
    }

    private static class DateAmount {
        private int date;
        private double amount;

        public DateAmount(int date, double amount) {
            this.date = date;
            this.amount = amount;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.amount);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.date;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DateAmount)) {
                return false;
            }
            DateAmount other = (DateAmount)obj;
            if (Double.doubleToLongBits(this.amount) != Double.doubleToLongBits(other.amount)) {
                return false;
            }
            return this.date == other.date;
        }
    }
}

