/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transfer;

import com.fathzer.soft.ajlib.swing.Utils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.EditAccountDialog;
import net.yapbam.gui.transfer.TransferDialog;

public class NewTransferAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private GlobalData data;
    private AbstractPlugIn plugin;

    NewTransferAction(GlobalData data, AbstractPlugIn plugin) {
        super(LocalizationData.get("TransferDialog.menu"));
        this.data = data;
        this.plugin = plugin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window owner = Utils.getOwnerWindow((Component)e.getSource());
        while (this.data.getAccountsNumber() < 2) {
            Account account = EditAccountDialog.open(this.data, owner, LocalizationData.get("TransferDialog.needsTwoAccounts"));
            if (account != null) continue;
            return;
        }
        TransferDialog dialog = new TransferDialog(owner, LocalizationData.get("TransferDialog.title"), this.data);
        dialog.setFromAccount(this.plugin.getContext().getSelectedAccount());
        dialog.setVisible(true);
        Transaction[] transactions = (Transaction[])dialog.getResult();
        if (transactions != null) {
            this.data.add(transactions);
            if (this.plugin.getContext().getCurrentTransactionSelector() != null) {
                this.plugin.getContext().getCurrentTransactionSelector().setSelectedTransactions(transactions);
            }
        }
    }
}

