/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transfer;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JPanel;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.data.comparator.AccountComparator;
import net.yapbam.gui.transfer.DestinationAccountWizard;
import net.yapbam.gui.transfer.TransferPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class TransferDialog
extends AbstractDialog<GlobalData, Transaction[]> {
    private static final long serialVersionUID = 1L;
    private TransferPanel transferPanel;

    public TransferDialog(Window owner, String title, GlobalData data) {
        super(owner, title, data);
    }

    @Override
    protected JPanel createCenterPane() {
        this.transferPanel = new TransferPanel((GlobalData)this.data);
        this.transferPanel.addPropertyChangeListener("okDisabledCause", new AutoUpdateOkButtonPropertyListener(this));
        return this.transferPanel;
    }

    @Override
    protected Transaction[] buildResult() {
        return this.transferPanel.getTransactions();
    }

    @Override
    protected String getOkDisabledCause() {
        return this.transferPanel.getOkDisabledCause();
    }

    public void setFromAccount(Account selectedAccount) {
        Account[] accounts = AccountComparator.getSortedAccounts((GlobalData)this.data, this.getLocale());
        if (selectedAccount == null) {
            selectedAccount = accounts[0];
        }
        this.transferPanel.getFromPane().setAccount(selectedAccount);
        Account dest = new DestinationAccountWizard((GlobalData)this.data, selectedAccount).get();
        if (dest == null) {
            for (Account account : accounts) {
                if (account.equals(selectedAccount)) continue;
                dest = account;
                break;
            }
        }
        this.transferPanel.getToPane().setAccount(dest);
    }
}

