/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.yapbam.gui.util.PaintedTable;
import net.yapbam.gui.util.TablePainter;

public class URLTableCellRenderer
extends JEditorPane
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;

    public URLTableCellRenderer() {
        this.setContentType("text/html");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table instanceof PaintedTable) {
            TablePainter painter = ((PaintedTable)((Object)table)).getPainter();
            painter.setRowLook(this, table, table.convertRowIndexToModel(row), isSelected);
        }
        this.setBorder(null);
        this.setText("<html><body style=\"" + this.getStyle() + "\">" + value + "</body></html>");
        return this;
    }

    private StringBuilder getStyle() {
        Color color = this.getBackground();
        StringBuilder style = new StringBuilder();
        style.append("background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");");
        style.append("margin-left: 5px;");
        style.append("margin-top: 0px;");
        style.append("padding-top: 0px;");
        if ((this.getFont().getStyle() & 2) != 0) {
            style.append("font-style: italic;");
        }
        if ((this.getFont().getStyle() & 1) != 0) {
            style.append("font-weight: bold;");
        }
        style.append("line-height: " + this.getFont().getSize() + "px;");
        return style;
    }
}

