/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.welcome;

import com.fathzer.soft.ajlib.swing.Browser;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.HTMLPane;
import com.fathzer.soft.ajlib.swing.widget.PageSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.persistence.YapbamDataWrapper;
import net.yapbam.gui.persistence.YapbamPersistenceManager;
import net.yapbam.gui.welcome.TipManager;

public class WelcomePanel
extends JPanel {
    private static final String BUNDLE_NAME = "net.yapbam.gui.welcome.urls";
    private JCheckBox showAtStartup;
    private HTMLPane tipPane;
    private TipManager tips;
    private ResourceBundle urlsResourceBundle;
    private GlobalData data;

    private URI getURI(String key) {
        try {
            String uriString = this.urlsResourceBundle.getString(key);
            if (uriString.contains(":")) {
                return new URI(uriString);
            }
            return new File(uriString).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WelcomePanel(GlobalData data) {
        this.data = data;
        this.urlsResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.tips = new TipManager();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel lblWelcomeToYapbam = new JLabel(LocalizationData.get("Welcome.introduction"));
        lblWelcomeToYapbam.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        GridBagConstraints gbcLblWelcomeToYapbam = new GridBagConstraints();
        gbcLblWelcomeToYapbam.anchor = 17;
        gbcLblWelcomeToYapbam.gridwidth = 2;
        gbcLblWelcomeToYapbam.insets = new Insets(0, 10, 5, 0);
        gbcLblWelcomeToYapbam.gridx = 0;
        gbcLblWelcomeToYapbam.gridy = 0;
        this.add((Component)lblWelcomeToYapbam, gbcLblWelcomeToYapbam);
        JPanel bottomPanel = new JPanel();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.insets = new Insets(0, 0, 5, 0);
        gbcBottomPanel.gridwidth = 2;
        gbcBottomPanel.fill = 1;
        gbcBottomPanel.gridx = 0;
        gbcBottomPanel.gridy = 3;
        this.add((Component)bottomPanel, gbcBottomPanel);
        GridBagLayout gblBottomPanel = new GridBagLayout();
        bottomPanel.setLayout(gblBottomPanel);
        bottomPanel.setOpaque(false);
        this.showAtStartup = new JCheckBox(LocalizationData.get("Welcome.showAtStartup"));
        this.showAtStartup.setToolTipText(LocalizationData.get("Welcome.showAtStartup.tooltip"));
        this.showAtStartup.setOpaque(false);
        this.showAtStartup.setHorizontalAlignment(4);
        GridBagConstraints gbcShowAtStartup = new GridBagConstraints();
        gbcShowAtStartup.anchor = 13;
        gbcShowAtStartup.weightx = 1.0;
        gbcShowAtStartup.fill = 2;
        gbcShowAtStartup.gridx = 0;
        gbcShowAtStartup.gridy = 0;
        bottomPanel.add((Component)this.showAtStartup, gbcShowAtStartup);
        JPanel shortcutsPanel = new JPanel();
        shortcutsPanel.setOpaque(false);
        shortcutsPanel.setBorder(new TitledBorder(null, LocalizationData.get("Welcome.shorcuts.title"), 4, 2, null, null));
        GridBagConstraints gbcShortcutsPanel = new GridBagConstraints();
        gbcShortcutsPanel.anchor = 11;
        gbcShortcutsPanel.weighty = 1.0;
        gbcShortcutsPanel.insets = new Insets(0, 0, 5, 5);
        gbcShortcutsPanel.fill = 2;
        gbcShortcutsPanel.gridx = 0;
        gbcShortcutsPanel.gridy = 2;
        this.add((Component)shortcutsPanel, gbcShortcutsPanel);
        GridBagLayout gblShortcutsPanel = new GridBagLayout();
        shortcutsPanel.setLayout(gblShortcutsPanel);
        final URI file = this.getURI("sampleFile");
        JButton btnOpenSampleData = new JButton(LocalizationData.get("Welcome.sampleData"));
        btnOpenSampleData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (YapbamPersistenceManager.MANAGER.read(Utils.getOwnerWindow(WelcomePanel.this), new YapbamDataWrapper(WelcomePanel.this.data), file, null)) {
                    WelcomePanel.this.data.setURI(null);
                }
            }
        });
        btnOpenSampleData.setHorizontalAlignment(2);
        btnOpenSampleData.setToolTipText(LocalizationData.get("Welcome.sampleData.tooltip"));
        GridBagConstraints gbcBtnOpenSampleData = new GridBagConstraints();
        gbcBtnOpenSampleData.anchor = 11;
        gbcBtnOpenSampleData.insets = new Insets(0, 0, 5, 0);
        gbcBtnOpenSampleData.weightx = 1.0;
        gbcBtnOpenSampleData.fill = 2;
        gbcBtnOpenSampleData.gridx = 0;
        gbcBtnOpenSampleData.gridy = 0;
        shortcutsPanel.add((Component)btnOpenSampleData, gbcBtnOpenSampleData);
        JButton btnViewTheTutorial = new JButton(LocalizationData.get("Welcome.tutorial"));
        btnViewTheTutorial.addActionListener(new URIClienthandler(this.getURI("tutorial")));
        btnViewTheTutorial.setToolTipText(LocalizationData.get("Welcome.tutorial.tooltip"));
        btnViewTheTutorial.setHorizontalAlignment(2);
        GridBagConstraints gbcBtnViewTheTutorial = new GridBagConstraints();
        gbcBtnViewTheTutorial.insets = new Insets(0, 0, 5, 0);
        gbcBtnViewTheTutorial.anchor = 17;
        gbcBtnViewTheTutorial.weightx = 1.0;
        gbcBtnViewTheTutorial.fill = 2;
        gbcBtnViewTheTutorial.gridx = 0;
        gbcBtnViewTheTutorial.gridy = 1;
        btnViewTheTutorial.setVisible(true);
        shortcutsPanel.add((Component)btnViewTheTutorial, gbcBtnViewTheTutorial);
        JButton faq = new JButton(LocalizationData.get("Welcome.faq"));
        faq.addActionListener(new URIClienthandler(this.getURI("faq")));
        faq.setHorizontalAlignment(2);
        faq.setToolTipText(LocalizationData.get("Welcome.faq.tooltip"));
        GridBagConstraints gbcFaq = new GridBagConstraints();
        gbcFaq.anchor = 11;
        gbcFaq.weighty = 1.0;
        gbcFaq.fill = 2;
        gbcFaq.gridx = 0;
        gbcFaq.gridy = 2;
        shortcutsPanel.add((Component)faq, gbcFaq);
        JPanel tipsPanel = new JPanel();
        tipsPanel.setBorder(new TitledBorder(LocalizationData.get("Welcome.tip.title")));
        GridBagConstraints gbcTipsPanel = new GridBagConstraints();
        gbcTipsPanel.weighty = 1.0;
        gbcTipsPanel.weightx = 1.0;
        gbcTipsPanel.insets = new Insets(0, 0, 5, 0);
        gbcTipsPanel.fill = 1;
        gbcTipsPanel.gridx = 1;
        gbcTipsPanel.gridy = 2;
        this.add((Component)tipsPanel, gbcTipsPanel);
        tipsPanel.setOpaque(false);
        tipsPanel.setLayout(new BorderLayout(0, 0));
        this.tipPane = new HTMLPane();
        this.tipPane.setPreferredSize(new Dimension(300 * this.getFont().getSize() / 12, 200 * this.getFont().getSize() / 12));
        tipsPanel.add((Component)this.tipPane, "Center");
        PageSelector tipSelectionPanel = new PageSelector();
        tipSelectionPanel.addPropertyChangeListener("PageSelected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer index = (Integer)evt.getNewValue();
                if (index != null) {
                    WelcomePanel.this.tipPane.setContent((String)WelcomePanel.this.tips.get(index));
                }
            }
        });
        tipsPanel.add((Component)tipSelectionPanel, "South");
        tipSelectionPanel.getPageNumber().setToolTipText(LocalizationData.get("Welcome.tipNumber.tooltip"));
        tipSelectionPanel.getFirstPage().setToolTipText(LocalizationData.get("Welcome.firstTip.tooltip"));
        tipSelectionPanel.getNextPage().setToolTipText(LocalizationData.get("Welcome.nextTip.tooltip"));
        tipSelectionPanel.getLastPage().setToolTipText(LocalizationData.get("Welcome.lastTip.tooltip"));
        tipSelectionPanel.getPreviousPage().setToolTipText(LocalizationData.get("Welcome.previousTip.tooltip"));
        this.setOpaque(false);
        JSeparator separator = new JSeparator();
        GridBagConstraints gbcSeparator = new GridBagConstraints();
        gbcSeparator.weightx = 1.0;
        gbcSeparator.gridwidth = 2;
        gbcSeparator.fill = 2;
        gbcSeparator.anchor = 11;
        gbcSeparator.insets = new Insets(0, 10, 20, 10);
        gbcSeparator.gridx = 0;
        gbcSeparator.gridy = 1;
        this.add((Component)separator, gbcSeparator);
        tipSelectionPanel.setPageCount(this.tips.size());
        tipSelectionPanel.setPage(this.tips.getRandom());
    }

    public boolean isShowAtStartup() {
        return this.showAtStartup.isSelected();
    }

    public void setShowAtStartup(boolean show) {
        this.showAtStartup.setSelected(show);
    }

    private final class URIClienthandler
    implements ActionListener {
        private URI uri;

        private URIClienthandler(URI uri) {
            this.uri = uri;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Browser.show(this.uri, WelcomePanel.this, null);
        }
    }
}

