/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.widget;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;

public abstract class AbstractStatPanel<T extends Observable, V>
extends JPanel {
    private T data;
    private JComponent details;
    private JLabel showButton;
    private JLabel summaryLabel;

    public AbstractStatPanel(V data) {
        this.data = this.buildData(data);
        this.initialize();
        ((Observable)this.data).addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AbstractStatPanel.this.doUpdate();
            }
        });
        this.doUpdate();
        this.setDeployed(false);
    }

    protected T getData() {
        return this.data;
    }

    protected abstract T buildData(V var1);

    protected abstract JComponent buildDetails();

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints cShow = new GridBagConstraints();
        cShow.insets = new Insets(0, 0, 5, 0);
        cShow.gridx = 0;
        cShow.anchor = 17;
        cShow.gridy = 0;
        this.add((Component)this.getShowButton(), cShow);
        GridBagConstraints gbcSummaryLabel = new GridBagConstraints();
        gbcSummaryLabel.weightx = 1.0;
        gbcSummaryLabel.anchor = 17;
        gbcSummaryLabel.gridx = 1;
        gbcSummaryLabel.gridy = 0;
        this.add((Component)this.getSummary(), gbcSummaryLabel);
        GridBagConstraints cContent = new GridBagConstraints();
        cContent.anchor = 17;
        cContent.insets = new Insets(0, 0, 5, 0);
        cContent.gridwidth = 0;
        cContent.gridx = 1;
        cContent.weightx = 1.0;
        cContent.gridy = 1;
        this.add((Component)this.getDetails(), cContent);
    }

    protected abstract void doUpdate();

    protected void setDeployed(boolean deployed) {
        this.getDetails().setVisible(deployed);
        this.getShowButton().setIcon(IconManager.get(deployed ? IconManager.Name.SPREAD : IconManager.Name.SPREADABLE));
        this.getShowButton().setToolTipText(deployed ? LocalizationData.get("MainFrame.stat.hide.tip") : LocalizationData.get("MainFrame.stat.show.tip"));
    }

    private boolean isDeployed() {
        return this.getDetails().isVisible();
    }

    protected JComponent getDetails() {
        if (this.details == null) {
            this.details = this.buildDetails();
        }
        return this.details;
    }

    protected JLabel getShowButton() {
        if (this.showButton == null) {
            this.showButton = new JLabel(IconManager.get(IconManager.Name.SPREADABLE));
            this.showButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractStatPanel.this.setDeployed(!AbstractStatPanel.this.isDeployed());
                }
            });
        }
        return this.showButton;
    }

    protected JLabel getSummary() {
        if (this.summaryLabel == null) {
            this.summaryLabel = new JLabel();
        }
        return this.summaryLabel;
    }
}

