/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.widget;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import net.yapbam.gui.IconManager;

public abstract class JLabelMenu
extends JLabel {
    public JLabelMenu(String text) {
        super(text, IconManager.get(IconManager.Name.SPREAD), 2);
        this.setHorizontalTextPosition(10);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu popup = new JPopupMenu();
                JLabelMenu.this.fillPopUp(popup);
                Dimension size = popup.getPreferredSize();
                popup.setPreferredSize(new Dimension(Math.max(size.width, JLabelMenu.this.getSize().width), size.height));
                popup.show(e.getComponent(), 0, JLabelMenu.this.getSize().height);
            }
        });
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        int textWidth = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
        int remaining = width - textWidth - this.getIcon().getIconWidth();
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            remaining = remaining - insets.left - insets.right;
        }
        this.setIconTextGap(Math.max(0, remaining));
        super.setSize(width, height);
    }

    protected abstract void fillPopUp(JPopupMenu var1);
}

