/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.update;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.yapbam.gui.LocalizationData;

public class ReleaseInfo
implements Comparable<ReleaseInfo>,
Serializable {
    private static final long serialVersionUID = 2256410858572541319L;
    public static final ReleaseInfo UNKNOWN = new ReleaseInfo("");
    private boolean unknown;
    private int majorRevision;
    private int minorRevision;
    private int buildId;
    private Date releaseDate;
    private String preReleaseComment;

    public ReleaseInfo(String rel) {
        try {
            StringTokenizer parts = new StringTokenizer(rel, " ");
            StringTokenizer tokens = new StringTokenizer(parts.nextToken(), ".");
            this.majorRevision = Integer.parseInt(tokens.nextToken());
            this.minorRevision = Integer.parseInt(tokens.nextToken());
            this.buildId = Integer.parseInt(tokens.nextToken());
            this.preReleaseComment = tokens.hasMoreElements() ? tokens.nextToken() : null;
            this.parseDate(parts);
        }
        catch (IllegalArgumentException e) {
            this.releaseDate = new Date(0L);
            this.preReleaseComment = "Invalid version format";
        }
        catch (NoSuchElementException e) {
            this.unknown = true;
        }
    }

    private void parseDate(StringTokenizer parts) {
        StringTokenizer tokens = new StringTokenizer(parts.nextToken(), "()/");
        try {
            int dayOfMonth = Integer.parseInt(tokens.nextToken());
            int month = Integer.parseInt(tokens.nextToken());
            int year = Integer.parseInt(tokens.nextToken());
            this.releaseDate = new GregorianCalendar(year, month - 1, dayOfMonth).getTime();
        }
        catch (NumberFormatException e) {
            this.releaseDate = new Date(Long.MAX_VALUE);
        }
    }

    public int getMajorRevision() {
        return this.majorRevision;
    }

    public int getMinorRevision() {
        return this.minorRevision;
    }

    public int getBuildId() {
        return this.buildId;
    }

    public String getPreReleaseComment() {
        return this.preReleaseComment;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @Override
    public int compareTo(ReleaseInfo o) {
        if (this.unknown) {
            if (o.unknown) {
                return 0;
            }
            return -1;
        }
        if (o.unknown) {
            return 1;
        }
        int result = this.majorRevision - o.majorRevision;
        if (result == 0) {
            result = this.minorRevision - o.minorRevision;
        }
        if (result == 0) {
            result = this.buildId - o.buildId;
        }
        if (result == 0) {
            result = this.getReleaseDate().compareTo(o.getReleaseDate());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReleaseInfo)) {
            return false;
        }
        return this.compareTo((ReleaseInfo)obj) == 0;
    }

    public int hashCode() {
        if (this.unknown) {
            return 0;
        }
        return this.majorRevision * 100 + this.minorRevision * 100 + this.buildId;
    }

    public String toString() {
        if (this.unknown) {
            return "?";
        }
        return this.majorRevision + "." + this.minorRevision + "." + this.buildId + (this.preReleaseComment == null ? "" : "." + this.preReleaseComment) + " (" + SimpleDateFormat.getDateInstance(2, LocalizationData.getLocale()).format(this.releaseDate) + ")";
    }
}

