/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class ArrayUtils {
    private static final String ENCODING = "UTF-8";

    private ArrayUtils() {
    }

    public static String toString(int[] array) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(array[i]);
        }
        builder.append("]");
        return builder.toString();
    }

    public static int[] parseIntArray(String string) {
        StringTokenizer tokens = new StringTokenizer(string, "[,]");
        int[] result = new int[tokens.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(tokens.nextToken().trim());
        }
        return result;
    }

    public static String toString(String[] array) {
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                builder.append(",");
            }
            try {
                builder.append(URLEncoder.encode(array[i], ENCODING));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static String[] parseStringArray(String string) {
        if (string.length() == 0) {
            return new String[0];
        }
        if (!string.startsWith("[") || !string.endsWith("]")) {
            throw new IllegalArgumentException();
        }
        string = string.substring(1, string.length() - 1);
        String[] array = string.split(",");
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = URLDecoder.decode(array[i], ENCODING);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        int extraEmptyStrings = 0;
        for (int index = string.length() - 1; index >= 0 && string.charAt(index) == ','; --index) {
            ++extraEmptyStrings;
        }
        if (extraEmptyStrings != 0) {
            String[] result = new String[array.length + extraEmptyStrings];
            System.arraycopy(array, 0, result, 0, array.length);
            for (int i = array.length; i < result.length; ++i) {
                result[i] = "";
            }
            return result;
        }
        return array;
    }

    public static int[] buildIntArray(int length, int start, int step) {
        int[] result = new int[length];
        if (length > 0) {
            result[0] = start;
            for (int i = 1; i < result.length; ++i) {
                result[i] = result[i - 1] + step;
            }
        }
        return result;
    }

    public static boolean[] buildBooleanArray(int length, boolean value) {
        boolean[] result = new boolean[length];
        if (value) {
            Arrays.fill(result, value);
        }
        return result;
    }

    public static <T> boolean isAllNull(T[] array) {
        for (T t : array) {
            if (t == null) continue;
            return false;
        }
        return true;
    }
}

