/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    private DateUtils() {
    }

    public static int getMonthlyDistance(Calendar first, Calendar last) {
        return last.get(1) * 12 + last.get(2) - (first.get(1) * 12 + first.get(2));
    }

    public static Date integerToDate(int date) {
        if (date < 0) {
            return null;
        }
        int year = date / 10000;
        int day = date - 10000 * year;
        int month = day / 100;
        return new GregorianCalendar(year, month - 1, day -= 100 * month).getTime();
    }

    public static int getYear(int date) {
        return date / 10000;
    }

    public static int dateToInteger(Date date) {
        if (date == null) {
            return -1;
        }
        return (date.getYear() + 1900) * 10000 + (date.getMonth() + 1) * 100 + date.getDate();
    }

    public static int dateToInteger(int year, int month, int day) {
        return year * 10000 + month * 100 + day;
    }

    public static Date getMidnight(Date date) {
        return DateUtils.integerToDate(DateUtils.dateToInteger(date));
    }
}

