/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.IOException;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public final class PreferencesUtils {
    private PreferencesUtils() {
    }

    public static void verifyPreferencesCompliance(String key, String value) {
        if (key.length() > 80) {
            throw new IllegalArgumentException("Key is to long: " + key);
        }
        if (value.length() > 8192) {
            throw new IllegalArgumentException("Value is to long: " + value);
        }
    }

    public static void toPreferences(Preferences pref, Properties properties, boolean clear) throws IOException {
        try {
            if (clear) {
                pref.clear();
            }
            for (Object obj : properties.keySet()) {
                String key = (String)obj;
                String value = properties.getProperty(key);
                pref.put(key, value);
            }
            pref.flush();
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }

    public static void fromPreferences(Preferences pref, Properties properties) throws IOException {
        try {
            for (String key : pref.keys()) {
                String value = pref.get(key, null);
                properties.put(key, value);
            }
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }

    public static boolean isEmpty(Preferences pref) throws IOException {
        try {
            return pref.keys().length == 0;
        }
        catch (BackingStoreException e) {
            throw new IOException(e);
        }
    }
}

