/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.yapbam.util.CheckSum;

public class SecureDownloader {
    private Proxy proxy;
    private boolean cancelled;

    public SecureDownloader(Proxy proxy) {
        this.proxy = proxy;
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DownloadInfo download(URL url, File file) throws IOException {
        InputStream in = url.openConnection(this.proxy).getInputStream();
        try {
            DownloadInfo downloadInfo;
            block7: {
                BufferedOutputStream out = file == null ? null : new BufferedOutputStream(new FileOutputStream(file));
                try {
                    downloadInfo = this.copy(in, out);
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        ((OutputStream)out).flush();
                        ((OutputStream)out).close();
                    }
                    throw throwable;
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            return downloadInfo;
        }
        finally {
            in.close();
        }
    }

    public synchronized DownloadInfo copy(InputStream in, OutputStream out) throws IOException {
        int size;
        MessageDigest digest;
        long length = 0L;
        this.cancelled = false;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[8192];
        while ((size = in.read(buffer, 0, buffer.length)) != -1 && !this.cancelled) {
            if (out != null) {
                out.write(buffer, 0, size);
            }
            if (size <= 0) continue;
            digest.update(buffer, 0, size);
            this.progress(length += (long)size);
        }
        return this.cancelled ? null : new DownloadInfo(CheckSum.toString(digest.digest()), length);
    }

    protected void progress(long downloadedSize) {
    }

    public void cancel() {
        this.cancelled = true;
    }

    public static class DownloadInfo {
        private String checkSum;
        private long length;

        private DownloadInfo(String checkSum, long length) {
            this.checkSum = checkSum;
            this.length = length;
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public long getDownloadedSize() {
            return this.length;
        }
    }
}

