/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileSystemView;
import jgnash.engine.DataStore;
import jgnash.engine.DataStoreType;
import jgnash.engine.Engine;
import jgnash.engine.StoredObject;
import jgnash.engine.db4o.Db4oDataStore;
import jgnash.engine.xstream.XMLDataStore;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.util.FileMagic;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

public class EngineFactory {
    private static final String LAST_DATABASE = "LastDatabase";
    private static final String LAST_HOST = "LastHost";
    private static final String LAST_USER = "LastUser";
    private static final String LAST_PORT = "LastPort";
    private static final String LAST_PASSWORD = "LastPassword";
    private static final String LAST_USEDPASSWORD = "LastUsedPassword";
    private static final String LAST_REMOTE = "LastRemote";
    private static final String EXPORT_XML_ON_CLOSE = "ExportXMLOnClose";
    private static final String MAX_BACKUPS = "MaxBackups";
    private static final String REMOVE_BACKUPS = "RemoveBackups";
    private static final String OPEN_LAST = "OpenLast";
    private static final String DEFAULT_DIR = "jGnash";
    private static final Logger logger = Logger.getLogger(EngineFactory.class.getName());
    public static final String DEFAULT = "default";
    private static final Map<String, Engine> engineMap = new HashMap<String, Engine>();
    private static final Map<String, DataStore> dataStoreMap = new HashMap<String, DataStore>();

    private EngineFactory() {
    }

    public static boolean doesDatabaseExist(String database, DataStoreType type) {
        if (FileUtils.fileHasExtension(database)) {
            File file = new File(database);
            return file.canRead();
        }
        File file = new File(database + "." + type.getDataStore().getFileExt());
        return file.canRead();
    }

    public static boolean doesDatabaseExist(String database) {
        File file = new File(database);
        return file.canRead();
    }

    public static boolean deleteDatabase(String database) {
        return new File(database).delete();
    }

    public static synchronized Engine getEngine(String name) {
        return engineMap.get(name);
    }

    private static void exportCompressedXML(String engineName) {
        Engine oldEngine = engineMap.get(engineName);
        DataStore oldDataStore = dataStoreMap.get(engineName);
        EngineFactory.exportCompressedXML(oldDataStore.getFileName(), oldEngine.getStoredObjects());
    }

    public static void exportCompressedXML(String fileName, Collection<StoredObject> objects) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
        XMLDataStore xmlDataStore = new XMLDataStore();
        File xmlFile = new File(FileUtils.stripFileExtension(fileName) + "-" + dateFormat.format(new Date()) + "." + xmlDataStore.getFileExt());
        File zipFile = new File(FileUtils.stripFileExtension(fileName) + "-" + dateFormat.format(new Date()) + ".zip");
        xmlDataStore.saveAs(xmlFile, objects);
        FileUtils.compressFile(xmlFile, zipFile);
        if (!xmlFile.delete()) {
            logger.log(Level.WARNING, "Was not able to delete the temporary file: {0}", xmlFile.getAbsolutePath());
        }
    }

    public static void removeOldCompressedXML(String fileName) {
        File file = new File(fileName);
        String baseFile = FileUtils.stripFileExtension(file.getName());
        List<File> fileList = FileUtils.getDirectoryListing(file.getParentFile(), baseFile + "-*.zip");
        int maxFiles = EngineFactory.maximumBackups();
        if (fileList.size() > maxFiles) {
            for (int i = 0; i < fileList.size() - maxFiles; ++i) {
                if (fileList.get(i).delete()) continue;
                logger.log(Level.WARNING, "Unable to delete the file: {0}", fileList.get(i).getAbsolutePath());
            }
        }
    }

    public static synchronized void closeEngine(String engineName) {
        Engine oldEngine = engineMap.get(engineName);
        DataStore oldDataStore = dataStoreMap.get(engineName);
        if (oldEngine != null) {
            Message message = new Message(MessageChannel.SYSTEM, ChannelEvent.FILE_CLOSING, oldEngine);
            MessageBus.getInstance(engineName).fireEvent(message);
            if (EngineFactory.exportXMLOnClose() && !oldDataStore.isRemote()) {
                EngineFactory.exportCompressedXML(engineName);
            }
            if (EngineFactory.removeOldBackups() && !oldDataStore.isRemote()) {
                EngineFactory.removeOldCompressedXML(oldDataStore.getFileName());
            }
            oldEngine.shutdown();
            MessageBus.getInstance(engineName).setLocal();
            oldDataStore.closeEngine();
            engineMap.remove(engineName);
            dataStoreMap.remove(engineName);
        }
    }

    public static synchronized Engine bootLocalEngine(String fileName, String engineName) {
        DataStoreType type = EngineFactory.getDataStoreByType(new File(fileName));
        if (type != null) {
            return EngineFactory.bootLocalEngine(fileName, engineName, type);
        }
        return null;
    }

    public static synchronized Engine bootLocalEngine(String fileName, String engineName, DataStoreType type) {
        MessageBus.getInstance(engineName).setLocal();
        DataStore dataStore = type.getDataStore();
        Engine engine = dataStore.getLocalEngine(fileName, engineName);
        if (engine != null) {
            logger.info(Resource.get().getString("Message.EngineStart"));
            engineMap.put(engineName, engine);
            dataStoreMap.put(engineName, dataStore);
            Message message = new Message(MessageChannel.SYSTEM, ChannelEvent.FILE_LOAD_SUCCESS, engine);
            MessageBus.getInstance(engineName).fireEvent(message);
            if (engineName.equals(DEFAULT)) {
                Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
                pref.put(LAST_DATABASE, fileName);
                pref.putBoolean(LAST_REMOTE, false);
            }
        }
        return engine;
    }

    public static synchronized Engine bootClientEngine(String host, int port, String user, String password, String engineName, boolean savePassword) {
        return EngineFactory.bootClientEngine(host, port, user, password, engineName, savePassword, DataStoreType.DB4O);
    }

    private static synchronized Engine bootClientEngine(String host, int port, String user, String password, String engineName, boolean savePassword, DataStoreType type) {
        assert (engineMap.get(engineName) == null);
        if (!type.supportsRemote) {
            throw new UnsupportedOperationException("Client / Server operation not supported for this type.");
        }
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        Engine engine = null;
        if (MessageBus.getInstance(engineName).setRemote(host, port + 1)) {
            pref.putInt(LAST_PORT, port);
            pref.put(LAST_HOST, host);
            pref.put(LAST_USER, user);
            pref.putBoolean(LAST_REMOTE, true);
            DataStore dataStore = type.getDataStore();
            engine = dataStore.getClientEngine(host, port, user, password, engineName);
            if (engine != null) {
                logger.info(Resource.get().getString("Message.EngineStart"));
                engineMap.put(engineName, engine);
                dataStoreMap.put(engineName, dataStore);
                Message message = new Message(MessageChannel.SYSTEM, ChannelEvent.FILE_LOAD_SUCCESS, engine);
                MessageBus.getInstance(engineName).fireEvent(message);
                if (password != null) {
                    pref.putBoolean(LAST_USEDPASSWORD, password.length() > 0);
                    if (savePassword) {
                        pref.put(LAST_PASSWORD, password);
                    } else {
                        pref.put(LAST_PASSWORD, "");
                    }
                } else {
                    pref.putBoolean(LAST_USEDPASSWORD, false);
                    pref.put(LAST_PASSWORD, "");
                }
            }
        }
        return engine;
    }

    private static DataStoreType getDataStoreByType(File file) {
        FileMagic.FileType type = FileMagic.magic(file);
        if (type == FileMagic.FileType.db4o) {
            return DataStoreType.DB4O;
        }
        if (type == FileMagic.FileType.jGnash2XML) {
            return DataStoreType.XML;
        }
        return null;
    }

    public static float getFileVersion(File file) {
        float version = 0.0f;
        FileMagic.FileType type = FileMagic.magic(file);
        if (type == FileMagic.FileType.db4o) {
            return Db4oDataStore.getFileVersion(file);
        }
        if (type == FileMagic.FileType.jGnash2XML) {
            return XMLDataStore.getFileVersion(file);
        }
        return version;
    }

    public static synchronized String getDefaultDatabase() {
        String base = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        String userName = System.getProperty("user.name");
        String filesep = System.getProperty("file.separator");
        return base + filesep + DEFAULT_DIR + filesep + userName;
    }

    public static synchronized String getLastDatabase() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.get(LAST_DATABASE, EngineFactory.getDefaultDatabase());
    }

    public static synchronized String getActiveDatabase() {
        if (EngineFactory.getLastRemote()) {
            return EngineFactory.getLastUser() + "@" + EngineFactory.getLastHost();
        }
        return EngineFactory.getLastDatabase();
    }

    public static synchronized String getLastUser() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.get(LAST_USER, "sa");
    }

    public static synchronized String getLastHost() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.get(LAST_HOST, "localhost");
    }

    public static synchronized int getLastPort() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getInt(LAST_PORT, 5300);
    }

    public static synchronized boolean getLastRemote() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getBoolean(LAST_REMOTE, false);
    }

    public static synchronized String getLastPassword() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.get(LAST_PASSWORD, "");
    }

    public static synchronized void setExportXMLOnClose(boolean export) {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        pref.putBoolean(EXPORT_XML_ON_CLOSE, export);
    }

    public static synchronized void setOpenLastOnStartup(boolean last) {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        pref.putBoolean(OPEN_LAST, last);
    }

    public static synchronized boolean openLastOnStartup() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getBoolean(OPEN_LAST, true);
    }

    public static synchronized boolean exportXMLOnClose() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getBoolean(EXPORT_XML_ON_CLOSE, true);
    }

    public static synchronized int maximumBackups() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getInt(MAX_BACKUPS, 10);
    }

    public static synchronized void setMaximumBackups(int max) {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        pref.putInt(MAX_BACKUPS, max);
    }

    public static synchronized boolean removeOldBackups() {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        return pref.getBoolean(REMOVE_BACKUPS, true);
    }

    public static synchronized void setRemoveOldBackups(boolean backup) {
        Preferences pref = Preferences.userNodeForPackage(EngineFactory.class);
        pref.putBoolean(REMOVE_BACKUPS, backup);
    }
}

