/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import jgnash.engine.AbstractInvestmentTransactionEntry;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionTag;
import jgnash.engine.TransactionType;

public class InvestmentTransaction
extends Transaction {
    private static final long serialVersionUID = -7026047119534296655L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionType getTransactionType() {
        TransactionType type = null;
        this.getLock().readLock().lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (!(e instanceof AbstractInvestmentTransactionEntry)) continue;
                type = ((AbstractInvestmentTransactionEntry)e).getTransactionType();
            }
        }
        finally {
            this.getLock().readLock().unlock();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getInvestmentAccount() {
        Account account = null;
        this.getLock().readLock().lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (e.getCreditAccount().getAccountType().getAccountGroup() == AccountGroup.INVEST) {
                    account = e.getCreditAccount();
                    continue;
                }
                if (e.getDebitAccount().getAccountType().getAccountGroup() != AccountGroup.INVEST) continue;
                account = e.getDebitAccount();
            }
        }
        finally {
            this.getLock().readLock().unlock();
        }
        return account;
    }

    @Override
    public void addTransactionEntry(TransactionEntry entry) {
        if (entry instanceof AbstractInvestmentTransactionEntry) {
            TransactionType type = this.getTransactionType();
            SecurityNode node = this.getSecurityNode();
            if (type != null) assert (((AbstractInvestmentTransactionEntry)entry).getTransactionType() == type);
            if (node != null) assert (((AbstractInvestmentTransactionEntry)entry).getSecurityNode().equals(node));
        }
        super.addTransactionEntry(entry);
    }

    public BigDecimal getPrice() {
        BigDecimal price = BigDecimal.ZERO;
        for (TransactionEntry e : this.transactionEntries) {
            if (!(e instanceof AbstractInvestmentTransactionEntry)) continue;
            price = ((AbstractInvestmentTransactionEntry)e).getPrice();
            break;
        }
        return price;
    }

    public BigDecimal getQuantity() {
        BigDecimal quantity = BigDecimal.ZERO;
        for (TransactionEntry e : this.transactionEntries) {
            if (!(e instanceof AbstractInvestmentTransactionEntry)) continue;
            quantity = quantity.add(((AbstractInvestmentTransactionEntry)e).getQuantity());
        }
        return quantity;
    }

    BigDecimal getSignedQuantity() {
        BigDecimal quantity = BigDecimal.ZERO;
        for (TransactionEntry e : this.transactionEntries) {
            if (!(e instanceof AbstractInvestmentTransactionEntry)) continue;
            quantity = quantity.add(((AbstractInvestmentTransactionEntry)e).getSignedQuantity());
        }
        return quantity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityNode getSecurityNode() {
        SecurityNode node = null;
        this.getLock().readLock().lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (!(e instanceof AbstractInvestmentTransactionEntry)) continue;
                node = ((AbstractInvestmentTransactionEntry)e).getSecurityNode();
            }
        }
        finally {
            this.getLock().readLock().unlock();
        }
        return node;
    }

    public BigDecimal getFees() {
        return this.getFees(this.getInvestmentAccount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigDecimal getFees(Account account) {
        BigDecimal fees = BigDecimal.ZERO;
        this.getLock().readLock().lock();
        try {
            for (TransactionEntry e : this.transactionEntries) {
                if (e.getTransactionTag() != TransactionTag.INVESTMENT_FEE) continue;
                fees = fees.add(e.getAmount(account));
            }
        }
        finally {
            this.getLock().readLock().unlock();
        }
        return fees.negate();
    }

    public List<TransactionEntry> getInvestmentFeeEntries() {
        return this.getTransactionEntriesByTag(TransactionTag.INVESTMENT_FEE);
    }

    public List<TransactionEntry> getInvestmentGainLossEntries() {
        return this.getTransactionEntriesByTag(TransactionTag.GAIN_LOSS);
    }

    public BigDecimal getMarketValue(BigDecimal sharePrice) {
        return this.getSignedQuantity().multiply(sharePrice);
    }

    public BigDecimal getMarketValue(Date date) {
        return this.getSignedQuantity().multiply(this.getSecurityNode().getMarketPrice(date, this.getInvestmentAccount().getCurrencyNode()));
    }

    public BigDecimal getTotal(Account account) {
        BigDecimal total = BigDecimal.ZERO;
        for (TransactionEntry e : this.transactionEntries) {
            if (e instanceof AbstractInvestmentTransactionEntry) {
                total = total.add(((AbstractInvestmentTransactionEntry)e).getTotal());
                continue;
            }
            total = total.add(e.getAmount(account));
        }
        return total;
    }

    public BigDecimal getNetCashValue() {
        BigDecimal total = this.getQuantity().multiply(this.getPrice());
        switch (this.getTransactionType()) {
            case REINVESTDIV: 
            case SELLSHARE: {
                total = total.subtract(this.getFees());
                break;
            }
            case BUYSHARE: {
                total = total.add(this.getFees());
                break;
            }
        }
        return total;
    }
}

