/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import jgnash.engine.dao.AbstractDAO;
import jgnash.net.ConnectionFactory;

public abstract class AbstractDb4oDAO
extends AbstractDAO {
    static final int SEMAPHORE_WAIT_TIME = ConnectionFactory.getConnectionTimeout() * 1000;
    static final String GLOBAL_SEMAPHORE = "Lock";
    static final String SEMAPHORE_WARNING = "Could not obtain global semaphore";
    private static final int MAX_COMMIT_COUNT = 250;
    static final int MAX_COMMIT_TIME = 30;
    static final AtomicInteger commitCount = new AtomicInteger(0);
    private static final ReentrantLock commitLock = new ReentrantLock();
    ObjectContainer container;
    protected boolean isRemote = false;

    AbstractDb4oDAO(ObjectContainer container, boolean isRemote) {
        assert (container != null);
        this.isRemote = isRemote;
        this.container = container;
    }

    final void commit() {
        if (commitCount.getAndIncrement() >= 250 || this.isRemote) {
            this.commitAndReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void commitAndReset() {
        commitLock.lock();
        try {
            commitCount.set(0);
            this.container.commit();
        }
        finally {
            commitLock.unlock();
        }
    }
}

