/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.AccountTreeXMLFactory;
import jgnash.engine.EngineFactory;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.util.builder.Action;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

@Action(value="exportAccounts-command")
public class ExportAccountsAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = -3058427716241671433L;
    private static final String CURRENT_DIR = "cwd";

    private static void exportAccounts() {
        final Resource rb = Resource.get();
        Preferences pref = Preferences.userNodeForPackage(ExportAccountsAction.class);
        JFileChooser chooser = new JFileChooser(pref.get(CURRENT_DIR, null));
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(rb.getString("Label.XMLFiles") + " (*.xml)", "xml"));
        if (chooser.showSaveDialog(UIApplication.getFrame()) == 0) {
            pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final File file = new File(FileUtils.stripFileExtension(chooser.getSelectedFile().getAbsolutePath()) + ".xml");
            final class Export
            extends SwingWorker<Void, Void> {
                Export() {
                }

                @Override
                protected Void doInBackground() throws Exception {
                    UIApplication.getFrame().displayWaitMessage(rb.getString("Message.PleaseWait"));
                    AccountTreeXMLFactory.exportAccountTree(EngineFactory.getEngine("default"), file);
                    return null;
                }

                @Override
                protected void done() {
                    UIApplication.getFrame().stopWaitMessage();
                }
            }
            new Export().execute();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExportAccountsAction.exportAccounts();
    }
}

