/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.report.compiled.PortfolioReport;
import jgnash.ui.util.builder.Action;

@Action(value="report-portfolio-command")
public class PortfolioReportAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = 1L;

    public PortfolioReportAction() {
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        this.updateEnabledState();
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        PortfolioReportAction.this.setEnabled(false);
                        break;
                    }
                    case FILE_NEW_SUCCESS: 
                    case FILE_LOAD_SUCCESS: 
                    case ACCOUNT_REMOVE: 
                    case ACCOUNT_ADD: {
                        PortfolioReportAction.this.updateEnabledState();
                        break;
                    }
                }
            }
        });
    }

    private void updateEnabledState() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                final boolean enabled = PortfolioReportAction.this.hasInvestmentAccount();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PortfolioReportAction.this.setEnabled(enabled);
                    }
                });
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    private boolean hasInvestmentAccount() {
        Engine e = EngineFactory.getEngine("default");
        if (e != null) {
            return e.getInvestmentAccountList().size() > 0;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new PortfolioReport().showReport();
    }
}

