/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;

public class AccountListComboBox
extends JComboBox
implements MessageListener {
    private boolean layingOut = false;

    public AccountListComboBox() {
        this(new DefaultModel(null));
    }

    public AccountListComboBox(Account baseAccount) {
        this(new DefaultModel(baseAccount));
    }

    AccountListComboBox(AbstractModel model) {
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setModel(model);
        this.registerListeners();
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.SYSTEM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(dim.width, this.getPreferredSize().width);
        }
        return dim;
    }

    public static AccountListComboBox getFullInstance() {
        return new AccountListComboBox(new FullModel());
    }

    public static AccountListComboBox getParentTypeInstance(Account base, Set<AccountType> types) {
        return new AccountListComboBox(new ParentTypeModel(base, types));
    }

    public static AccountListComboBox getInstanceByType(Set<AccountType> types) {
        return new AccountListComboBox(new AccountTypeModel(types));
    }

    public Account getSelectedAccount() {
        return (Account)this.getSelectedItem();
    }

    public void setSelectedAccount(Account account) {
        super.setSelectedItem(account);
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
                    MessageBus.getInstance().unregisterListener(AccountListComboBox.this, MessageChannel.ACCOUNT, MessageChannel.SYSTEM);
                    ((AbstractModel)AccountListComboBox.this.getModel()).messagePosted(event);
                } else {
                    Account account = AccountListComboBox.this.getSelectedAccount();
                    ((AbstractModel)AccountListComboBox.this.getModel()).messagePosted(event);
                    if (account != null && event.getEvent() != ChannelEvent.ACCOUNT_REMOVE && !account.equals(event.getObject(MessageProperty.ACCOUNT))) {
                        AccountListComboBox.this.setSelectedAccount(account);
                    } else if (AccountListComboBox.this.getModel().getSize() > 0) {
                        AccountListComboBox.this.setSelectedIndex(0);
                    }
                }
            }
        });
    }

    private class Renderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        public Renderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                AccountListComboBox.this.setToolTipText(((Account)value).getPathName());
                return this.delegate.getListCellRendererComponent(list, AccountListComboBox.this.getToolTipText(), index, isSelected, cellHasFocus);
            }
            return this.delegate.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
        }
    }

    private static final class DefaultModel
    extends AbstractModel {
        private static final long serialVersionUID = -6114581770341251371L;

        public DefaultModel(Account exclude) {
            super(exclude);
            this.loadAccounts();
        }

        @Override
        protected void loadChildren(Account acc, List<Account> array) {
            for (Account account : acc.getChildren()) {
                if (!account.isLocked() && !account.isPlaceHolder() && account.isVisible() && this.baseAccount != account) {
                    array.add(account);
                }
                if (account.getChildCount() <= 0) continue;
                this.loadChildren(account, array);
            }
        }
    }

    private static final class AccountTypeModel
    extends AbstractModel {
        private static final long serialVersionUID = 8040377907241948715L;

        public AccountTypeModel(Set<AccountType> types) {
            super(null, types);
            this.loadAccounts();
        }

        @Override
        protected void loadChildren(Account acc, List<Account> array) {
            for (Account tAcc : acc.getChildren()) {
                if (!tAcc.isLocked() && !tAcc.isPlaceHolder() && this.types.contains((Object)tAcc.getAccountType())) {
                    array.add(tAcc);
                }
                if (tAcc.getChildCount() <= 0) continue;
                this.loadChildren(tAcc, array);
            }
        }
    }

    private static final class ParentTypeModel
    extends AbstractModel {
        private static final long serialVersionUID = 6101812950546413007L;

        public ParentTypeModel(Account base, Set<AccountType> types) {
            super(base, types);
            assert (base != null);
            this.loadAccounts();
        }

        @Override
        protected void loadChildren(Account acc, List<Account> array) {
            for (Account account : acc.getChildren()) {
                if (this.types.contains((Object)account.getAccountType()) && account.getChildCount() > 0) {
                    array.add(account);
                }
                if (account.getChildCount() <= 0) continue;
                this.loadChildren(account, array);
            }
        }
    }

    private static final class FullModel
    extends AbstractModel {
        private static final long serialVersionUID = 8022713346636034921L;

        public FullModel() {
            this.loadAccounts();
        }

        @Override
        protected void loadChildren(Account acc, List<Account> array) {
            for (Account child : acc.getChildren()) {
                array.add(child);
                if (child.getChildCount() <= 0) continue;
                this.loadChildren(child, array);
            }
        }
    }

    protected static abstract class AbstractModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -4037152571034212252L;
        List<Account> accounts = new ArrayList<Account>();
        Account baseAccount = null;
        Object selectedItem;
        Set<AccountType> types;
        private final Object lock = new Object();

        public AbstractModel() {
            this(null);
        }

        public AbstractModel(Account exclude, Set<AccountType> types) {
            this.baseAccount = exclude;
            this.types = types;
        }

        public AbstractModel(Account exclude) {
            this.baseAccount = exclude;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadAccounts() {
            Object object = this.lock;
            synchronized (object) {
                ArrayList<Account> list = new ArrayList<Account>();
                this.loadChildren(EngineFactory.getEngine("default").getRootAccount(), list);
                this.accounts.clear();
                this.accounts = list;
                if (!list.isEmpty()) {
                    this.selectedItem = this.accounts.get(0);
                }
            }
        }

        protected abstract void loadChildren(Account var1, List<Account> var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getElementAt(int index) {
            Object object = this.lock;
            synchronized (object) {
                return this.accounts.get(index);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getSize() {
            Object object = this.lock;
            synchronized (object) {
                return this.accounts.size();
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem != null && this.selectedItem != anItem || this.selectedItem == null && anItem != null) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        private void clear() {
            this.accounts.clear();
            this.baseAccount = null;
        }

        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case FILE_CLOSING: {
                    this.clear();
                    break;
                }
                case ACCOUNT_REMOVE: {
                    Account account = (Account)event.getObject(MessageProperty.ACCOUNT);
                    int index = this.accounts.indexOf(account);
                    if (index <= -1) break;
                    this.accounts.remove(index);
                    this.fireIntervalRemoved(this, index, index);
                    break;
                }
                case ACCOUNT_ADD: 
                case ACCOUNT_MODIFY: {
                    this.loadAccounts();
                    this.fireContentsChanged(this, 0, this.accounts.size());
                    break;
                }
            }
        }
    }
}

