/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionType;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AutoCompleteTextField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.autocomplete.DefaultAutoCompleteModel;
import jgnash.util.MultiHashMap;

public class AutoCompleteFactory {
    private static MemoModel memoModel;
    private static boolean autoComplete;
    private static boolean ignoreCase;
    private static final String AUTO_COMPLETE = "autoComplete";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final PropertyChangeSupport propertyChangeSupport;

    private AutoCompleteFactory() {
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public static void setEnabled(boolean auto) {
        boolean oldAutoComplete = autoComplete;
        autoComplete = auto;
        Preferences p = Preferences.userNodeForPackage(AutoCompleteFactory.class);
        p.putBoolean(AUTO_COMPLETE, autoComplete);
        propertyChangeSupport.firePropertyChange(AUTO_COMPLETE, oldAutoComplete, autoComplete);
    }

    public static void setIgnoreCase(boolean notCaseSensitive) {
        boolean oldIgnoreCase = ignoreCase;
        ignoreCase = notCaseSensitive;
        Preferences p = Preferences.userNodeForPackage(AutoCompleteFactory.class);
        p.putBoolean(IGNORE_CASE, ignoreCase);
        propertyChangeSupport.firePropertyChange(IGNORE_CASE, oldIgnoreCase, ignoreCase);
    }

    public static boolean isEnabled() {
        return autoComplete;
    }

    public static boolean ignoreCase() {
        return ignoreCase;
    }

    public static JTextField getMemoField() {
        if (autoComplete) {
            if (memoModel == null) {
                memoModel = new MemoModel();
            }
            return new AutoCompleteTextField(memoModel);
        }
        return new JTextFieldEx();
    }

    public static JTextField getPayeeField(Account account) {
        if (autoComplete) {
            return new AutoCompleteTextField(new PayeeAccountModel(account));
        }
        return new JTextFieldEx();
    }

    static {
        propertyChangeSupport = new PropertyChangeSupport(new Object());
        Preferences p = Preferences.userNodeForPackage(AutoCompleteFactory.class);
        autoComplete = p.getBoolean(AUTO_COMPLETE, true);
        ignoreCase = p.getBoolean(IGNORE_CASE, true);
    }

    private static class PayeeModel
    extends TransactionModel {
        MultiHashMap<String, Transaction> transactions = new MultiHashMap();

        private PayeeModel() {
        }

        @Override
        void load(Transaction tran) {
            String payee;
            if (tran != null && tran.getTransactionType() != TransactionType.SPLITENTRY && (payee = tran.getPayee()) != null) {
                this.addString(tran.getPayee());
                if (ignoreCase) {
                    this.transactions.put(tran.getPayee().toLowerCase(), (Object)tran);
                } else {
                    this.transactions.put(tran.getPayee(), (Object)tran);
                }
            }
        }

        @Override
        public Object getExtraInfo(String key) {
            if (ignoreCase) {
                return this.transactions.get(key.toLowerCase());
            }
            return this.transactions.get(key);
        }

        void removeExtraInfo(Transaction t) {
            if (ignoreCase) {
                this.transactions.remove(t.getPayee().toLowerCase(), t);
            }
            this.transactions.remove(t.getPayee(), t);
        }

        @Override
        public void messagePosted(Message event) {
            super.messagePosted(event);
            switch (event.getEvent()) {
                case TRANSACTION_REMOVE: {
                    this.removeExtraInfo((Transaction)event.getObject(MessageProperty.TRANSACTION));
                    return;
                }
            }
        }
    }

    private static final class PayeeAccountModel
    extends PayeeModel {
        private Account account;

        public PayeeAccountModel(Account account) {
            this.account = account;
        }

        @Override
        void load() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (PayeeAccountModel.this.account != null) {
                                for (Transaction t : PayeeAccountModel.this.account.getReadonlyTransactionList()) {
                                    PayeeAccountModel.this.load(t);
                                }
                            }
                        }
                    }).start();
                }
            });
        }

        @Override
        public void messagePosted(Message event) {
            Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
            switch (event.getEvent()) {
                case TRANSACTION_ADD: {
                    if (a.equals(this.account)) {
                        this.load(t);
                    }
                    return;
                }
                case FILE_NEW_SUCCESS: {
                    this.purge();
                    return;
                }
                case FILE_LOAD_SUCCESS: {
                    this.reload();
                    return;
                }
                case TRANSACTION_REMOVE: {
                    if (a.equals(this.account)) {
                        this.removeExtraInfo(t);
                    }
                    return;
                }
            }
        }
    }

    private static final class MemoModel
    extends PayeeModel {
        private MemoModel() {
        }

        @Override
        void load(Transaction tran) {
            if (tran != null) {
                this.addString(tran.getMemo());
            }
        }
    }

    private static abstract class TransactionModel
    extends DefaultAutoCompleteModel
    implements MessageListener {
        volatile boolean load = false;
        private PropertyChangeListener listener;

        public TransactionModel() {
            this.init();
            this.setIgnoreCase(AutoCompleteFactory.ignoreCase());
        }

        final void init() {
            MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION, MessageChannel.SYSTEM);
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(AutoCompleteFactory.IGNORE_CASE) && evt.getNewValue() != evt.getOldValue()) {
                        TransactionModel.this.setIgnoreCase((Boolean)evt.getNewValue());
                        TransactionModel.this.reload();
                    } else if (evt.getPropertyName().equals(AutoCompleteFactory.AUTO_COMPLETE) && evt.getNewValue() != evt.getOldValue()) {
                        TransactionModel.this.setEnabled((Boolean)evt.getNewValue());
                    }
                }
            };
            AutoCompleteFactory.addPropertyChangeListener(this.listener);
            this.load();
        }

        @Override
        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case TRANSACTION_ADD: {
                    Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                    this.load(t);
                    return;
                }
                case FILE_NEW_SUCCESS: {
                    this.purge();
                    return;
                }
                case FILE_LOAD_SUCCESS: {
                    this.reload();
                    return;
                }
                case FILE_CLOSING: {
                    this.load = false;
                    AutoCompleteFactory.removePropertyChangeListener(this.listener);
                    return;
                }
            }
        }

        void load() {
            this.load = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<Transaction> transactions = EngineFactory.getEngine("default").getTransactions();
                        Collections.sort(transactions);
                        for (Transaction t : transactions) {
                            if (TransactionModel.this.load) {
                                TransactionModel.this.load(t);
                                continue;
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(AutoCompleteFactory.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                }
            }).start();
        }

        final void reload() {
            this.purge();
            this.load();
        }

        abstract void load(Transaction var1);
    }
}

