/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingWorker;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.util.Resource;

public class TransactionNumberComboBox
extends JComboBox
implements ActionListener {
    private static final String[] defaultItems;
    private static final String nextNumberItem;
    private final Account account;

    public TransactionNumberComboBox(Account a) {
        super(defaultItems);
        List<String> items = EngineFactory.getEngine("default").getTransactionNumberList();
        ComboBoxModel model = this.getModel();
        for (String s : items) {
            ((DefaultComboBoxModel)model).addElement(s);
        }
        this.account = a;
        if (this.account != null) {
            JTextComponent e = (JTextComponent)this.getEditor().getEditorComponent();
            e.setDocument(new SelectionDocument());
        }
        this.setEditable(true);
    }

    public String getText() {
        return (String)this.getEditor().getItem();
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    private void clearSelection() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTextComponent e = (JTextComponent)TransactionNumberComboBox.this.getEditor().getEditorComponent();
                int length = e.getText().length();
                int position = e.getCaretPosition();
                e.setSelectionStart(length);
                e.setSelectionEnd(length);
                e.setCaretPosition(position);
            }
        });
    }

    static {
        Resource rb = Resource.get();
        nextNumberItem = rb.getString("Item.NextNum");
        defaultItems = new String[]{"", nextNumberItem, rb.getString("Item.Print")};
    }

    private class SetNextNumber
    extends SwingWorker<String, Object> {
        private SetNextNumber() {
        }

        @Override
        public String doInBackground() {
            return TransactionNumberComboBox.this.account.getNextTransactionNumber();
        }

        @Override
        protected void done() {
            try {
                TransactionNumberComboBox.this.setText((String)this.get());
                JTextComponent e = (JTextComponent)TransactionNumberComboBox.this.getEditor().getEditorComponent();
                int length = e.getText().length();
                e.setSelectionStart(length);
                e.setSelectionEnd(length);
                e.setCaretPosition(length);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class SelectionDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1987215600385777190L;

        private SelectionDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            String item = TransactionNumberComboBox.this.getText();
            if (item.equals(nextNumberItem)) {
                TransactionNumberComboBox.this.setPopupVisible(false);
                new SetNextNumber().execute();
            } else {
                TransactionNumberComboBox.this.clearSelection();
            }
        }
    }
}

