/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import jgnash.engine.Account;
import jgnash.engine.ReconcileManager;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.ui.register.AbstractExchangeTransactionPanel;
import jgnash.ui.register.PanelType;
import jgnash.ui.util.ValidationFactory;

public class TransferPanel
extends AbstractExchangeTransactionPanel {
    protected TransferPanel(Account account) {
        super(account, PanelType.DECREASE);
        this.layoutMainPanel();
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(48dlu;min)", "f:d, $nlgap, f:d, $nlgap, f:d, $nlgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5, 7}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add("Label.TransferTo", (Object)cc.xy(1, 1));
        this.add((Component)this.accountPanel, (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Memo", (Object)cc.xy(1, 3));
        this.add((Component)this.memoField, (Object)cc.xy(3, 3));
        this.add("Label.Amount", (Object)cc.xy(5, 3));
        this.add((Component)ValidationFactory.wrap(this.amountField), (Object)cc.xy(7, 3));
        this.add((Component)this.createBottomPanel(), (Object)cc.xyw(1, 7, 7));
    }

    @Override
    protected Transaction buildTransaction() {
        String number = "TRAN";
        String payee = this.rb.getString("Tab.Transfer");
        int signum = this.amountField.getDecimal().signum();
        Transaction transaction = this.panelType == PanelType.DECREASE && signum >= 0 || signum == -1 ? (this.hasEqualCurrencies() ? TransactionFactory.generateDoubleEntryTransaction(this.accountPanel.getSelectedAccount(), this.getAccount(), this.amountField.getDecimal().abs(), this.datePanel.getDate(), this.memoField.getText(), payee, number) : TransactionFactory.generateDoubleEntryTransaction(this.accountPanel.getSelectedAccount(), this.getAccount(), this.accountPanel.getExchangedAmount().abs(), this.amountField.getDecimal().abs().negate(), this.datePanel.getDate(), this.memoField.getText(), payee, number)) : (this.hasEqualCurrencies() ? TransactionFactory.generateDoubleEntryTransaction(this.getAccount(), this.accountPanel.getSelectedAccount(), this.amountField.getDecimal().abs(), this.datePanel.getDate(), this.memoField.getText(), payee, number) : TransactionFactory.generateDoubleEntryTransaction(this.getAccount(), this.accountPanel.getSelectedAccount(), this.amountField.getDecimal().abs(), this.accountPanel.getExchangedAmount().abs().negate(), this.datePanel.getDate(), this.memoField.getText(), payee, number));
        ReconcileManager.reconcileTransaction(this.getAccount(), transaction, this.reconciledButton.isSelected());
        return transaction;
    }

    @Override
    public void modifyTransaction(Transaction t) {
    }

    @Override
    protected boolean canModifyTransaction(Transaction t) {
        return false;
    }
}

