/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionTag;
import jgnash.ui.ThemeManager;
import jgnash.ui.components.JFloatField;
import jgnash.ui.plaf.NimbusUtils;
import jgnash.ui.register.invest.FeesDialog;
import jgnash.util.Resource;

class FeePanel
extends JPanel
implements ActionListener {
    private JFloatField feeField;
    private JButton feeButton;
    private Account account;
    private List<TransactionEntry> feeList = new ArrayList<TransactionEntry>();

    FeePanel(Account account) {
        this.account = account;
        this.layoutPanel();
    }

    void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    private void initComponents() {
        this.feeField = new JFloatField(this.account.getCurrencyNode());
        this.feeButton = new JButton(Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.feeButton.setMargin(new Insets(0, 0, 0, 0));
        this.feeButton.addActionListener(this);
        this.feeButton.setFocusPainted(false);
        if (ThemeManager.isLookAndFeelNimbus()) {
            NimbusUtils.reduceNimbusButtonMargin(this.feeButton);
            this.feeButton.setIcon(NimbusUtils.scaleIcon(Resource.getIcon("/jgnash/resource/document-properties.png")));
        }
    }

    private void fireActionPerformed() {
        ActionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (event == null) {
                event = new ActionEvent(this, 1001, null);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FeesDialog d;
        boolean status;
        if (e.getSource() == this.feeButton && (status = (d = FeesDialog.getFeesDialog(this, this.account, this.feeList)).showFeesDialog())) {
            this.setTransactionEntries(d.getSplits());
            this.fireActionPerformed();
        }
    }

    private void layoutPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g, 1px, min", "f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append((Component)this.feeField, (Component)this.feeButton);
    }

    public BigDecimal getDecimal() {
        return this.feeField.getDecimal();
    }

    public List<TransactionEntry> getTransactions() {
        if (this.feeList.isEmpty() && this.feeField.getDecimal().compareTo(BigDecimal.ZERO) != 0) {
            TransactionEntry fee = new TransactionEntry(this.account, this.feeField.getDecimal().abs().negate());
            fee.setTransactionTag(TransactionTag.INVESTMENT_FEE);
            this.feeList.add(fee);
        }
        return this.feeList;
    }

    public void setTransactionEntries(List<TransactionEntry> fees) {
        this.feeList = new ArrayList<TransactionEntry>();
        if (fees.size() == 1) {
            TransactionEntry e = fees.get(0);
            if (e.getCreditAccount().equals(e.getDebitAccount())) {
                this.feeField.setDecimal(e.getAmount(this.account).abs());
            } else {
                try {
                    this.feeList.add((TransactionEntry)e.clone());
                }
                catch (CloneNotSupportedException e1) {
                    Logger.getLogger(FeePanel.class.getName()).log(Level.SEVERE, e1.getLocalizedMessage(), e1);
                }
                this.feeField.setDecimal(this.sumFees().abs());
            }
        } else {
            for (TransactionEntry entry : fees) {
                try {
                    this.feeList.add((TransactionEntry)entry.clone());
                }
                catch (CloneNotSupportedException e) {
                    Logger.getLogger(FeePanel.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
            this.feeField.setDecimal(this.sumFees().abs());
        }
        this.feeField.setEditable(this.feeList.size() < 1);
    }

    private BigDecimal sumFees() {
        BigDecimal sum = BigDecimal.ZERO;
        for (TransactionEntry entry : this.feeList) {
            sum = sum.add(entry.getAmount(this.account));
        }
        return sum;
    }

    void clearForm() {
        this.feeList = new ArrayList<TransactionEntry>();
        this.feeField.setDecimal(null);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.feeField.addFocusListener(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.feeField.removeFocusListener(l);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.feeField.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.feeField.removeKeyListener(l);
    }
}

