/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionType;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.register.AbstractEntryFormPanel;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.invest.AddRemoveSharePanel;
import jgnash.ui.register.invest.BuySharePanel;
import jgnash.ui.register.invest.CashTransactionPanel;
import jgnash.ui.register.invest.DividendPanel;
import jgnash.ui.register.invest.ReinvestDividendPanel;
import jgnash.ui.register.invest.ReturnOfCapitalPanel;
import jgnash.ui.register.invest.SellSharePanel;
import jgnash.ui.register.invest.SplitMergeSharePanel;
import jgnash.util.Resource;

public class InvestmentTransactionPanel
extends JPanel
implements MessageListener,
ActionListener {
    private Account account;
    private Transaction modTrans;
    private int currentCard;
    private CardLayout cardLayout;
    private JButton enterButton;
    private JButton cancelButton;
    private JPanel cardPanel;
    private JComboBox actionCombo;
    private AbstractEntryFormPanel[] cards = new AbstractEntryFormPanel[0];
    private final Resource rb = Resource.get();
    private static String[] actions;

    InvestmentTransactionPanel(Account account) {
        this.account = account;
        this.layoutMainPanel();
        this.cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.loadCards();
        this.registerListeners();
        this.enterButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    InvestmentTransactionPanel.this.enterAction();
                }
            }
        });
    }

    private void initComponents() {
        this.actionCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(actions));
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.enterButton = new JButton(this.rb.getString("Button.Enter"));
        this.cancelButton = new JButton(this.rb.getString("Button.Clear"));
        this.cancelButton.addActionListener(this);
        this.enterButton.addActionListener(this);
        this.actionCombo.addActionListener(this);
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("d, 4dlu, m:g, 4dlu, m", "f:d, $ugap, f:d");
        CellConstraints cc = new CellConstraints();
        this.setBorder(new CompoundBorder(new ShadowBorder(), Borders.TABBED_DIALOG_BORDER));
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.cardPanel, cc.xyw(1, 1, 5));
        this.add((Component)new JSeparator(), cc.xyw(1, 2, 5));
        this.add((Component)new JLabel(this.rb.getString("Label.Action")), cc.xy(1, 3));
        this.add((Component)this.actionCombo, cc.xy(3, 3));
        this.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.enterButton, (JButton)this.cancelButton), cc.xy(5, 3));
    }

    void addRegisterListener(RegisterListener l) {
        this.listenerList.add(RegisterListener.class, l);
    }

    private void fireCancelAction() {
        RegisterEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegisterListener.class) continue;
            if (e == null) {
                e = new RegisterEvent(this, RegisterEvent.Action.CANCEL);
            }
            ((RegisterListener)listeners[i + 1]).registerEvent(e);
        }
    }

    private void fireOkAction() {
        RegisterEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegisterListener.class) continue;
            if (e == null) {
                e = new RegisterEvent(this, RegisterEvent.Action.OK);
            }
            ((RegisterListener)listeners[i + 1]).registerEvent(e);
        }
    }

    void cancelAction() {
        this.cards[this.currentCard].clearForm();
        this.modTrans = null;
        this.fireCancelAction();
    }

    void enterAction() {
        this.cards[this.currentCard].enterAction();
        this.fireOkAction();
    }

    private void actionAction() {
        this.activateCard(this.actionCombo.getSelectedIndex());
    }

    void modifyTransaction(Transaction t) {
        this.modTrans = t;
        if (t instanceof InvestmentTransaction) {
            switch (t.getTransactionType()) {
                case BUYSHARE: {
                    this.actionCombo.setSelectedItem(actions[0]);
                    break;
                }
                case SELLSHARE: {
                    this.actionCombo.setSelectedItem(actions[1]);
                    break;
                }
                case ADDSHARE: {
                    this.actionCombo.setSelectedItem(actions[4]);
                    break;
                }
                case REMOVESHARE: {
                    this.actionCombo.setSelectedItem(actions[5]);
                    break;
                }
                case REINVESTDIV: {
                    this.actionCombo.setSelectedItem(actions[6]);
                    break;
                }
                case DIVIDEND: {
                    this.actionCombo.setSelectedItem(actions[7]);
                    break;
                }
                case SPLITSHARE: {
                    this.actionCombo.setSelectedItem(actions[8]);
                    break;
                }
                case MERGESHARE: {
                    this.actionCombo.setSelectedItem(actions[9]);
                    break;
                }
                case RETURNOFCAPITAL: {
                    this.actionCombo.setSelectedItem(actions[10]);
                    break;
                }
            }
        } else if (t.getAmount(this.account).signum() >= 0) {
            this.actionCombo.setSelectedItem(actions[2]);
        } else {
            this.actionCombo.setSelectedItem(actions[3]);
        }
        this.cards[this.currentCard].modifyTransaction(t);
    }

    private void loadCards() {
        this.cards = new AbstractEntryFormPanel[11];
        this.cards[0] = new BuySharePanel(this.account);
        this.cards[1] = new SellSharePanel(this.account);
        this.cards[2] = new CashTransactionPanel(this.account, PanelType.INCREASE);
        this.cards[3] = new CashTransactionPanel(this.account, PanelType.DECREASE);
        this.cards[4] = new AddRemoveSharePanel(this.account, TransactionType.ADDSHARE);
        this.cards[5] = new AddRemoveSharePanel(this.account, TransactionType.REMOVESHARE);
        this.cards[6] = new ReinvestDividendPanel(this.account);
        this.cards[7] = new DividendPanel(this.account);
        this.cards[8] = new SplitMergeSharePanel(this.account, TransactionType.SPLITSHARE);
        this.cards[9] = new SplitMergeSharePanel(this.account, TransactionType.MERGESHARE);
        this.cards[10] = new ReturnOfCapitalPanel(this.account);
        for (int i = 0; i < actions.length; ++i) {
            this.cardPanel.add((Component)this.cards[i], actions[i]);
        }
    }

    private void activateCard(int index) {
        this.cards[this.currentCard].clearForm();
        this.cardLayout.show(this.cardPanel, actions[index]);
        this.currentCard = index;
    }

    @Override
    public void messagePosted(Message event) {
        if (this.modTrans != null) {
            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
            switch (event.getEvent()) {
                case TRANSACTION_REMOVE: {
                    if (!this.modTrans.equals(t)) break;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InvestmentTransactionPanel.this.cancelAction();
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (e.getSource() == this.enterButton) {
            this.enterAction();
        } else if (e.getSource() == this.actionCombo) {
            this.actionAction();
        }
    }

    static {
        Resource eRb = Resource.get();
        actions = new String[]{eRb.getString("Transaction.BuyShare"), eRb.getString("Transaction.SellShare"), eRb.getString("Transaction.TransferIn"), eRb.getString("Transaction.TransferOut"), eRb.getString("Transaction.AddShare"), eRb.getString("Transaction.RemoveShare"), eRb.getString("Transaction.ReinvestDiv"), eRb.getString("Transaction.Dividend"), eRb.getString("Transaction.SplitShare"), eRb.getString("Transaction.MergeShare"), eRb.getString("Transaction.ReturnOfCapital")};
    }
}

