/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.util;

import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.ResizeableArrayList;
import java.util.Stack;

public class UnionFind {
    ResizeableArrayList nodes;

    public UnionFind() {
        this.nodes = new ResizeableArrayList();
    }

    public UnionFind(int size) {
        this.nodes = new ResizeableArrayList(size);
    }

    public Node findNode(int a) {
        this.nodes.ensureSize(a + 1);
        Node na = (Node)this.nodes.get(a);
        if (na == null) {
            Node root = new Node(a);
            root.child = new Node(a);
            root.child.parent = root;
            this.nodes.set(a, root.child);
            return root;
        }
        return this.findNode(na);
    }

    public int find(int a) {
        return this.findNode((int)a).value;
    }

    private Node findNode(Node node) {
        Stack<Node> stack = new Stack<Node>();
        while (node.parent.child == null) {
            stack.push(node);
            node = node.parent;
        }
        Node rootChild = node;
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.parent = rootChild;
        }
        Assert.isTrue(rootChild.parent.child != null);
        return rootChild.parent;
    }

    public boolean isEquiv(int a, int b) {
        return this.findNode(a) == this.findNode(b);
    }

    public void union(int a, int b) {
        Node nb;
        Node na = this.findNode(a);
        if (na == (nb = this.findNode(b))) {
            return;
        }
        if (na.rank > nb.rank) {
            nb.child.parent = na.child;
            na.value = b;
        } else {
            na.child.parent = nb.child;
            nb.value = b;
            if (na.rank == nb.rank) {
                ++nb.rank;
            }
        }
    }

    class Node {
        Node parent;
        Node child;
        int value;
        int rank;

        public Node(int v) {
            this.value = v;
            this.rank = 0;
        }
    }
}

