/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.SocketClient;

public class IOHelper {
    private static File homeDirectory = new File(".");

    public static File getHomeDirectory() {
        return homeDirectory;
    }

    public static void setHomeDirectory(String newHome) {
        homeDirectory = new File(newHome);
    }

    public static OutputStream createOutputStream(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        return connection.getOutputStream();
    }

    public static OutputStream createOutputStream(String file) throws Exception {
        File fil = new File(file);
        fil.getParentFile().mkdirs();
        return new FileOutputStream(fil);
    }

    public static void setProxy() {
        if (Prefs.getBoolPref(PrefName.USE_PROXY)) {
            String host = Prefs.getPref(PrefName.PROXY_HOST);
            System.setProperty("http.proxyHost", host);
            System.setProperty("https.proxyHost", host);
            int port = Prefs.getIntPref(PrefName.PROXY_PORT);
            System.setProperty("http.proxyPort", Integer.toString(port));
            System.setProperty("https.proxyPort", Integer.toString(port));
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("https.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("https.proxyPort");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendMessage(String msg) {
        int port = Prefs.getIntPref(PrefName.SOCKETPORT);
        if (port == -1) return;
        try {
            String resp = SocketClient.sendMsg("localhost", port, msg);
            if (resp != null && !resp.equals("ok")) return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void sendLogMessage(String msg) {
        IOHelper.sendMessage("log:" + msg);
    }
}

