/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.IOHelper;
import net.sf.borg.common.PrefName;

public class Prefs {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static String prefRootNode = "net/sf/borg/common/util";
    private static ArrayList<Listener> listeners = new ArrayList();

    public static void addListener(Listener listener) {
        listeners.add(listener);
    }

    public static void notifyListeners() {
        for (int i = 0; i < listeners.size(); ++i) {
            Listener v = listeners.get(i);
            v.prefsChanged();
        }
    }

    public static String getPref(PrefName pn) {
        Object o = Prefs.getPrefObject(pn);
        if (o instanceof Integer) {
            return Integer.toString((Integer)o);
        }
        return (String)Prefs.getPrefObject(pn);
    }

    public static int getIntPref(PrefName pn) {
        return (Integer)Prefs.getPrefObject(pn);
    }

    public static boolean getBoolPref(PrefName pn) {
        String s = Prefs.getPref(pn);
        return s != null && s.equals("true");
    }

    private static Object getPrefObject(PrefName pn) {
        Preferences prefs = Prefs.getPrefNode();
        if (pn.getDefault() instanceof Integer) {
            int val = prefs.getInt(pn.getName(), (Integer)pn.getDefault());
            return new Integer(val);
        }
        String val = prefs.get(pn.getName(), (String)pn.getDefault());
        return val;
    }

    public static void putPref(PrefName pn, Object val) {
        log.fine("putpref-" + pn.getName() + "-" + val);
        Preferences prefs = Prefs.getPrefNode();
        if (pn.getDefault() instanceof Integer) {
            if (val instanceof Integer) {
                prefs.putInt(pn.getName(), (Integer)val);
            } else {
                prefs.putInt(pn.getName(), Integer.parseInt((String)val));
            }
        } else {
            prefs.put(pn.getName(), (String)val);
        }
    }

    private static Preferences getPrefNode() {
        Preferences root = Preferences.userRoot();
        return root.node(prefRootNode);
    }

    private Prefs() {
    }

    public static void importPrefs(String filename) throws Exception {
        FileInputStream istr = new FileInputStream(filename);
        Preferences.importPreferences(istr);
        ((InputStream)istr).close();
    }

    public static void export(String filename) {
        try {
            OutputStream oostr = IOHelper.createOutputStream(filename);
            Preferences prefs = Prefs.getPrefNode();
            prefs.exportNode(oostr);
            oostr.close();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public static String getPrefRootNode() {
        return prefRootNode;
    }

    public static void setPrefRootNode(String prefRootNode) {
        Prefs.prefRootNode = prefRootNode;
    }

    public static interface Listener {
        public void prefsChanged();
    }
}

