/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrintHelper {
    private static void initPrinterJobFields(PrinterJob job) {
        job.setJobName("BORG Printout");
        Class<?> klass = job.getClass();
        try {
            Class<?> printServiceClass = Class.forName("javax.print.PrintService");
            Method method = klass.getMethod("getPrintService", null);
            Object printService = method.invoke((Object)job, (Object[])null);
            method = klass.getMethod("setPrintService", printServiceClass);
            method.invoke((Object)job, printService);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static void printPrintable(Printable p) throws Exception {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintHelper.initPrinterJobFields(printJob);
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        pageFormat.setOrientation(0);
        paper.setSize(612.0, 792.0);
        paper.setImageableArea(63.0, 45.0, 486.0, 702.0);
        pageFormat.setPaper(paper);
        printJob.setPrintable(p, pageFormat);
        if (printJob.printDialog()) {
            printJob.print();
        }
    }
}

