/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.common;

import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;

public class SendJavaMail {
    private static final Logger log = Logger.getLogger("net.sf.borg");

    public static void sendMail(String host, String msgText, String subject, String from, String to, String user, String pass) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        String port = Prefs.getPref(PrefName.EMAILPORT);
        props.put("mail.smtp.port", port);
        String ed = Prefs.getPref(PrefName.EMAILDEBUG);
        if (ed.equals("1")) {
            props.put("mail.debug", "true");
        }
        if (Prefs.getBoolPref(PrefName.ENABLETLS)) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        MyAuthenticator auth = null;
        if (user != null && !user.equals("") && pass != null && !pass.equals("")) {
            auth = new MyAuthenticator(user, pass);
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, auth);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setText(msgText);
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            SendJavaMail.processMessagingException(mex);
            throw mex;
        }
    }

    public static void sendMailWithAttachments(String host, String msgText, String subject, String from, String to, String user, String pass, String[] attachments) throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        String port = Prefs.getPref(PrefName.EMAILPORT);
        props.put("mail.smtp.port", port);
        String ed = Prefs.getPref(PrefName.EMAILDEBUG);
        if (ed.equals("1")) {
            props.put("mail.debug", "true");
        }
        if (Prefs.getBoolPref(PrefName.ENABLETLS)) {
            props.put("mail.smtp.starttls.enable", "true");
        }
        MyAuthenticator auth = null;
        if (user != null && !user.equals("") && pass != null && !pass.equals("")) {
            auth = new MyAuthenticator(user, pass);
            props.put("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, auth);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart textpart = new MimeBodyPart();
            textpart.setText(msgText);
            mp.addBodyPart((BodyPart)textpart);
            for (String filename : attachments) {
                File file = new File(filename);
                MimeBodyPart attpart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(file);
                attpart.setDataHandler(new DataHandler((DataSource)source));
                attpart.setFileName(file.getName());
                mp.addBodyPart((BodyPart)attpart);
            }
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            SendJavaMail.processMessagingException(mex);
            throw mex;
        }
    }

    private static void processMessagingException(MessagingException mex) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n--Exception handling in BORG.SendJavaMail\n");
        mex.printStackTrace();
        Throwable ex = mex;
        do {
            Address[] validSent;
            Address[] validUnsent;
            if (!(ex instanceof SendFailedException)) continue;
            SendFailedException sfex = (SendFailedException)ex;
            Address[] invalid = sfex.getInvalidAddresses();
            if (invalid != null) {
                buf.append("    ** Invalid Addresses\n");
                for (int i = 0; i < invalid.length; ++i) {
                    buf.append("         " + invalid[i] + "\n");
                }
            }
            if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                buf.append("    ** ValidUnsent Addresses\n");
                for (int i = 0; i < validUnsent.length; ++i) {
                    buf.append("         " + validUnsent[i] + "\n");
                }
            }
            if ((validSent = sfex.getValidSentAddresses()) == null) continue;
            buf.append("    ** ValidSent Addresses\n");
            for (int i = 0; i < validSent.length; ++i) {
                buf.append("         " + validSent[i] + "\n");
            }
        } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        log.severe(buf.toString());
    }

    private static class MyAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public MyAuthenticator(String user, String pass) {
            this.username = user;
            this.password = pass;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

