/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MainMenu;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.UIControl;
import net.sf.borg.ui.View;
import net.sf.borg.ui.options.StartupViewsOptionsPanel;
import net.sf.borg.ui.util.JTabbedPaneWithCloseIcons;

public class MultiView
extends View {
    private static final long serialVersionUID = 1L;
    private static PrefName MULTIVIEWSIZE = new PrefName("dayviewsize", "-1,-1,-1,-1,Y");
    private static MultiView mainView = null;
    private JToolBar bar = new JToolBar();
    MainMenu mainMenu = new MainMenu();
    private List<Module> moduleSet = new ArrayList<Module>();
    private JTabbedPaneWithCloseIcons tabs_ = null;
    private int toolBarInsertIndex = 0;

    public static MultiView getMainView() {
        if (mainView == null) {
            mainView = new MultiView();
        }
        return mainView;
    }

    private MultiView() {
        this.getLayeredPane().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (SunTrayIconProxy.hasTrayIcon()) {
                    MultiView.this.closeMainwindow();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getLayeredPane().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                Component c = MultiView.this.getTabs().getSelectedComponent();
                MultiView.this.getTabs().remove(c);
            }
        }, KeyStroke.getKeyStroke(127, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MultiView.this.closeMainwindow();
            }
        });
        JMenuBar menubar = this.mainMenu.getMenuBar();
        menubar.setBorder(new BevelBorder(0));
        this.setJMenuBar(menubar);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mainMenu.addAction(new ImageIcon(this.getClass().getResource("/resource/Print16.gif")), Resource.getResourceString("Print"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiView.this.print();
            }
        }, 0);
        this.mainMenu.addAction(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")), Resource.getResourceString("close_tabs"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiView.this.closeTabs();
            }
        }, 1);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        this.getContentPane().add((Component)this.getToolBar(), cons);
        cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        this.getContentPane().add((Component)this.getTabs(), cons);
        this.setTitle("BORG");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setView(ViewType.MONTH);
        this.manageMySize(MULTIVIEWSIZE);
    }

    public void addToolBarItem(Icon icon, String tooltip, ActionListener action) {
        JButton button = new JButton(icon);
        button.setToolTipText(tooltip);
        button.addActionListener(action);
        this.bar.add((Component)button, this.toolBarInsertIndex);
        this.mainMenu.addAction(icon, tooltip, action, this.toolBarInsertIndex++);
    }

    public void addOptionsMenuItem(JMenuItem item) {
        this.mainMenu.addOptionsMenuItem(item);
    }

    public void addHelpMenuItem(Icon icon, String tooltip, ActionListener action) {
        this.mainMenu.addHelpMenuItem(icon, tooltip, action);
    }

    public void addPluginSubMenu(JMenu menu) {
        this.mainMenu.addPluginSubMenu(menu);
    }

    private void closeMainwindow() {
        if (!SunTrayIconProxy.hasTrayIcon() && this == mainView) {
            UIControl.shutDownUI();
        } else {
            this.dispose();
        }
    }

    public void closeSelectedTab() {
        this.tabs_.closeSelectedTab();
    }

    public void closeTabs() {
        this.tabs_.closeClosableTabs();
    }

    @Override
    public void destroy() {
        this.dispose();
        mainView = null;
    }

    public void setTabTitle(String title, Component c) {
        int i = this.tabs_.indexOfComponent(c);
        if (i >= 0) {
            this.tabs_.setTitleAt(i, title);
        }
    }

    public void addView(String title, Component c) {
        this.tabs_.addTab(title, c);
        this.tabs_.setSelectedIndex(this.tabs_.getTabCount() - 1);
    }

    public void removeView(String title) {
        int i = this.tabs_.indexOfTab(title);
        while (i >= 0) {
            this.tabs_.remove(i);
            i = this.tabs_.indexOfTab(title);
        }
    }

    public Module getModuleForView(ViewType type) {
        for (Module m : this.moduleSet) {
            if (type != m.getViewType()) continue;
            return m;
        }
        return null;
    }

    private JTabbedPane getTabs() {
        if (this.tabs_ == null) {
            this.tabs_ = new JTabbedPaneWithCloseIcons();
        }
        return this.tabs_;
    }

    private JToolBar getToolBar() {
        this.bar.setFloatable(false);
        JButton printbut = new JButton(new ImageIcon(this.getClass().getResource("/resource/Print16.gif")));
        printbut.setToolTipText(Resource.getResourceString("Print"));
        printbut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiView.this.print();
            }
        });
        this.bar.add(printbut);
        this.bar.addSeparator();
        JButton clearbut = new JButton(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        clearbut.setToolTipText(Resource.getResourceString("close_tabs"));
        clearbut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiView.this.closeTabs();
            }
        });
        this.bar.add(clearbut);
        return this.bar;
    }

    public void goTo(Calendar cal) {
        for (Module m : this.moduleSet) {
            if (!(m instanceof CalendarModule)) continue;
            ((CalendarModule)m).goTo(cal);
        }
    }

    public void addModule(Module m) {
        this.moduleSet.add(m);
        m.initialize(this);
    }

    public void print() {
        Component c = this.getTabs().getSelectedComponent();
        for (Module m : this.moduleSet) {
            if (m.getComponent() != c) continue;
            m.print();
            return;
        }
        Errmsg.getErrorHandler().notice(Resource.getResourceString("No_Print"));
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public Component setView(ViewType type) {
        Module m = this.getModuleForView(type);
        if (m != null) {
            Component component = m.getComponent();
            if (component != null) {
                if (component instanceof DockableView) {
                    ((DockableView)component).showView();
                    if (((DockableView)component).isDocked()) {
                        this.getTabs().setSelectedComponent(component);
                        if (!this.isShowing() || this.getState() == 1) {
                            MultiView.getMainView().setVisible(true);
                            MultiView.getMainView().toFront();
                            MultiView.getMainView().setState(0);
                        }
                    }
                    return component;
                }
                if (!component.isDisplayable()) {
                    this.tabs_.addTab(m.getModuleName(), component);
                }
                this.getTabs().setSelectedComponent(component);
                if (!this.isShowing() || this.getState() == 1) {
                    MultiView.getMainView().setVisible(true);
                    MultiView.getMainView().toFront();
                    MultiView.getMainView().setState(0);
                }
            }
            return component;
        }
        return null;
    }

    public void startupViews(boolean bgStart) {
        for (ViewType vt : ViewType.values()) {
            if (!StartupViewsOptionsPanel.getStartPref(vt)) continue;
            if (bgStart) {
                Component component;
                Module m = this.getModuleForView(vt);
                if (m == null || (component = m.getComponent()) == null) continue;
                if (component instanceof DockableView) {
                    ((DockableView)component).bgStart();
                    continue;
                }
                this.tabs_.addTab(m.getModuleName(), component);
                continue;
            }
            this.setView(vt);
        }
    }

    public void addMenu(JMenu m) {
        this.mainMenu.getMenuBar().add(m);
    }

    public static enum ViewType {
        DAY,
        MONTH,
        WEEK,
        YEAR,
        TASK,
        MEMO,
        SEARCH,
        TODO,
        ADDRESS,
        CHECKLIST;

    }

    public static interface CalendarModule
    extends Module {
        public void goTo(Calendar var1);
    }

    public static interface Module {
        public String getModuleName();

        public ViewType getViewType();

        public Component getComponent();

        public void print();

        public void initialize(MultiView var1);
    }
}

