/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.SearchCriteria;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.address.AddressView;
import net.sf.borg.ui.calendar.AppointmentListView;
import net.sf.borg.ui.memo.MemoPanel;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

public class SearchView
extends DockableView
implements MultiView.Module {
    private static final long serialVersionUID = 1L;
    private JCheckBox addressCheckBox = null;
    private JCheckBox apptCheckBox = null;
    private JCheckBox caseSensitiveCheckBox = null;
    private JComboBox<String> categoryComboBox = null;
    private JDateChooser endDateChooser = null;
    private JCheckBox holidayCheckBox = null;
    private JCheckBox linkCheckBox = null;
    private JCheckBox memoCheckBox = null;
    private JCheckBox projectCheckBox = null;
    private JCheckBox repeatCheckBox = null;
    private StripedTable resultsTable = null;
    private JTextField searchText = null;
    private JDateChooser startDateChooser = null;
    private JCheckBox taskCheckBox = null;
    private JCheckBox todoCheckBox = null;
    private JCheckBox wholeWordBox = null;
    private JCheckBox vacationCheckBox = null;
    private boolean isInitialized = false;

    private void loadCategories() {
        this.categoryComboBox.removeAllItems();
        this.categoryComboBox.addItem("");
        try {
            Collection cats = CategoryModel.getReference().getCategories();
            Iterator it = cats.iterator();
            while (it.hasNext()) {
                this.categoryComboBox.addItem((String)it.next());
            }
            this.categoryComboBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private JButton createChangeCategoryButton() {
        JButton changeCategoryButton = new JButton();
        ResourceHelper.setText(changeCategoryButton, "chg_cat");
        changeCategoryButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")));
        changeCategoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SearchView.this.resultsTable.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                try {
                    Collection allcats = CategoryModel.getReference().getCategories();
                    Object[] cats = allcats.toArray();
                    Object o = JOptionPane.showInputDialog(null, Resource.getResourceString("cat_choose"), "", 3, null, cats, cats[0]);
                    if (o == null) {
                        return;
                    }
                    String cat = (String)o;
                    if (cat.isEmpty() || CategoryModel.UNCATEGORIZED.equals(cat)) {
                        cat = null;
                    }
                    TableSorter tm = (TableSorter)SearchView.this.resultsTable.getModel();
                    ArrayList<KeyedEntity> entities = new ArrayList<KeyedEntity>();
                    for (int i = 0; i < rows.length; ++i) {
                        Integer key = (Integer)tm.getValueAt(rows[i], 3);
                        Class cl = (Class)tm.getValueAt(rows[i], 4);
                        try {
                            KeyedEntity ent = (KeyedEntity)cl.newInstance();
                            ent.setKey(key.intValue());
                            entities.add(ent);
                            continue;
                        }
                        catch (Exception e1) {
                            Errmsg.getErrorHandler().errmsg(e1);
                        }
                    }
                    for (KeyedEntity ent : entities) {
                        Appointment ap;
                        if (ent instanceof Appointment) {
                            ap = AppointmentModel.getReference().getAppt(ent.getKey());
                            ap.setCategory(cat);
                            AppointmentModel.getReference().saveAppt(ap);
                        }
                        if (ent instanceof Project) {
                            ap = TaskModel.getReference().getProject(ent.getKey());
                            ap.setCategory(cat);
                            TaskModel.getReference().saveProject((Project)ap);
                        }
                        if (!(ent instanceof Task)) continue;
                        ap = TaskModel.getReference().getTask(ent.getKey());
                        ap.setCategory(cat);
                        TaskModel.getReference().savetask((Task)ap);
                    }
                }
                catch (Exception ex) {
                    Errmsg.getErrorHandler().errmsg(ex);
                    return;
                }
                SearchView.this.refresh();
            }
        });
        return changeCategoryButton;
    }

    private JPanel createCheckBoxPanel() {
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new GridBagLayout());
        this.apptCheckBox = new JCheckBox();
        this.apptCheckBox.setSelected(true);
        ResourceHelper.setText(this.apptCheckBox, "appointment");
        checkBoxPanel.add((Component)this.apptCheckBox, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.taskCheckBox = new JCheckBox();
        this.taskCheckBox.setSelected(true);
        ResourceHelper.setText(this.taskCheckBox, "task");
        checkBoxPanel.add((Component)this.taskCheckBox, GridBagConstraintsFactory.create(2, 0, 1, 1.0, 1.0));
        this.addressCheckBox = new JCheckBox();
        this.addressCheckBox.setSelected(true);
        ResourceHelper.setText(this.addressCheckBox, "Address");
        checkBoxPanel.add((Component)this.addressCheckBox, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 1.0));
        this.projectCheckBox = new JCheckBox();
        this.projectCheckBox.setSelected(true);
        ResourceHelper.setText(this.projectCheckBox, "project");
        checkBoxPanel.add((Component)this.projectCheckBox, GridBagConstraintsFactory.create(3, 0, 1, 1.0, 1.0));
        this.memoCheckBox = new JCheckBox();
        this.memoCheckBox.setSelected(true);
        ResourceHelper.setText(this.memoCheckBox, "memo");
        checkBoxPanel.add((Component)this.memoCheckBox, GridBagConstraintsFactory.create(4, 0, 1, 1.0, 1.0));
        this.todoCheckBox = new JCheckBox();
        ResourceHelper.setText(this.todoCheckBox, "To_Do");
        checkBoxPanel.add((Component)this.todoCheckBox, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
        this.repeatCheckBox = new JCheckBox();
        ResourceHelper.setText(this.repeatCheckBox, "repeating");
        checkBoxPanel.add((Component)this.repeatCheckBox, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 1.0));
        this.vacationCheckBox = new JCheckBox();
        ResourceHelper.setText(this.vacationCheckBox, "Vacation");
        checkBoxPanel.add((Component)this.vacationCheckBox, GridBagConstraintsFactory.create(2, 1, 1, 1.0, 1.0));
        this.holidayCheckBox = new JCheckBox();
        ResourceHelper.setText(this.holidayCheckBox, "Holiday");
        checkBoxPanel.add((Component)this.holidayCheckBox, GridBagConstraintsFactory.create(3, 1, 1, 1.0, 1.0));
        this.linkCheckBox = new JCheckBox();
        this.linkCheckBox.setText(Resource.getResourceString("haslinks"));
        checkBoxPanel.add((Component)this.linkCheckBox, GridBagConstraintsFactory.create(4, 1, 1, 1.0, 1.0));
        return checkBoxPanel;
    }

    private JButton createDeleteButton() {
        JButton deleteButton = new JButton();
        ResourceHelper.setText(deleteButton, "delete_selected");
        deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Stop16.gif")));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = SearchView.this.resultsTable.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("delete_selected") + "?", "", 0);
                if (ret != 0) {
                    return;
                }
                TableSorter tm = (TableSorter)SearchView.this.resultsTable.getModel();
                ArrayList<KeyedEntity> entities = new ArrayList<KeyedEntity>();
                for (int i = 0; i < rows.length; ++i) {
                    Integer key = (Integer)tm.getValueAt(rows[i], 3);
                    Class cl = (Class)tm.getValueAt(rows[i], 4);
                    try {
                        KeyedEntity ent = (KeyedEntity)cl.newInstance();
                        ent.setKey(key.intValue());
                        if (ent instanceof Memo) {
                            ((Memo)ent).setMemoName((String)tm.getValueAt(rows[i], 0));
                        }
                        entities.add(ent);
                        continue;
                    }
                    catch (Exception e1) {
                        Errmsg.getErrorHandler().errmsg(e1);
                    }
                }
                for (KeyedEntity ent : entities) {
                    if (ent instanceof Appointment) {
                        AppointmentModel.getReference().delAppt(ent.getKey());
                        continue;
                    }
                    if (ent instanceof Address) {
                        AddressModel.getReference().delete((Address)ent);
                        continue;
                    }
                    if (!(ent instanceof Memo)) continue;
                    MemoModel.getReference().delete(((Memo)ent).getMemoName(), false);
                }
                SearchView.this.refresh();
            }
        });
        return deleteButton;
    }

    private JPanel createResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new GridBagLayout());
        resultsPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("Search_Results"), 0, 0, null, null));
        this.resultsTable = new StripedTable();
        this.resultsTable.setSelectionMode(2);
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                try {
                    SearchView.this.showSelectedItem();
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                }
            }
        });
        JScrollPane tableScroll = new JScrollPane();
        tableScroll.setViewportView(this.resultsTable);
        GridBagConstraints gridBagConstraints2 = GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0);
        gridBagConstraints2.gridwidth = 2;
        resultsPanel.add((Component)tableScroll, gridBagConstraints2);
        resultsPanel.add((Component)this.createDeleteButton(), GridBagConstraintsFactory.create(0, 1, 0, 1.0, 0.0));
        resultsPanel.add((Component)this.createChangeCategoryButton(), GridBagConstraintsFactory.create(1, 1, 0, 1.0, 0.0));
        return resultsPanel;
    }

    private JPanel createSearchCriteriaPanel() {
        JPanel searchCriteriaPanel = new JPanel();
        searchCriteriaPanel.setLayout(new GridBagLayout());
        searchCriteriaPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        JLabel searchStringLabel = new JLabel();
        ResourceHelper.setText(searchStringLabel, "SearchString");
        searchCriteriaPanel.add((Component)searchStringLabel, GridBagConstraintsFactory.create(0, 0, 2));
        JLabel categoryLabel = new JLabel();
        ResourceHelper.setText(categoryLabel, "Category");
        searchCriteriaPanel.add((Component)categoryLabel, GridBagConstraintsFactory.create(0, 1, 2));
        this.searchText = new JTextField();
        searchCriteriaPanel.add((Component)this.searchText, GridBagConstraintsFactory.create(1, 0, 2, 1.0, 0.0));
        this.categoryComboBox = new JComboBox();
        searchCriteriaPanel.add(this.categoryComboBox, GridBagConstraintsFactory.create(1, 1, 2, 1.0, 0.0));
        this.caseSensitiveCheckBox = new JCheckBox();
        this.caseSensitiveCheckBox.setText(Resource.getResourceString("case_sensitive"));
        searchCriteriaPanel.add((Component)this.caseSensitiveCheckBox, GridBagConstraintsFactory.create(2, 0, 1));
        this.wholeWordBox = new JCheckBox();
        this.wholeWordBox.setText(Resource.getResourceString("WholeWord"));
        searchCriteriaPanel.add((Component)this.wholeWordBox, GridBagConstraintsFactory.create(2, 1, 1));
        JLabel startDateLabel = new JLabel();
        ResourceHelper.setText(startDateLabel, "StartDate");
        searchCriteriaPanel.add((Component)startDateLabel, GridBagConstraintsFactory.create(3, 0, 2));
        JLabel endDateLabel = new JLabel();
        ResourceHelper.setText(endDateLabel, "EndDate");
        searchCriteriaPanel.add((Component)endDateLabel, GridBagConstraintsFactory.create(3, 1, 2));
        this.startDateChooser = new JDateChooser();
        GridBagConstraints gbc1 = GridBagConstraintsFactory.create(4, 0, 0, 0.0, 0.0);
        gbc1.anchor = 17;
        searchCriteriaPanel.add((Component)this.startDateChooser, gbc1);
        this.endDateChooser = new JDateChooser();
        GridBagConstraints gbc2 = GridBagConstraintsFactory.create(4, 1, 0, 0.0, 0.0);
        gbc2.anchor = 17;
        searchCriteriaPanel.add((Component)this.endDateChooser, gbc2);
        GridBagConstraints gridBagConstraints25 = GridBagConstraintsFactory.create(0, 2, 1, 0.0, 1.0);
        gridBagConstraints25.gridwidth = 5;
        searchCriteriaPanel.add((Component)this.createCheckBoxPanel(), gridBagConstraints25);
        return searchCriteriaPanel;
    }

    @Override
    public JComponent getComponent() {
        if (!this.isInitialized) {
            CategoryModel.getReference().addListener((Model.Listener)this);
            this.initComponents();
            this.addModel((Model)AppointmentModel.getReference());
            this.addModel((Model)AddressModel.getReference());
            this.addModel((Model)TaskModel.getReference());
            this.addModel((Model)MemoModel.getReference());
            this.resultsTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Item"), Resource.getResourceString("Type"), Resource.getResourceString("Date"), "key", "class"}, new Class[]{String.class, String.class, Date.class, Integer.class, Class.class}));
            TableColumnModel colModel = this.resultsTable.getColumnModel();
            TableColumn col = colModel.getColumn(3);
            this.resultsTable.removeColumn(col);
            col = colModel.getColumn(3);
            this.resultsTable.removeColumn(col);
            this.loadCategories();
            this.isInitialized = true;
        }
        return this;
    }

    private SearchCriteria getCriteria() {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setSearchString(this.searchText.getText());
        criteria.setCaseSensitive(this.caseSensitiveCheckBox.isSelected());
        criteria.setCategory((String)this.categoryComboBox.getSelectedItem());
        criteria.setWholeWord(this.wholeWordBox.isSelected());
        Calendar cal = this.startDateChooser.getCalendar();
        if (cal != null) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(13, -1);
            criteria.setStartDate(cal.getTime());
        }
        if ((cal = this.endDateChooser.getCalendar()) != null) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 0);
            cal.add(13, -1);
            criteria.setEndDate(cal.getTime());
        }
        criteria.setHoliday(this.holidayCheckBox.isSelected());
        criteria.setRepeating(this.repeatCheckBox.isSelected());
        criteria.setTodo(this.todoCheckBox.isSelected());
        criteria.setVacation(this.vacationCheckBox.isSelected());
        criteria.setHasLinks(this.linkCheckBox.isSelected());
        return criteria;
    }

    @Override
    public String getFrameTitle() {
        return Resource.getResourceString("srch");
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("srch");
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.SEARCH;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createSearchCriteriaPanel(), GridBagConstraintsFactory.create(0, 0, 1, 0.0, 0.0));
        JPanel searchButtonPanel = new JPanel();
        GridLayout gridLayout18 = new GridLayout();
        searchButtonPanel.setLayout(gridLayout18);
        gridLayout18.setRows(1);
        gridLayout18.setHgap(5);
        JButton searchButton = new JButton();
        ResourceHelper.setText(searchButton, "srch");
        searchButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Find16.gif")));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchCriteria criteria = SearchView.this.getCriteria();
                if (criteria.getStartDate() != null && criteria.getEndDate() != null && criteria.getStartDate().after(criteria.getEndDate())) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("Start_After_End"));
                    return;
                }
                SearchView.this.refresh();
            }
        });
        searchButtonPanel.add((Component)searchButton, null);
        this.add((Component)searchButtonPanel, GridBagConstraintsFactory.create(0, 2, 0));
        this.add((Component)this.createResultsPanel(), GridBagConstraintsFactory.create(0, 3, 1, 1.0, 1.0));
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/Find16.gif")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.SEARCH);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.SEARCH);
            }
        });
    }

    @Override
    public void print() {
        try {
            TablePrinter.printTable(this.resultsTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void update(Model.ChangeEvent event) {
        if (event.getModel() instanceof CategoryModel) {
            this.loadCategories();
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        Object[] ro;
        SearchCriteria criteria = this.getCriteria();
        TableSorter tm = (TableSorter)this.resultsTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.resultsTable);
        tm.setRowCount(0);
        if (this.apptCheckBox.isSelected()) {
            Collection appointments = AppointmentModel.getReference().search(criteria);
            for (Appointment appt : appointments) {
                ro = new Object[5];
                try {
                    ro[0] = appt.getText().replace('\n', ' ');
                    ro[1] = Resource.getResourceString("appointment");
                    ro[2] = appt.getDate();
                    ro[3] = new Integer(appt.getKey());
                    ro[4] = Appointment.class;
                    tm.addRow(ro);
                    tm.tableChanged(new TableModelEvent(tm));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
        if (this.addressCheckBox.isSelected()) {
            Collection addresses = AddressModel.getReference().search(criteria);
            for (Address addr : addresses) {
                ro = new Object[5];
                try {
                    ro[0] = (addr.getFirstName() == null ? "" : addr.getFirstName() + " ") + (addr.getLastName() == null ? "" : addr.getLastName());
                    ro[1] = Resource.getResourceString("Address");
                    ro[2] = null;
                    ro[3] = new Integer(addr.getKey());
                    ro[4] = Address.class;
                    tm.addRow(ro);
                    tm.tableChanged(new TableModelEvent(tm));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
        Collection taskItems = TaskModel.getReference().search(criteria);
        for (KeyedEntity item : taskItems) {
            ro = new Object[5];
            try {
                if (item instanceof Project && this.projectCheckBox.isSelected()) {
                    ro[0] = ((Project)item).getDescription();
                    ro[1] = Resource.getResourceString("project");
                    ro[2] = null;
                    ro[3] = new Integer(item.getKey());
                    ro[4] = Project.class;
                    tm.addRow(ro);
                    tm.tableChanged(new TableModelEvent(tm));
                    continue;
                }
                if (!(item instanceof Task) || !this.taskCheckBox.isSelected()) continue;
                ro[0] = ((Task)item).getSummary();
                ro[1] = Resource.getResourceString("task");
                ro[2] = null;
                ro[3] = new Integer(item.getKey());
                ro[4] = Task.class;
                tm.addRow(ro);
                tm.tableChanged(new TableModelEvent(tm));
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
        }
        if (this.memoCheckBox.isSelected()) {
            Collection memos = MemoModel.getReference().search(criteria);
            for (Memo memo : memos) {
                Object[] ro2 = new Object[5];
                try {
                    ro2[0] = memo.getMemoName();
                    ro2[1] = Resource.getResourceString("memo");
                    ro2[2] = null;
                    ro2[3] = new Integer(0);
                    ro2[4] = Memo.class;
                    tm.addRow(ro2);
                    tm.tableChanged(new TableModelEvent(tm));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
        tm.sortByColumn(0);
    }

    private void showSelectedItem() throws Exception {
        Component c;
        int[] rows = this.resultsTable.getSelectedRows();
        if (rows.length != 1) {
            return;
        }
        int row = rows[0];
        TableSorter tm = (TableSorter)this.resultsTable.getModel();
        int key = (Integer)tm.getValueAt(row, 3);
        Class cl = (Class)tm.getValueAt(row, 4);
        if (cl == Appointment.class) {
            Appointment ap = AppointmentModel.getReference().getAppt(key);
            if (ap == null) {
                return;
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(ap.getDate());
            AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
            ag.showApp(ap.getKey());
            ag.showView();
        } else if (cl == Project.class) {
            Project ap = TaskModel.getReference().getProject(key);
            if (ap == null) {
                return;
            }
            new ProjectView(ap, ProjectView.Action.CHANGE, null).showView();
        } else if (cl == Task.class) {
            Task ap = TaskModel.getReference().getTask(key);
            if (ap == null) {
                return;
            }
            new TaskView(ap, TaskView.Action.CHANGE, null).showView();
        } else if (cl == Address.class) {
            Address ap = AddressModel.getReference().getAddress(key);
            if (ap == null) {
                return;
            }
            new AddressView(ap).showView();
        } else if (cl == Memo.class && (c = MultiView.getMainView().setView(MultiView.ViewType.MEMO)) != null && c instanceof MemoPanel) {
            MemoPanel mp = (MemoPanel)c;
            mp.selectMemo((String)tm.getValueAt(row, 0));
        }
    }
}

