/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Theme;
import net.sf.borg.ui.MainMenu;
import net.sf.borg.ui.UIControl;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.popup.ReminderManager;

public class SunTrayIconProxy
implements Prefs.Listener {
    private static int iconSize = 16;
    private static SunTrayIconProxy singleton = null;
    private static boolean trayIconStarted = false;
    private static Menu actionMenu = new Menu();
    private TrayIcon trayIcon = null;

    public static SunTrayIconProxy getReference() {
        return singleton;
    }

    public static boolean hasTrayIcon() {
        return trayIconStarted;
    }

    public static void startTrayIcon(String trayname) {
        trayIconStarted = true;
        String usetray = Prefs.getPref(PrefName.USESYSTRAY);
        if (!usetray.equals("true")) {
            trayIconStarted = false;
        } else {
            try {
                singleton = new SunTrayIconProxy();
                singleton.init(trayname);
            }
            catch (UnsatisfiedLinkError le) {
                le.printStackTrace();
                trayIconStarted = false;
            }
            catch (NoClassDefFoundError ncf) {
                ncf.printStackTrace();
                trayIconStarted = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                trayIconStarted = false;
            }
        }
    }

    private void init(String trayname) throws Exception {
        if (!SystemTray.isSupported()) {
            throw new Exception("Systray not supported");
        }
        iconSize = SystemTray.getSystemTray().getTrayIconSize().height;
        this.trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resource/borg16.jpg")));
        this.trayIcon.setToolTip(trayname);
        actionMenu.setLabel(Resource.getResourceString("Open"));
        PopupMenu popup = new PopupMenu();
        String fontName = Prefs.getPref(PrefName.DEFFONT);
        if (!fontName.isEmpty()) {
            Font f = Font.decode(fontName);
            popup.setFont(f);
        }
        MenuItem item = new MenuItem();
        item.setLabel(Resource.getResourceString("Open_Calendar"));
        item.addActionListener(new OpenListener());
        popup.add(item);
        item = new MenuItem();
        item.setLabel(Resource.getResourceString("Show_Pops"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReminderManager rm = ReminderManager.getReminderManager();
                if (rm != null) {
                    rm.showAll();
                }
            }
        });
        popup.add(item);
        item = new MenuItem();
        item.setLabel(Resource.getResourceString("Hide_Pops"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReminderManager rm = ReminderManager.getReminderManager();
                if (rm != null) {
                    rm.hideAll();
                }
            }
        });
        popup.add(item);
        popup.add(actionMenu);
        item = new MenuItem();
        item.setLabel(Resource.getResourceString("Options"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsView.getReference().setVisible(true);
            }
        });
        popup.add(item);
        popup.addSeparator();
        item = new MenuItem();
        item.setLabel(Resource.getResourceString("About"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.AboutMIActionPerformed();
            }
        });
        popup.add(item);
        popup.addSeparator();
        item = new MenuItem();
        item.setLabel(Resource.getResourceString("Exit"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIControl.shutDownUI();
            }
        });
        popup.add(item);
        this.trayIcon.setPopupMenu(popup);
        this.trayIcon.addActionListener(new OpenListener());
        SystemTray tray = SystemTray.getSystemTray();
        tray.add(this.trayIcon);
        this.updateImage();
        Prefs.addListener(this);
        this.startRefreshTimer();
    }

    @Override
    public void prefsChanged() {
        this.updateImage();
    }

    public void updateImage() {
        Image image = null;
        if (Prefs.getBoolPref(PrefName.SYSTRAYDATE)) {
            String text = Integer.toString(new GregorianCalendar().get(5));
            BufferedImage bimage = new BufferedImage(iconSize, iconSize, 1);
            Graphics2D g = bimage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Theme t = Theme.getCurrentTheme();
            g.setColor(new Color(t.getTrayIconBg()));
            g.fillRect(0, 0, iconSize, iconSize);
            Font font = Font.decode(Prefs.getPref(PrefName.TRAYFONT));
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics();
            g.setColor(new Color(t.getTrayIconFg()));
            g.drawString(text, (iconSize - metrics.stringWidth(text)) / 2, (iconSize + metrics.getAscent()) / 2);
            g.dispose();
            image = bimage;
            this.trayIcon.setToolTip("BORG - " + DateFormat.getDateInstance(2).format(new Date()));
        } else {
            image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resource/borg16.jpg"));
        }
        this.trayIcon.setImage(image);
    }

    private void startRefreshTimer() {
        GregorianCalendar cal = new GregorianCalendar();
        int curmins = 60 * cal.get(11) + cal.get(12);
        int midnight = 1440 - curmins;
        Timer updatetimer = new Timer("SysTrayTimer");
        updatetimer.schedule(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SunTrayIconProxy.this.updateImage();
                    }
                });
            }
        }, midnight * 60 * 1000, 86400000L);
    }

    public static void addAction(String text, ActionListener action) {
        MenuItem item = new MenuItem();
        item.setLabel(text);
        item.addActionListener(action);
        actionMenu.add(item);
    }

    private class OpenListener
    implements ActionListener {
        private OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIControl.toFront();
        }
    }
}

