/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.address;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.entity.Address;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.address.AddressView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

public class AddrListView
extends DockableView
implements MultiView.Module {
    private static final long serialVersionUID = 1L;
    private Collection<Address> addrs_;
    private ActionListener alAddNew;
    private ActionListener alEdit;
    private ActionListener alDelete;
    private ActionListener alFind;
    private JButton delbutton;
    private JButton editbutton;
    private JButton findbutton;
    private JButton newbutton;
    private JScrollPane tableScrollPane;
    private StripedTable addressTable;
    private boolean isInitialized = false;

    private void delbuttonActionPerformed() {
        int[] indices = this.addressTable.getSelectedRows();
        if (indices.length == 0) {
            return;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Delete_Addresses"), Resource.getResourceString("Delete"), 2, 3);
        if (ret != 0) {
            return;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            TableSorter tm = (TableSorter)this.addressTable.getModel();
            int k = tm.getMappedIndex(index);
            Object[] oa = this.addrs_.toArray();
            Address addr = (Address)oa[k];
            addresses.add(addr);
        }
        for (Address addr : addresses) {
            AddressModel.getReference().delete(addr);
        }
    }

    private void editRow() {
        int index = this.addressTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.addressTable.getSelectionModel().setSelectionInterval(index, index);
        try {
            TableSorter tm = (TableSorter)this.addressTable.getModel();
            int k = tm.getMappedIndex(index);
            Object[] oa = this.addrs_.toArray();
            Address addr = (Address)oa[k];
            new AddressView(addr).showView();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void findbuttonActionPerformed() {
        String searchstring = "";
        JScrollBar vScrollBar = null;
        do {
            if ((searchstring = JOptionPane.showInputDialog(null, Resource.getResourceString("Search_For"), searchstring)) == null) continue;
            int tablerowcount = this.addressTable.getRowCount();
            int tablecolcount = this.addressTable.getColumnCount();
            for (int iRow = 0; iRow < tablerowcount; ++iRow) {
                for (int jCol = 0; jCol < tablecolcount; ++jCol) {
                    String colvalue = null;
                    Date colvaluedt = null;
                    try {
                        colvalue = (String)this.addressTable.getValueAt(iRow, jCol);
                    }
                    catch (ClassCastException ccex) {
                        colvaluedt = (Date)this.addressTable.getValueAt(iRow, jCol);
                        colvalue = colvaluedt.toString();
                    }
                    if (searchstring == null) continue;
                    boolean match = searchstring.equalsIgnoreCase(colvalue);
                    if (!match && colvalue != null) {
                        String searchstring2;
                        String colvalue2 = colvalue.toLowerCase();
                        int indexint = colvalue2.indexOf(searchstring2 = searchstring.toLowerCase(), 0);
                        boolean bl = match = indexint > -1;
                    }
                    if (!match) continue;
                    this.addressTable.setRowSelectionInterval(iRow, iRow);
                    vScrollBar = this.tableScrollPane.getVerticalScrollBar();
                    int maxVal = vScrollBar.getMaximum();
                    int oneCellScrollValue = maxVal / tablerowcount;
                    vScrollBar.setValue(iRow * oneCellScrollValue);
                    searchstring = JOptionPane.showInputDialog(null, Resource.getResourceString("Search_Next"), searchstring);
                    ++iRow;
                    jCol = 0;
                }
            }
            if (searchstring == null) continue;
            JOptionPane.showMessageDialog(null, Resource.getResourceString("Not_Found_End"));
        } while (searchstring != null);
    }

    @Override
    public String getFrameTitle() {
        return Resource.getResourceString("Address_Book");
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.addressTable = new StripedTable();
        JPanel buttonPanel = new JPanel();
        this.newbutton = new JButton();
        this.editbutton = new JButton();
        this.delbutton = new JButton();
        this.findbutton = new JButton();
        this.tableScrollPane.setPreferredSize(new Dimension(554, 404));
        this.addressTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        DefaultListSelectionModel mylsmodel = new DefaultListSelectionModel();
        mylsmodel.setSelectionMode(2);
        this.addressTable.setSelectionModel(mylsmodel);
        this.addressTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                AddrListView.this.editRow();
            }
        });
        this.tableScrollPane.setViewportView(this.addressTable);
        this.add((Component)this.tableScrollPane, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.newbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
        ResourceHelper.setText(this.newbutton, "Add_New");
        this.alAddNew = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Address addr = AddressModel.getReference().newAddress();
                addr.setKey(-1);
                new AddressView(addr).showView();
            }
        };
        this.newbutton.addActionListener(this.alAddNew);
        buttonPanel.add(this.newbutton);
        this.editbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Edit16.gif")));
        ResourceHelper.setText(this.editbutton, "Edit");
        this.alEdit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddrListView.this.editRow();
            }
        };
        this.editbutton.addActionListener(this.alEdit);
        buttonPanel.add(this.editbutton);
        this.delbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        ResourceHelper.setText(this.delbutton, "Delete");
        this.alDelete = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddrListView.this.delbuttonActionPerformed();
            }
        };
        this.delbutton.addActionListener(this.alDelete);
        buttonPanel.add(this.delbutton);
        this.findbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Find16.gif")));
        ResourceHelper.setText(this.findbutton, "Find");
        this.alFind = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddrListView.this.findbuttonActionPerformed();
            }
        };
        this.findbutton.addActionListener(this.alFind);
        buttonPanel.add(this.findbutton);
        this.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1));
        new PopupMenuHelper(this.addressTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(this.alAddNew, "Add_New"), new PopupMenuHelper.Entry(this.alEdit, "Edit"), new PopupMenuHelper.Entry(this.alDelete, "Delete"), new PopupMenuHelper.Entry(this.alFind, "Find")});
    }

    @Override
    public void refresh() {
        AddressModel addrmod_ = AddressModel.getReference();
        try {
            this.addrs_ = addrmod_.getAddresses();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
        TableSorter tm = (TableSorter)this.addressTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.addressTable);
        tm.setRowCount(0);
        for (Address r : this.addrs_) {
            try {
                Object[] ro = new Object[]{r.getFirstName(), r.getLastName(), r.getEmail(), r.getScreenName(), r.getHomePhone(), r.getWorkPhone(), r.getBirthday()};
                tm.addRow(ro);
                tm.tableChanged(new TableModelEvent(tm));
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
        }
        tm.sortByColumn(1);
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("Address_Book");
    }

    @Override
    public JPanel getComponent() {
        if (!this.isInitialized) {
            this.addModel((Model)AddressModel.getReference());
            this.setLayout(new GridBagLayout());
            this.initComponents();
            this.addressTable.setModel(new TableSorter(new String[]{Resource.getResourceString("First"), Resource.getResourceString("Last"), Resource.getResourceString("Email"), Resource.getResourceString("Screen_Name"), Resource.getResourceString("Home_Phone"), Resource.getResourceString("Work_Phone"), Resource.getResourceString("Birthday")}, new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Date.class}));
            this.refresh();
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/addr16.jpg")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(AddrListView.this.getViewType());
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(AddrListView.this.getViewType());
            }
        });
    }

    @Override
    public void print() {
        try {
            TablePrinter.printTable(this.addressTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.ADDRESS;
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }
}

