/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.address;

import com.toedter.calendar.JDateChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.link.LinkPanel;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.LimitDocument;

public class AddressView
extends DockableView {
    private static final long serialVersionUID = 1L;
    private Address addr_;
    private JDateChooser birthdayChooser;
    private JTextField cityText;
    private JTextField companyText;
    private JTextField countryText;
    private JTextField emailText;
    private JTextField cellPhoneText;
    private JTextField faxText;
    private JTextField firstNameText;
    private JTextField homePageText;
    private JTextField lastNameText;
    private JTextField nickNameText;
    private JTextArea notesText;
    private JTextField pagerText;
    private JTextField screenNameText;
    private JTextField stateText;
    private JTextField streetAddresText;
    private JTextField webPageText;
    private JTextField workCityText;
    private JTextField workCountryText;
    private JTextField workPhoneText;
    private JTextField workStateText;
    private JTextField workStreetAddressText;
    private JTextField workZipText;
    private JTextField zipCodeText;
    private LinkPanel linkPanel;

    public AddressView(Address addr) {
        this.addr_ = addr;
        this.addModel((Model)AddressModel.getReference());
        this.initComponents();
        this.showaddr();
    }

    @Override
    public String getFrameTitle() {
        return Resource.getResourceString("Address_Book_Entry");
    }

    private void initComponents() {
        JPanel contactPanel = new JPanel();
        this.firstNameText = new JTextField(new LimitDocument(25), null, 25);
        this.lastNameText = new JTextField(new LimitDocument(25), null, 25);
        this.nickNameText = new JTextField(new LimitDocument(25), null, 25);
        this.screenNameText = new JTextField(new LimitDocument(25), null, 25);
        this.homePageText = new JTextField(new LimitDocument(25), null, 25);
        this.workPhoneText = new JTextField(new LimitDocument(25), null, 25);
        this.pagerText = new JTextField(new LimitDocument(25), null, 25);
        this.faxText = new JTextField(new LimitDocument(25), null, 25);
        this.emailText = new JTextField(new LimitDocument(50), null, 50);
        this.webPageText = new JTextField(new LimitDocument(100), null, 100);
        this.companyText = new JTextField(new LimitDocument(25), null, 25);
        this.birthdayChooser = new JDateChooser();
        this.cellPhoneText = new JTextField(new LimitDocument(25), null, 25);
        JPanel homeAddressPanel = new JPanel();
        this.streetAddresText = new JTextField(new LimitDocument(40), null, 25);
        this.cityText = new JTextField(new LimitDocument(25), null, 25);
        this.stateText = new JTextField(new LimitDocument(25), null, 25);
        this.countryText = new JTextField(new LimitDocument(25), null, 25);
        this.zipCodeText = new JTextField(new LimitDocument(25), null, 25);
        JPanel workAddressPanel = new JPanel();
        this.workZipText = new JTextField(new LimitDocument(25), null, 25);
        this.workCountryText = new JTextField(new LimitDocument(25), null, 25);
        this.workStateText = new JTextField(new LimitDocument(25), null, 25);
        this.workCityText = new JTextField(new LimitDocument(25), null, 25);
        this.workStreetAddressText = new JTextField(new LimitDocument(40), null, 25);
        this.notesText = new JTextArea(new LimitDocument(Prefs.getIntPref(PrefName.MAX_TEXT_SIZE)));
        JPanel buttonPanel = new JPanel();
        JButton saveButton = new JButton();
        this.setLayout(new GridBagLayout());
        contactPanel.setLayout(new GridBagLayout());
        JLabel jLabel1 = new JLabel();
        ResourceHelper.setText(jLabel1, "First_Name:");
        jLabel1.setLabelFor(this.firstNameText);
        contactPanel.add((Component)jLabel1, GridBagConstraintsFactory.create(0, 0));
        JLabel jLabel2 = new JLabel();
        ResourceHelper.setText(jLabel2, "Last_Name:");
        jLabel2.setLabelFor(this.lastNameText);
        contactPanel.add((Component)jLabel2, GridBagConstraintsFactory.create(0, 1));
        JLabel jLabel3 = new JLabel();
        ResourceHelper.setText(jLabel3, "Nickname:");
        jLabel3.setLabelFor(this.nickNameText);
        contactPanel.add((Component)jLabel3, GridBagConstraintsFactory.create(0, 2));
        JLabel jLabel4 = new JLabel();
        ResourceHelper.setText(jLabel4, "Screen_Name:");
        jLabel4.setLabelFor(this.screenNameText);
        contactPanel.add((Component)jLabel4, GridBagConstraintsFactory.create(2, 0));
        JLabel jLabel5 = new JLabel();
        ResourceHelper.setText(jLabel5, "Home_Phone:");
        jLabel5.setLabelFor(this.homePageText);
        contactPanel.add((Component)jLabel5, GridBagConstraintsFactory.create(2, 1));
        JLabel jLabel6 = new JLabel();
        ResourceHelper.setText(jLabel6, "Work_Phone:");
        jLabel6.setLabelFor(this.workPhoneText);
        contactPanel.add((Component)jLabel6, GridBagConstraintsFactory.create(2, 2));
        JLabel jLabel7 = new JLabel();
        ResourceHelper.setText(jLabel7, "Pager:");
        jLabel7.setLabelFor(this.pagerText);
        contactPanel.add((Component)jLabel7, GridBagConstraintsFactory.create(4, 0));
        JLabel jLabel8 = new JLabel();
        ResourceHelper.setText(jLabel8, "Fax:");
        jLabel8.setLabelFor(this.faxText);
        contactPanel.add((Component)jLabel8, GridBagConstraintsFactory.create(4, 1));
        JLabel jLabel9 = new JLabel();
        ResourceHelper.setText(jLabel9, "Email:");
        jLabel9.setLabelFor(this.emailText);
        contactPanel.add((Component)jLabel9, GridBagConstraintsFactory.create(4, 2));
        JLabel jLabel14 = new JLabel();
        ResourceHelper.setText(jLabel14, "Web_Page:");
        jLabel14.setLabelFor(this.webPageText);
        contactPanel.add((Component)jLabel14, GridBagConstraintsFactory.create(6, 0));
        JLabel jLabel21 = new JLabel();
        ResourceHelper.setText(jLabel21, "Company");
        jLabel21.setLabelFor(this.companyText);
        contactPanel.add((Component)jLabel21, GridBagConstraintsFactory.create(6, 1));
        JLabel jLabel22 = new JLabel();
        ResourceHelper.setText(jLabel22, "Birthday");
        jLabel22.setLabelFor((Component)this.birthdayChooser);
        contactPanel.add((Component)jLabel22, GridBagConstraintsFactory.create(6, 2));
        JLabel jLabel23 = new JLabel();
        ResourceHelper.setText(jLabel23, "Cell_Phone:");
        jLabel23.setLabelFor(this.cellPhoneText);
        contactPanel.add((Component)jLabel23, GridBagConstraintsFactory.create(0, 3));
        contactPanel.add((Component)this.firstNameText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        contactPanel.add((Component)this.lastNameText, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        contactPanel.add((Component)this.nickNameText, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        contactPanel.add((Component)this.screenNameText, GridBagConstraintsFactory.create(3, 0, 1, 1.0, 0.0));
        contactPanel.add((Component)this.homePageText, GridBagConstraintsFactory.create(3, 1, 1, 1.0, 0.0));
        contactPanel.add((Component)this.workPhoneText, GridBagConstraintsFactory.create(3, 2, 1, 1.0, 0.0));
        contactPanel.add((Component)this.pagerText, GridBagConstraintsFactory.create(5, 0, 1, 1.0, 0.0));
        contactPanel.add((Component)this.faxText, GridBagConstraintsFactory.create(5, 1, 1, 1.0, 0.0));
        contactPanel.add((Component)this.emailText, GridBagConstraintsFactory.create(5, 2, 1, 1.0, 0.0));
        contactPanel.add((Component)this.webPageText, GridBagConstraintsFactory.create(7, 0, 1, 1.0, 0.0));
        contactPanel.add((Component)this.companyText, GridBagConstraintsFactory.create(7, 1, 1, 1.0, 0.0));
        contactPanel.add((Component)this.birthdayChooser, GridBagConstraintsFactory.create(7, 2, 1, 1.0, 0.0));
        contactPanel.add((Component)this.cellPhoneText, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        contactPanel.setBorder(new TitledBorder(Resource.getResourceString("contact")));
        GridBagConstraints cgbc = GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0);
        cgbc.gridwidth = 2;
        this.add((Component)contactPanel, cgbc);
        homeAddressPanel.setLayout(new GridBagLayout());
        homeAddressPanel.setBorder(new TitledBorder(Resource.getResourceString("HomeAddress")));
        JLabel jLabel12 = new JLabel();
        ResourceHelper.setText(jLabel12, "Home_State:");
        jLabel12.setLabelFor(this.workStateText);
        JLabel jLabel13 = new JLabel();
        ResourceHelper.setText(jLabel13, "Home_Country:");
        jLabel13.setLabelFor(this.workCountryText);
        JLabel jLabel15 = new JLabel();
        ResourceHelper.setText(jLabel15, "Home_Zip_Code:");
        jLabel15.setLabelFor(this.workZipText);
        JLabel jLabel16 = new JLabel();
        ResourceHelper.setText(jLabel16, "Work_Street_Address");
        jLabel16.setLabelFor(this.workStreetAddressText);
        jLabel16.setHorizontalAlignment(4);
        JLabel jLabel17 = new JLabel();
        ResourceHelper.setText(jLabel17, "Work_City:");
        jLabel17.setLabelFor(this.workCityText);
        jLabel17.setHorizontalAlignment(4);
        jLabel17.setHorizontalTextPosition(4);
        homeAddressPanel.add((Component)jLabel16, GridBagConstraintsFactory.create(0, 0));
        homeAddressPanel.add((Component)jLabel17, GridBagConstraintsFactory.create(0, 1));
        homeAddressPanel.add((Component)jLabel12, GridBagConstraintsFactory.create(0, 2));
        homeAddressPanel.add((Component)jLabel13, GridBagConstraintsFactory.create(0, 3));
        homeAddressPanel.add((Component)jLabel15, GridBagConstraintsFactory.create(0, 4));
        homeAddressPanel.add((Component)this.workStreetAddressText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        homeAddressPanel.add((Component)this.workCityText, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        homeAddressPanel.add((Component)this.workStateText, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        homeAddressPanel.add((Component)this.workCountryText, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        homeAddressPanel.add((Component)this.workZipText, GridBagConstraintsFactory.create(1, 4, 1, 1.0, 0.0));
        this.add((Component)homeAddressPanel, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
        workAddressPanel.setLayout(new GridBagLayout());
        workAddressPanel.setBorder(new TitledBorder(Resource.getResourceString("WorkAddress")));
        JLabel jLabel10 = new JLabel();
        ResourceHelper.setText(jLabel10, "Home_Street_Address");
        jLabel10.setLabelFor(this.streetAddresText);
        JLabel jLabel11 = new JLabel();
        ResourceHelper.setText(jLabel11, "Home_City:");
        jLabel11.setLabelFor(this.cityText);
        JLabel jLabel18 = new JLabel();
        ResourceHelper.setText(jLabel18, "Work_State:");
        jLabel18.setLabelFor(this.stateText);
        jLabel18.setHorizontalAlignment(4);
        JLabel jLabel19 = new JLabel();
        ResourceHelper.setText(jLabel19, "Work_Zip_Code:");
        jLabel19.setLabelFor(this.zipCodeText);
        jLabel19.setHorizontalAlignment(4);
        JLabel jLabel20 = new JLabel();
        ResourceHelper.setText(jLabel20, "Work_Country:");
        jLabel20.setLabelFor(this.countryText);
        jLabel20.setHorizontalAlignment(4);
        this.workStreetAddressText.setMinimumSize(new Dimension(4, 50));
        workAddressPanel.add((Component)jLabel10, GridBagConstraintsFactory.create(0, 0));
        workAddressPanel.add((Component)jLabel11, GridBagConstraintsFactory.create(0, 1));
        workAddressPanel.add((Component)jLabel18, GridBagConstraintsFactory.create(0, 2));
        workAddressPanel.add((Component)jLabel20, GridBagConstraintsFactory.create(0, 3));
        workAddressPanel.add((Component)jLabel19, GridBagConstraintsFactory.create(0, 4));
        workAddressPanel.add((Component)this.streetAddresText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        workAddressPanel.add((Component)this.cityText, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        workAddressPanel.add((Component)this.stateText, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        workAddressPanel.add((Component)this.countryText, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        workAddressPanel.add((Component)this.zipCodeText, GridBagConstraintsFactory.create(1, 4, 1, 1.0, 0.0));
        this.add((Component)workAddressPanel, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 1.0));
        this.notesText.setLineWrap(true);
        this.notesText.setWrapStyleWord(true);
        this.notesText.setColumns(40);
        this.notesText.setRows(5);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.notesText);
        JPanel notesPanel = new JPanel();
        notesPanel.setLayout(new GridBagLayout());
        notesPanel.add((Component)sp, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 1.0));
        notesPanel.setBorder(new TitledBorder(Resource.getResourceString("Notes")));
        GridBagConstraints ngbc = GridBagConstraintsFactory.create(0, 2, 1, 1.0, 1.0);
        ngbc.gridwidth = 2;
        this.add((Component)notesPanel, ngbc);
        this.linkPanel = new LinkPanel();
        this.linkPanel.setBorder(new TitledBorder(Resource.getResourceString("links")));
        GridBagConstraints lgbc = GridBagConstraintsFactory.create(0, 3, 1, 1.0, 1.0);
        lgbc.gridwidth = 2;
        this.add((Component)this.linkPanel, lgbc);
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(saveButton, "Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressView.this.saveaddr();
            }
        });
        buttonPanel.add(saveButton);
        GridBagConstraints bgbc = GridBagConstraintsFactory.create(0, 4, 1, 1.0, 1.0);
        bgbc.gridwidth = 2;
        this.add((Component)buttonPanel, bgbc);
    }

    @Override
    public void refresh() {
    }

    private void saveaddr() {
        Date bd;
        if (this.firstNameText.getText().equals("") || this.firstNameText.getText().trim().length() == 0 || this.lastNameText.getText().equals("") || this.lastNameText.getText().trim().length() == 0) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("First_and_Last_name_are_Required"));
            return;
        }
        if (!this.emailText.getText().isEmpty() && Prefs.getBoolPref(PrefName.EMAIL_VALIDATION)) {
            try {
                new InternetAddress(this.emailText.getText()).getAddress();
            }
            catch (AddressException e) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Invalid_Email_Address"));
                return;
            }
        }
        if ((bd = this.birthdayChooser.getDate()) != null && DateUtil.isAfter(bd, new Date())) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("future_birthday"));
        }
        this.addr_.setFirstName(this.firstNameText.getText());
        this.addr_.setLastName(this.lastNameText.getText());
        this.addr_.setNickname(this.nickNameText.getText());
        this.addr_.setEmail(this.emailText.getText());
        this.addr_.setScreenName(this.screenNameText.getText());
        this.addr_.setWorkPhone(this.workPhoneText.getText());
        this.addr_.setHomePhone(this.homePageText.getText());
        this.addr_.setFax(this.faxText.getText());
        this.addr_.setPager(this.pagerText.getText());
        this.addr_.setWebPage(this.webPageText.getText());
        this.addr_.setNotes(this.notesText.getText());
        this.addr_.setStreetAddress(this.streetAddresText.getText());
        this.addr_.setCity(this.cityText.getText());
        this.addr_.setState(this.stateText.getText());
        this.addr_.setCountry(this.countryText.getText());
        this.addr_.setZip(this.zipCodeText.getText());
        this.addr_.setWorkStreetAddress(this.workStreetAddressText.getText());
        this.addr_.setWorkCity(this.workCityText.getText());
        this.addr_.setWorkState(this.workStateText.getText());
        this.addr_.setWorkCountry(this.workCountryText.getText());
        this.addr_.setWorkZip(this.workZipText.getText());
        this.addr_.setCompany(this.companyText.getText());
        this.addr_.setBirthday(this.birthdayChooser.getDate());
        this.addr_.setCellPhone(this.cellPhoneText.getText());
        try {
            AddressModel.getReference().saveAddress(this.addr_);
            this.close();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void showaddr() {
        this.firstNameText.setText(this.addr_.getFirstName());
        this.lastNameText.setText(this.addr_.getLastName());
        this.nickNameText.setText(this.addr_.getNickname());
        this.emailText.setText(this.addr_.getEmail());
        this.screenNameText.setText(this.addr_.getScreenName());
        this.workPhoneText.setText(this.addr_.getWorkPhone());
        this.homePageText.setText(this.addr_.getHomePhone());
        this.faxText.setText(this.addr_.getFax());
        this.pagerText.setText(this.addr_.getPager());
        this.webPageText.setText(this.addr_.getWebPage());
        this.notesText.setText(this.addr_.getNotes());
        this.streetAddresText.setText(this.addr_.getStreetAddress());
        this.cityText.setText(this.addr_.getCity());
        this.stateText.setText(this.addr_.getState());
        this.countryText.setText(this.addr_.getCountry());
        this.zipCodeText.setText(this.addr_.getZip());
        this.workStreetAddressText.setText(this.addr_.getWorkStreetAddress());
        this.workCityText.setText(this.addr_.getWorkCity());
        this.workStateText.setText(this.addr_.getWorkState());
        this.workCountryText.setText(this.addr_.getWorkCountry());
        this.workZipText.setText(this.addr_.getWorkZip());
        this.companyText.setText(this.addr_.getCompany());
        this.cellPhoneText.setText(this.addr_.getCellPhone());
        Date bd = this.addr_.getBirthday();
        this.birthdayChooser.setDate(bd);
        this.linkPanel.setOwner((KeyedEntity<?>)this.addr_);
    }

    public void update(Model.ChangeEvent event) {
    }
}

