/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.EmailReminder;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.calendar.AppointmentPanel;
import net.sf.borg.ui.util.DateDialog;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TableSorter;

public class AppointmentListView
extends DockableView
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JButton addButton;
    private AppointmentPanel appointmentPanel = null;
    private StripedTable apptTable;
    private GregorianCalendar cal_ = null;
    private JDateChooser dateChooser = null;
    private JButton copyButton = null;
    private TableCellRenderer defrend = null;
    private JButton deleteButton;
    private JButton deleteOneOnlyButton;
    private JPanel buttonPanel;
    private JPanel appointmentListPanel;
    private JScrollPane apptTableScrollPane;
    private JButton reminderButton = null;
    private String title_ = "";

    static void onChangeDate(List<Appointment> appts) {
        if (appts.size() == 0) {
            return;
        }
        DateDialog dlg = new DateDialog(null);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(appts.get(0).getDate());
        dlg.setCalendar(cal);
        dlg.setVisible(true);
        Calendar dlgcal = dlg.getCalendar();
        if (dlgcal == null) {
            return;
        }
        cal.set(dlgcal.get(1), dlgcal.get(2), dlgcal.get(5));
        for (int i = 0; i < appts.size(); ++i) {
            try {
                Appointment appt = appts.get(i);
                appt.setDate(cal.getTime());
                AppointmentModel.getReference().saveAppt(appt);
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    static void onMoveToFollowingDay(List<Appointment> appts) {
        if (appts.size() == 0) {
            return;
        }
        for (int i = 0; i < appts.size(); ++i) {
            try {
                Appointment appt = appts.get(i);
                GregorianCalendar gcal = new GregorianCalendar();
                gcal.setTime(appt.getDate());
                gcal.add(6, 1);
                appt.setDate(gcal.getTime());
                appt.setSkipList(null);
                appt.setNextTodo(null);
                AppointmentModel.getReference().saveAppt(appt);
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    public AppointmentListView(int year, int month, int day) {
        this.addModel((Model)AppointmentModel.getReference());
        this.addModel((Model)TaskModel.getReference());
        this.appointmentPanel = new AppointmentPanel(year, month, day);
        this.initComponents();
        this.title_ = Resource.getResourceString("Appointment_Editor");
        this.apptTableScrollPane.setViewportView(this.apptTable);
        this.apptTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Text"), Resource.getResourceString("Time"), "Key"}, new Class[]{String.class, Date.class, Integer.class}));
        this.defrend = this.apptTable.getDefaultRenderer(Date.class);
        this.apptTable.setDefaultRenderer(Date.class, new TimeRenderer());
        TableSorter tm = (TableSorter)this.apptTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.apptTable);
        this.apptTable.getColumnModel().getColumn(0).setPreferredWidth(125);
        this.apptTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.apptTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
        ListSelectionModel rowSM = this.apptTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        TableColumnModel tcm = this.apptTable.getColumnModel();
        TableColumn column = tcm.getColumn(2);
        tcm.removeColumn(column);
        this.showDate(year, month, day);
    }

    private void copyAppt() {
        Appointment appt;
        int[] keys = this.getSelectedKeys();
        if (keys.length != 1) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("select_appt"));
            return;
        }
        DateDialog dlg = new DateDialog(null);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
        dlg.setCalendar(cal);
        dlg.setVisible(true);
        Calendar dlgcal = dlg.getCalendar();
        if (dlgcal == null) {
            return;
        }
        this.showDate(dlgcal.get(1), dlgcal.get(2), dlgcal.get(5));
        try {
            appt = AppointmentModel.getReference().getAppt(keys[0]);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
        if (appt.isEncrypted()) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("no_copy_enc"));
            return;
        }
        this.appointmentPanel.showapp(-1, appt);
        this.refresh();
    }

    private JButton getCopyButton() {
        if (this.copyButton == null) {
            this.copyButton = new JButton();
            ResourceHelper.setText(this.copyButton, "copy_appt");
            this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Copy16.gif")));
            this.copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppointmentListView.this.copyAppt();
                }
            });
        }
        return this.copyButton;
    }

    private JDateChooser getDateCB() {
        if (this.dateChooser == null) {
            this.dateChooser = new JDateChooserNoMnemonic();
            this.dateChooser.addPropertyChangeListener("date", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    Calendar cal = AppointmentListView.this.dateChooser.getCalendar();
                    if (cal != null) {
                        AppointmentListView.this.showDate(cal.get(1), cal.get(2), cal.get(5));
                    } else {
                        AppointmentListView.this.dateChooser.setCalendar((Calendar)AppointmentListView.this.cal_);
                    }
                }
            });
        }
        return this.dateChooser;
    }

    @Override
    public String getFrameTitle() {
        return this.title_;
    }

    @Override
    protected PrefName getFrameSizePref() {
        return new PrefName(Resource.getResourceString("Appointment_Editor") + "_framesize", "-1,-1,800,600,N");
    }

    private JButton getReminderButton() {
        if (this.reminderButton == null) {
            this.reminderButton = new JButton();
            ResourceHelper.setText(this.reminderButton, "send_reminder");
            this.reminderButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/ComposeMail16.gif")));
            this.reminderButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    class MailThread
                    extends Thread {
                        private Calendar cal;

                        public MailThread(Calendar c) {
                            this.cal = c;
                            this.setName("Reminder Mail Thread");
                        }

                        @Override
                        public void run() {
                            try {
                                EmailReminder.sendDailyEmailReminder((Calendar)this.cal);
                            }
                            catch (Exception e) {
                                final Exception fe = e;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Errmsg.getErrorHandler().errmsg(fe);
                                    }
                                });
                            }
                        }
                    }
                    new MailThread(AppointmentListView.this.cal_).start();
                }
            });
        }
        return this.reminderButton;
    }

    private List<Appointment> getSelectedAppointments() {
        int[] keys = this.getSelectedKeys();
        ArrayList<Appointment> appts = new ArrayList<Appointment>(keys.length);
        AppointmentModel model = AppointmentModel.getReference();
        for (int i = 0; i < keys.length; ++i) {
            try {
                appts.add(model.getAppt(keys[i]));
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        return appts;
    }

    private int[] getSelectedKeys() {
        int[] rows = this.apptTable.getSelectedRows();
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            TableSorter tm = (TableSorter)this.apptTable.getModel();
            keyList.add((Integer)tm.getValueAt(row, 2));
        }
        int[] keys = new int[keyList.size()];
        for (int i = 0; i < keyList.size(); ++i) {
            keys[i] = (Integer)keyList.get(i);
        }
        return keys;
    }

    private void initComponents() {
        this.appointmentListPanel = new JPanel();
        this.apptTableScrollPane = new JScrollPane();
        this.apptTable = new StripedTable();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.deleteOneOnlyButton = new JButton();
        this.appointmentListPanel.setLayout(new GridBagLayout());
        this.appointmentListPanel.setBorder(new TitledBorder(Resource.getResourceString("apptlist")));
        this.apptTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.apptTable.setAutoResizeMode(4);
        this.apptTable.setSelectionMode(2);
        this.apptTable.setPreferredSize(new Dimension(700, 500));
        this.apptTableScrollPane.setBorder(null);
        this.apptTableScrollPane.setViewport(this.apptTableScrollPane.getViewport());
        this.apptTableScrollPane.setViewportView(this.apptTable);
        this.buttonPanel.setLayout(new GridLayout(0, 1));
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Edit16.gif")));
        ResourceHelper.setText(this.addButton, "EditNew");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppointmentListView.this.apptTable.clearSelection();
                AppointmentListView.this.appointmentPanel.showapp(-1, null);
            }
        });
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.getCopyButton());
        this.deleteButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        ResourceHelper.setText(this.deleteButton, "Delete");
        this.deleteButton.setToolTipText(Resource.getResourceString("del_tip"));
        ActionListener alDel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] keys = AppointmentListView.this.getSelectedKeys();
                if (keys.length == 0) {
                    return;
                }
                int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_Apps") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
                if (ret != 0) {
                    return;
                }
                AppointmentModel model = AppointmentModel.getReference();
                for (int i = 0; i < keys.length; ++i) {
                    model.delAppt(keys[i]);
                }
                AppointmentListView.this.apptTable.clearSelection();
            }
        };
        this.deleteButton.addActionListener(alDel);
        this.buttonPanel.add(this.deleteButton);
        this.deleteOneOnlyButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        ResourceHelper.setText(this.deleteOneOnlyButton, "Delete_One_Only");
        this.deleteOneOnlyButton.setToolTipText(Resource.getResourceString("doo_tip"));
        ActionListener alDelOne = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] keys = AppointmentListView.this.getSelectedKeys();
                AppointmentModel model = AppointmentModel.getReference();
                for (int i = 0; i < keys.length; ++i) {
                    model.delOneOnly(keys[i], AppointmentListView.this.cal_.getTime());
                }
                AppointmentListView.this.apptTable.clearSelection();
            }
        };
        this.deleteOneOnlyButton.addActionListener(alDelOne);
        ActionListener alMoveToFollowingDay = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppointmentListView.onMoveToFollowingDay(AppointmentListView.this.getSelectedAppointments());
            }
        };
        ActionListener alChangeDate = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppointmentListView.onChangeDate(AppointmentListView.this.getSelectedAppointments());
            }
        };
        new PopupMenuHelper(this.apptTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(alDel, "Delete"), new PopupMenuHelper.Entry(alDelOne, "Delete_One_Only"), new PopupMenuHelper.Entry(alMoveToFollowingDay, "Move_To_Following_Day"), new PopupMenuHelper.Entry(alChangeDate, "changedate")});
        this.buttonPanel.add((Component)this.getReminderButton(), null);
        this.buttonPanel.add((Component)this.deleteOneOnlyButton, this.deleteOneOnlyButton.getName());
        this.appointmentListPanel.add((Component)this.getDateCB(), GridBagConstraintsFactory.create(0, 0, 1, 1.0, 0.0));
        this.appointmentListPanel.add((Component)this.apptTableScrollPane, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 10.0));
        this.appointmentListPanel.add((Component)this.buttonPanel, GridBagConstraintsFactory.create(0, 2));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.appointmentPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.add((Component)this.appointmentListPanel, GridBagConstraintsFactory.create(1, 0, 1));
    }

    @Override
    public void refresh() {
        TableSorter tm = (TableSorter)this.apptTable.getModel();
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        String priv = Prefs.getPref(PrefName.SHOWPRIVATE);
        String pub = Prefs.getPref(PrefName.SHOWPUBLIC);
        try {
            List alist_ = AppointmentModel.getReference().getAppts(this.cal_.getTime());
            if (alist_ != null) {
                for (Integer key : alist_) {
                    Appointment ap = AppointmentModel.getReference().getAppt(key.intValue());
                    if (ap.isPrivate() && !priv.equals("true") || !ap.isPrivate() && !pub.equals("true")) continue;
                    Object[] ro = new Object[3];
                    ro[0] = ap.isEncrypted() ? Resource.getResourceString("EncryptedItemShort") : ap.getText();
                    Date d = ap.getDate();
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(d);
                    cal.set(2000, 1, 1);
                    if (AppointmentModel.isNote((Appointment)ap)) {
                        cal.set(13, 0);
                    } else {
                        cal.set(13, 1);
                    }
                    ro[1] = cal.getTime();
                    ro[2] = key;
                    tm.addRow(ro);
                    tm.tableChanged(new TableModelEvent(tm));
                }
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        int row = this.apptTable.getRowCount();
        this.apptTable.setPreferredSize(new Dimension(150, row * 16));
        if (!tm.isSorted()) {
            tm.sortByColumn(1);
        } else {
            tm.sort();
        }
    }

    public void showApp(int key) {
        this.apptTable.clearSelection();
        TableSorter tm = (TableSorter)this.apptTable.getModel();
        int rows = tm.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Integer k = (Integer)tm.getValueAt(i, 2);
            if (key != k) continue;
            this.apptTable.getSelectionModel().setSelectionInterval(i, i);
        }
        this.appointmentPanel.showapp(key, null);
    }

    private void showDate(int year, int month, int day) {
        this.cal_ = new GregorianCalendar(year, month, day);
        this.getDateCB().setCalendar((Calendar)this.cal_);
        Date d = this.cal_.getTime();
        this.title_ = Resource.getResourceString("Appointment_Editor_for_") + " " + DateFormat.getDateInstance(3).format(d);
        this.updateTitle();
        TableSorter tm = (TableSorter)this.apptTable.getModel();
        tm.setRowCount(0);
        tm.tableChanged(new TableModelEvent(tm));
        this.appointmentPanel.setDate(year, month, day);
        this.appointmentPanel.showapp(-1, null);
        this.refresh();
    }

    public void setTime(int hour, int minute) {
        this.appointmentPanel.setStartTime(hour, minute);
        this.appointmentPanel.showapp(-1, null);
        this.refresh();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.appointmentPanel.showapp(-1, null);
            return;
        }
        int row = lsm.getMinSelectionIndex();
        if (row == -1) {
            return;
        }
        TableSorter tm = (TableSorter)this.apptTable.getModel();
        Integer apptkey = (Integer)tm.getValueAt(row, 2);
        this.appointmentPanel.showapp(apptkey, null);
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    private static class JDateChooserNoMnemonic
    extends JDateChooser {
        private static final long serialVersionUID = 120268996535847635L;

        public JDateChooserNoMnemonic() {
            this.calendarButton.setMnemonic(61451);
        }
    }

    private class TimeRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public TimeRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = AppointmentListView.this.defrend.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setBackground(c.getBackground());
            this.setForeground(c.getForeground());
            Date d = (Date)obj;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(d);
            if (cal.get(13) == 0) {
                this.setText("--------");
            } else {
                SimpleDateFormat sdf = AppointmentModel.getTimeFormat();
                this.setText(sdf.format(d));
            }
            return this;
        }
    }
}

