/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.LinkModel;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.ui.ClipBoard;
import net.sf.borg.ui.calendar.AppointmentListView;
import net.sf.borg.ui.calendar.AppointmentTextFormat;
import net.sf.borg.ui.calendar.ApptBoxPanel;
import net.sf.borg.ui.calendar.Box;

class ApptBox
extends Box
implements Box.Draggable {
    private static final int inset = 2;
    private static final int radius = 2;
    private static SimpleDateFormat sdf = new SimpleDateFormat("hh:mm");
    private Appointment appt = null;
    private double bottom;
    private Date date;
    private boolean hasLink = false;
    private boolean isPlaced = false;
    private double left;
    private int maxAcrossAtOneTime = 0;
    private int oldFontHeight = -1;
    private JPopupMenu popmenu = null;
    private double right;
    private Icon todoIcon = null;
    private String todoMarker = null;
    private double top;

    public static void layoutBoxes(List<ApptBox> boxlist, int starthr, int endhr) {
        double startmin = starthr * 60;
        double endmin = endhr * 60;
        for (ApptBox box : boxlist) {
            Appointment ap = box.appt;
            Date d = ap.getDate();
            if (d == null) continue;
            GregorianCalendar acal = new GregorianCalendar();
            acal.setTime(d);
            double apstartmin = 60 * acal.get(11) + acal.get(12);
            int dur = 0;
            Integer duri = ap.getDuration();
            if (duri != null) {
                dur = duri;
            }
            double apendmin = apstartmin + (double)dur;
            if (apstartmin < startmin) {
                apstartmin = startmin;
            }
            if (apendmin > endmin) {
                apendmin = endmin;
            }
            box.setTopAdjustment((apstartmin - startmin) / (endmin - startmin));
            box.setBottomAdjustment((apendmin - startmin) / (endmin - startmin) - 1.0E-6);
        }
        for (int t = (int)startmin; t <= (int)endmin; t += 5) {
            ArrayList<ApptBox> lst = new ArrayList<ApptBox>();
            for (ApptBox curBox : boxlist) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(curBox.appt.getDate());
                int amin = cal.get(11) * 60 + cal.get(12);
                if (amin > t || amin + curBox.appt.getDuration() <= t) continue;
                lst.add(curBox);
            }
            for (ApptBox curBox : lst) {
                curBox.setMaxAcrossAtOneTime(Math.max(curBox.getMaxAcrossAtOneTime(), lst.size()));
            }
        }
        Collections.sort(boxlist, new Comparator<ApptBox>(){

            @Override
            public int compare(ApptBox obj1, ApptBox obj2) {
                int diff = obj2.getMaxAcrossAtOneTime() - obj1.getMaxAcrossAtOneTime();
                if (diff != 0) {
                    return diff;
                }
                return (int)(obj2.getDate().getTime() - obj1.getDate().getTime());
            }
        });
        for (ApptBox curBox : boxlist) {
            double maxRightOfPlaced = 0.0;
            for (ApptBox otherBox : boxlist) {
                if (otherBox == curBox || otherBox.getTopAdjustment() > curBox.getBottomAdjustment() || otherBox.getBottomAdjustment() < curBox.getTopAdjustment()) continue;
                if (otherBox.getMaxAcrossAtOneTime() < curBox.getMaxAcrossAtOneTime()) {
                    otherBox.setMaxAcrossAtOneTime(curBox.getMaxAcrossAtOneTime());
                }
                if (!otherBox.isPlaced() || !(otherBox.getRightAdjustment() > maxRightOfPlaced)) continue;
                maxRightOfPlaced = otherBox.getRightAdjustment();
            }
            if (maxRightOfPlaced >= 0.999) {
                block6: for (int slot = 0; slot < curBox.getMaxAcrossAtOneTime(); ++slot) {
                    boolean slotTaken = false;
                    for (ApptBox otherBox : boxlist) {
                        if (otherBox == curBox || !otherBox.isPlaced() || otherBox.getTopAdjustment() > curBox.getBottomAdjustment() || otherBox.getBottomAdjustment() < curBox.getTopAdjustment()) continue;
                        if (Math.abs(otherBox.getLeftAdjustment() - (double)slot / (double)otherBox.getMaxAcrossAtOneTime()) < 0.001) {
                            slotTaken = true;
                            continue block6;
                        }
                        if (slotTaken) continue;
                        curBox.setLeftAdjustment((double)slot / (double)curBox.getMaxAcrossAtOneTime());
                        curBox.setRightAdjustment(curBox.getLeftAdjustment() + 1.0 / (double)curBox.getMaxAcrossAtOneTime());
                        curBox.setPlaced(true);
                        continue block6;
                    }
                }
            }
            if (curBox.isPlaced()) continue;
            curBox.setLeftAdjustment(maxRightOfPlaced);
            curBox.setRightAdjustment(curBox.getLeftAdjustment() + 1.0 / (double)curBox.getMaxAcrossAtOneTime());
            curBox.setPlaced(true);
        }
        for (ApptBox b : boxlist) {
            Rectangle r = new Rectangle();
            r.x = (int)((double)b.bounds.x + (double)b.bounds.width * b.getLeftAdjustment());
            r.y = (int)((double)b.bounds.y + (double)b.bounds.height * b.getTopAdjustment());
            r.height = (int)((b.getBottomAdjustment() - b.getTopAdjustment()) * (double)b.bounds.height);
            r.width = (int)((b.getRightAdjustment() - b.getLeftAdjustment()) * (double)b.bounds.width);
            b.setBounds(r);
        }
    }

    public ApptBox(Date d, Appointment ap, Rectangle bounds, Rectangle clip) {
        super(bounds, clip);
        this.appt = ap;
        this.date = d;
        String iconname = Prefs.getPref(PrefName.UCS_MARKER);
        String use_marker = Prefs.getPref(PrefName.UCS_MARKTODO);
        if (use_marker.equals("true")) {
            if (iconname.endsWith(".gif") || iconname.endsWith(".jpg")) {
                this.todoIcon = new ImageIcon(this.getClass().getResource("/resource/" + iconname));
            } else {
                this.todoMarker = iconname;
            }
        }
        try {
            Collection atts = LinkModel.getReference().getLinks((KeyedEntity)this.appt);
            if (atts != null && atts.size() > 0) {
                this.hasLink = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.appt.setText(AppointmentTextFormat.format(this.appt, d));
    }

    @Override
    public void delete() {
        AppointmentModel.getReference().delAppt(this.appt.getKey());
    }

    @Override
    public void draw(Graphics2D g2, Component comp) {
        Shape s = g2.getClip();
        if (this.clip != null) {
            g2.setClip(this.clip);
        }
        Font sm_font = g2.getFont();
        int smfontHeight = g2.getFontMetrics().getHeight();
        HashMap<TextAttribute, Serializable> stmap = new HashMap<TextAttribute, Serializable>();
        stmap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        stmap.put(TextAttribute.FONT, sm_font);
        Color textColor = Color.BLACK;
        textColor = Color.BLACK;
        Theme t = Theme.getCurrentTheme();
        if (this.getTextColor().equals("red")) {
            textColor = new Color(t.getTextColor1());
        } else if (this.getTextColor().equals("green")) {
            textColor = new Color(t.getTextColor3());
        } else if (this.getTextColor().equals("blue")) {
            textColor = new Color(t.getTextColor2());
        } else if (this.getTextColor().equals("black")) {
            textColor = new Color(t.getTextColor4());
        } else if (this.getTextColor().equals("white")) {
            textColor = new Color(t.getTextColor5());
        } else if (this.getTextColor().equals("navy")) {
            textColor = new Color(t.getTaskTextColor());
        } else if (this.getTextColor().equals("purple")) {
            textColor = new Color(t.getHolidayTextColor());
        } else if (this.getTextColor().equals("brick")) {
            textColor = new Color(t.getBirthdayTextColor());
        }
        if (this.oldFontHeight != smfontHeight) {
            if (this.todoIcon != null) {
                try {
                    BufferedImage image1 = ImageIO.read(this.getClass().getResource("/resource/" + Prefs.getPref(PrefName.UCS_MARKER)));
                    double size = image1.getHeight();
                    double scale = (double)smfontHeight / (2.0 * size);
                    AffineTransform tx = AffineTransform.getScaleInstance(scale, scale);
                    AffineTransformOp op = new AffineTransformOp(tx, 3);
                    BufferedImage rImage = op.filter(image1, null);
                    this.todoIcon = new ImageIcon(rImage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.oldFontHeight = smfontHeight;
        }
        Paint paint = g2.getPaint();
        if (Prefs.getBoolPref(PrefName.GRADIENT_APPTS)) {
            GradientPaint gp = new GradientPaint(this.bounds.x, this.bounds.y + 2 + smfontHeight, ApptBox.getBoxColor(), this.bounds.x, this.bounds.y + 2 * this.bounds.height, textColor);
            g2.setPaint(gp);
        } else {
            g2.setColor(ApptBox.getBoxColor());
        }
        g2.fillRoundRect(this.bounds.x + 2, this.bounds.y + 2, this.bounds.width - 2, this.bounds.height - 2, 4, 4);
        g2.setPaint(paint);
        g2.setColor(textColor);
        if (this.isSelected) {
            g2.setColor(Color.CYAN);
        }
        g2.drawRoundRect(this.bounds.x + 2, this.bounds.y + 2, this.bounds.width - 2, this.bounds.height - 2, 4, 4);
        g2.clipRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        g2.setColor(textColor);
        String text = this.getText();
        if (this.hasLink) {
            text = "@ " + text;
        }
        if (this.isTodo() && this.todoIcon != null) {
            this.todoIcon.paintIcon(comp, g2, this.bounds.x + 2, this.bounds.y + 2 + smfontHeight / 2);
            ApptBox.drawWrappedString(g2, text, this.bounds.x + 2 + this.todoIcon.getIconWidth(), this.bounds.y + 2, this.bounds.width - 2, this.getTextColor().equals("strike"));
        } else if (this.isTodo() && this.todoMarker != null) {
            ApptBox.drawWrappedString(g2, this.todoMarker + " " + text, this.bounds.x + 2, this.bounds.y + 2, this.bounds.width - 2, this.getTextColor().equals("strike"));
        } else {
            ApptBox.drawWrappedString(g2, text, this.bounds.x + 2, this.bounds.y + 2, this.bounds.width - 2, this.getTextColor().equals("strike"));
        }
        if (this.isSelected) {
            g2.setColor(new Color(50, 50, 50));
            Rectangle2D bb = g2.getFont().getStringBounds("00:00", g2.getFontRenderContext());
            g2.fillRect(this.bounds.x + 2, this.bounds.y + this.bounds.height - (int)bb.getHeight(), (int)bb.getWidth(), (int)bb.getHeight());
            g2.setColor(Color.WHITE);
            Date endtime = new Date(this.appt.getDate().getTime() + (long)(60000 * this.appt.getDuration()));
            g2.drawString(sdf.format(endtime), this.bounds.x + 2, this.bounds.y + this.bounds.height - 2);
        }
        g2.setClip(s);
        g2.setColor(Color.black);
    }

    private static void drawWrappedString(Graphics2D g2, String tx, int x, int y, int w, boolean strike) {
        int fontDesent = g2.getFontMetrics().getDescent();
        HashMap<TextAttribute, Serializable> hm = new HashMap<TextAttribute, Serializable>();
        hm.put(TextAttribute.FONT, g2.getFont());
        if (strike) {
            hm.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        AttributedString as = new AttributedString(tx, hm);
        AttributedCharacterIterator para = as.getIterator();
        int start = para.getBeginIndex();
        int endi = para.getEndIndex();
        LineBreakMeasurer lbm = new LineBreakMeasurer(para, new FontRenderContext(null, true, false));
        lbm.setPosition(start);
        int tt = y + 2;
        while (lbm.getPosition() < endi) {
            TextLayout tlayout = lbm.nextLayout(w - 2 * fontDesent);
            tt = (int)((float)tt + tlayout.getAscent());
            tlayout.draw(g2, x + 2, tt);
            tt = (int)((float)tt + (tlayout.getDescent() + tlayout.getLeading()));
        }
    }

    public double getBottomAdjustment() {
        return this.bottom;
    }

    private static Color getBoxColor() {
        return new Color(Theme.getCurrentTheme().getDefaultBg());
    }

    public Date getDate() {
        return this.date;
    }

    private double getLeftAdjustment() {
        return this.left;
    }

    private int getMaxAcrossAtOneTime() {
        return this.maxAcrossAtOneTime;
    }

    @Override
    public JPopupMenu getMenu() {
        if (this.popmenu == null) {
            this.popmenu = new JPopupMenu();
            JMenuItem mnuitm = new JMenuItem(Resource.getResourceString("Edit"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ApptBox.this.onClick();
                }
            });
            mnuitm = new JMenuItem(Resource.getResourceString("Delete"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
                    if (ret != 0) {
                        return;
                    }
                    ApptBox.this.delete();
                }
            });
            mnuitm = new JMenuItem(Resource.getResourceString("Copy"));
            this.popmenu.add(mnuitm);
            mnuitm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ClipBoard.getReference().put(ApptBox.this.appt.copy());
                }
            });
            if (this.isTodo()) {
                mnuitm = new JMenuItem(Resource.getResourceString("Done_(No_Delete)"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().do_todo(ApptBox.this.appt.getKey(), false, ApptBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
                mnuitm = new JMenuItem(Resource.getResourceString("Done_(Delete)"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().do_todo(ApptBox.this.appt.getKey(), true, ApptBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
            }
            if (Repeat.isRepeating((Appointment)this.appt)) {
                mnuitm = new JMenuItem(Resource.getResourceString("Delete_One_Only"));
                this.popmenu.add(mnuitm);
                mnuitm.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            AppointmentModel.getReference().delOneOnly(ApptBox.this.appt.getKey(), ApptBox.this.date);
                        }
                        catch (Exception e) {
                            Errmsg.getErrorHandler().errmsg(e);
                        }
                    }
                });
            }
        }
        return this.popmenu;
    }

    private double getRightAdjustment() {
        return this.right;
    }

    @Override
    public String getText() {
        return this.appt.getText();
    }

    private String getTextColor() {
        if (this.appt == null) {
            return null;
        }
        if (ApptBoxPanel.isStrike((CalendarEntity)this.appt, this.date)) {
            return "strike";
        }
        return this.appt.getColor();
    }

    public double getTopAdjustment() {
        return this.top;
    }

    private boolean isPlaced() {
        return this.isPlaced;
    }

    private boolean isTodo() {
        return this.appt.isTodo();
    }

    @Override
    public void move(int realtime, Date d) throws Exception {
        int k2;
        Appointment ap = AppointmentModel.getReference().getAppt(this.appt.getKey());
        int oldday = DateUtil.dayOfEpoch(ap.getDate());
        int hour = realtime / 60;
        int min = realtime % 60;
        if (realtime == -1) {
            ap.setDuration(null);
            ap.setUntimed("Y");
            hour = 0;
            min = 0;
        }
        GregorianCalendar newCal = new GregorianCalendar();
        newCal.setTime(d);
        newCal.set(11, hour);
        int roundMin = min / 5 * 5;
        newCal.set(12, roundMin);
        Date newTime = newCal.getTime();
        int newday = DateUtil.dayOfEpoch(newTime);
        if (oldday != newday && Repeat.isRepeating((Appointment)ap) && oldday != (k2 = DateUtil.dayOfEpoch(this.date))) {
            int incdate = newday - k2;
            newCal.setTime(ap.getDate());
            newCal.add(5, incdate);
            newTime = newCal.getTime();
        }
        ap.setDate(newTime);
        AppointmentModel.getReference().saveAppt(ap);
    }

    @Override
    public void onClick() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
        ag.showView();
        ag.showApp(this.appt.getKey());
    }

    public void resize(boolean isTop, int realtime) throws Exception {
        int hour = realtime / 60;
        int min = realtime % 60;
        if (isTop) {
            Appointment ap = AppointmentModel.getReference().getAppt(this.appt.getKey());
            Date oldTime = ap.getDate();
            GregorianCalendar newCal = new GregorianCalendar();
            newCal.setTime(oldTime);
            newCal.set(11, hour);
            int roundMin = min / 5 * 5;
            newCal.set(12, roundMin);
            Date newTime = newCal.getTime();
            int newDur = ap.getDuration() + (int)(oldTime.getTime() - newTime.getTime()) / 60000;
            if (newDur < 5) {
                return;
            }
            ap.setDate(newTime);
            ap.setDuration(new Integer(newDur));
            AppointmentModel.getReference().saveAppt(ap);
        } else {
            Appointment ap = AppointmentModel.getReference().getAppt(this.appt.getKey());
            Date start = ap.getDate();
            long endtime = start.getTime() + (long)(60000 * ap.getDuration());
            Date oldEnd = new Date(endtime);
            GregorianCalendar newEnd = new GregorianCalendar();
            newEnd.setTime(oldEnd);
            newEnd.set(11, hour);
            int roundMin = min / 5 * 5;
            newEnd.set(12, roundMin);
            int newDur = (int)(newEnd.getTime().getTime() - start.getTime()) / 60000;
            if (newDur < 5) {
                return;
            }
            ap.setDuration(new Integer(newDur));
            AppointmentModel.getReference().saveAppt(ap);
        }
    }

    private void setBottomAdjustment(double bottom) {
        this.bottom = bottom;
    }

    private void setLeftAdjustment(double left) {
        this.left = left;
    }

    private void setMaxAcrossAtOneTime(int maxAcrossAtOneTime) {
        this.maxAcrossAtOneTime = maxAcrossAtOneTime;
    }

    private void setPlaced(boolean isPlaced) {
        this.isPlaced = isPlaced;
    }

    private void setRightAdjustment(double right) {
        this.right = right;
    }

    private void setTopAdjustment(double top) {
        this.top = top;
    }

    @Override
    public String getToolTipText() {
        return this.getText();
    }
}

