/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Date;
import javax.swing.Icon;
import net.sf.borg.model.Theme;
import net.sf.borg.ui.calendar.Box;

public abstract class ButtonBox
extends Box {
    private Date date;
    private Icon icon_ = null;
    private Color backg = null;
    private String text = null;

    public ButtonBox(Date d, String text, Icon icon, Rectangle bounds, Rectangle clip) {
        super(bounds, clip);
        this.date = d;
        this.text = text;
        this.icon_ = icon;
    }

    public ButtonBox(Date d, String text, Icon icon, Rectangle bounds, Rectangle clip, Color b) {
        super(bounds, clip);
        this.date = d;
        this.text = text;
        this.icon_ = icon;
        this.backg = b;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public void draw(Graphics2D g2, Component comp) {
        Theme t = Theme.getCurrentTheme();
        Shape s = g2.getClip();
        if (this.clip != null) {
            g2.setClip(this.clip);
        }
        if (this.isSelected) {
            g2.setColor(new Color(t.getDefaultFg()));
            g2.fillRect(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.bounds.height);
            g2.setColor(new Color(t.getDefaultBg()));
        } else if (this.backg != null) {
            g2.setColor(this.backg);
            g2.fillRect(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.bounds.height);
            g2.setColor(new Color(t.getDefaultFg()));
        } else {
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(this.bounds.x, this.bounds.y + 2, this.bounds.width, this.bounds.height);
            g2.setColor(new Color(t.getDefaultFg()));
        }
        int smfontHeight = g2.getFontMetrics().getHeight();
        g2.drawString(this.text, this.bounds.x + 2, this.bounds.y + smfontHeight);
        if (this.icon_ != null) {
            this.icon_.paintIcon(null, g2, this.bounds.x + this.bounds.width - 16, this.bounds.y);
        }
        g2.setClip(s);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public int clicksToActivate() {
        return 1;
    }
}

