/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.PrintHelper;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Day;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.NavPanel;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.calendar.ApptBox;
import net.sf.borg.ui.calendar.ApptBoxPanel;
import net.sf.borg.ui.calendar.Box;
import net.sf.borg.ui.calendar.ButtonBox;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class WeekPanel
extends DockableView
implements Printable,
MultiView.CalendarModule {
    private static final long serialVersionUID = 1L;
    private NavPanel nav = null;
    private WeekSubPanel wp_ = null;
    private boolean isInitialized = false;

    @Override
    public void goTo(Calendar cal) {
        if (this.isInitialized) {
            this.wp_.goTo(cal);
            this.nav.setLabel(this.wp_.getNavLabel());
        }
    }

    @Override
    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return this.wp_.print(arg0, arg1, arg2);
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("Week_View");
    }

    @Override
    public JPanel getComponent() {
        if (!this.isInitialized) {
            this.wp_ = new WeekSubPanel();
            this.nav = new NavPanel(this.wp_);
            JScrollPane sp = new JScrollPane();
            sp.setViewportView(this.wp_);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.nav, GridBagConstraintsFactory.create(0, 0, 1));
            this.add((Component)sp, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/week.jpg")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.WEEK);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.WEEK);
            }
        });
    }

    @Override
    public void print() {
        try {
            PrintHelper.printPrintable(this);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.WEEK;
    }

    @Override
    public String getFrameTitle() {
        return this.getModuleName();
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
    }

    private class WeekSubPanel
    extends ApptBoxPanel
    implements NavPanel.Navigator,
    Prefs.Listener,
    Model.Listener,
    Printable,
    MouseWheelListener {
        private static final long serialVersionUID = 1L;
        private Date beg_ = null;
        private double colwidth = 0.0;
        private float[] dash1 = new float[]{1.0f, 3.0f};
        private BasicStroke dashed = new BasicStroke(0.02f, 0, 0, 3.0f, this.dash1, 0.0f);
        private int date_;
        private int month_;
        private int year_;
        private double nonTimedPortion = 0.16666666666666666;
        private boolean needLoad = true;
        private int lastDrawDate = -1;
        private double timecolwidth = 0.0;
        private Color[] backgroundColors = new Color[7];
        private int zoom = 0;

        public WeekSubPanel() {
            Prefs.addListener(this);
            this.addMouseWheelListener(this);
            AppointmentModel.getReference().addListener((Model.Listener)this);
            TaskModel.getReference().addListener((Model.Listener)this);
            this.goTo(new GregorianCalendar());
        }

        public void clearData() {
            this.clearBoxes();
            this.needLoad = true;
            this.setToolTipText(null);
        }

        private int drawIt(Graphics g, double width, double height, double pageWidth, double pageHeight, double pagex, double pagey, Font sm_font) {
            Theme t = Theme.getCurrentTheme();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            HashMap<TextAttribute, Serializable> stmap = new HashMap<TextAttribute, Serializable>();
            stmap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            stmap.put(TextAttribute.FONT, sm_font);
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, 0, (int)width, (int)height);
            g2.setColor(new Color(t.getDefaultFg()));
            int fontHeight = g2.getFontMetrics().getHeight();
            int fontDesent = g2.getFontMetrics().getDescent();
            g2.translate(pagex, pagey);
            Shape s = g2.getClip();
            GregorianCalendar now = new GregorianCalendar();
            int tdate = now.get(5);
            if (this.lastDrawDate != tdate) {
                this.needLoad = true;
            }
            this.lastDrawDate = tdate;
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, this.date_, 23, 59);
            int fdow = Prefs.getIntPref(PrefName.FIRSTDOW);
            cal.setFirstDayOfWeek(fdow);
            int offset = cal.get(7) - fdow;
            if (offset == -1) {
                offset = 6;
            }
            cal.add(5, -1 * offset);
            this.beg_ = cal.getTime();
            int caltop = 0;
            int daytop = caltop + fontHeight + fontDesent;
            double rowheight = pageHeight - (double)daytop;
            this.timecolwidth = pageWidth / 21.0;
            double aptop = (double)caltop + rowheight * this.nonTimedPortion;
            this.colwidth = (pageWidth - this.timecolwidth) / 7.0;
            int calbot = (int)rowheight + daytop;
            this.setResizeBounds((int)aptop, calbot);
            this.setDragBounds(daytop, calbot, (int)this.timecolwidth, (int)pageWidth);
            String shr = Prefs.getPref(PrefName.WKSTARTHOUR);
            String ehr = Prefs.getPref(PrefName.WKENDHOUR);
            int starthr = 7;
            int endhr = 22;
            try {
                starthr = Integer.parseInt(shr);
                endhr = Integer.parseInt(ehr);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
            int numhalfhours = (endhr - starthr) * 2;
            double tickheight = ((double)calbot - aptop) / (double)numhalfhours;
            SimpleDateFormat dfw = new SimpleDateFormat("EEE dd");
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, caltop, (int)this.timecolwidth, calbot - caltop);
            g2.setColor(new Color(t.getDefaultFg()));
            g2.setFont(sm_font);
            int smfontHeight = g2.getFontMetrics().getHeight();
            for (int col = 0; col < 7; ++col) {
                int colleft = (int)(this.timecolwidth + (double)col * this.colwidth);
                if (this.needLoad) {
                    GregorianCalendar today = new GregorianCalendar();
                    this.addDateZone(cal.getTime(), new Rectangle(colleft, 0, (int)this.colwidth, calbot));
                    try {
                        this.startmin = starthr * 60;
                        this.endmin = endhr * 60;
                        Day dayInfo = Day.getDay((int)cal.get(1), (int)cal.get(2), (int)cal.get(5));
                        Color backgroundColor = null;
                        int dow = cal.get(7);
                        backgroundColor = today.get(2) == this.month_ && today.get(1) == this.year_ && today.get(5) == cal.get(5) ? new Color(t.getTodayBg()) : (dayInfo.getHoliday() != 0 ? new Color(t.getHolidayBg()) : (dayInfo.getVacation() == 1 ? new Color(Theme.getCurrentTheme().getVacationBg()) : (dayInfo.getVacation() == 2 ? new Color(t.getHalfdayBg()) : (dow == 1 || dow == 7 ? new Color(t.getWeekendBg()) : new Color(t.getWeekdayBg())))));
                        this.backgroundColors[col] = backgroundColor;
                        int notey = daytop;
                        for (CalendarEntity entity : dayInfo.getItems()) {
                            Date d = entity.getDate();
                            if (d == null) continue;
                            GregorianCalendar acal = new GregorianCalendar();
                            acal.setTime(d);
                            double apstartmin = 60 * acal.get(11) + acal.get(12);
                            int dur = 0;
                            Integer duri = entity.getDuration();
                            if (duri != null) {
                                dur = duri;
                            }
                            double apendmin = apstartmin + (double)dur;
                            if (!(entity instanceof Appointment) || AppointmentModel.isNote((Appointment)((Appointment)entity)) || apendmin < this.startmin || apstartmin >= this.endmin - 4.0 || entity.getDuration() == null || entity.getDuration() == 0) {
                                if (this.addNoteBox(cal.getTime(), entity, new Rectangle(colleft + 2, notey, (int)(this.colwidth - 4.0), smfontHeight), new Rectangle(colleft, caltop, (int)this.colwidth, (int)(aptop - (double)caltop))) == null) continue;
                                notey += smfontHeight;
                                continue;
                            }
                            this.addApptBox(cal.getTime(), (Appointment)entity, new Rectangle(colleft + 4, (int)aptop, (int)this.colwidth - 8, (int)((double)calbot - aptop)), new Rectangle(colleft, (int)aptop, (int)this.colwidth, (int)((double)calbot - aptop)));
                        }
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                    ArrayList<ApptBox> layoutlist = new ArrayList<ApptBox>();
                    for (Box b : this.boxes) {
                        if (!(b instanceof ApptBox)) continue;
                        ApptBox ab = (ApptBox)b;
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTime(ab.getDate());
                        if (c.get(6) != cal.get(6)) continue;
                        layoutlist.add(ab);
                    }
                    ApptBox.layoutBoxes(layoutlist, starthr, endhr);
                }
                g2.setClip(s);
                int nextColumnLeft = (int)(this.timecolwidth + (double)(col + 1) * this.colwidth);
                int fixedWidth = nextColumnLeft - colleft;
                g2.setColor(this.getBackground());
                g2.fillRect(colleft, caltop, fixedWidth, daytop - caltop);
                g2.setColor(this.backgroundColors[col]);
                g2.fillRect(colleft, caltop, fixedWidth, calbot - caltop);
                g2.setColor(new Color(t.getDefaultFg()));
                cal.add(5, 1);
            }
            this.needLoad = false;
            Stroke defstroke = g2.getStroke();
            g2.setStroke(this.dashed);
            for (int row = 0; row < numhalfhours; ++row) {
                int rowtop = (int)((double)row * tickheight + aptop);
                g2.drawLine((int)this.timecolwidth, rowtop, (int)pageWidth, rowtop);
            }
            g2.setStroke(defstroke);
            if (this.zoom < 4) {
                this.boxes.add(new ButtonBox(cal.getTime(), "", new ImageIcon(this.getClass().getResource("/resource/ZoomIn16.gif")), new Rectangle(0, caltop, 20, smfontHeight), null){

                    @Override
                    public void onClick() {
                        WeekSubPanel.this.zoom++;
                        WeekSubPanel.this.refresh();
                    }
                });
            }
            if (this.zoom > 0) {
                this.boxes.add(new ButtonBox(cal.getTime(), "", new ImageIcon(this.getClass().getResource("/resource/ZoomOut16.gif")), new Rectangle((int)this.timecolwidth - 20, caltop, 20, smfontHeight), null){

                    @Override
                    public void onClick() {
                        WeekSubPanel.this.zoom--;
                        WeekSubPanel.this.refresh();
                    }
                });
            }
            if (this.nonTimedPortion < 0.8) {
                this.boxes.add(new ButtonBox(cal.getTime(), "", new ImageIcon(this.getClass().getResource("/resource/Down16.gif")), new Rectangle(0, (int)aptop, (int)this.timecolwidth, smfontHeight), null){

                    @Override
                    public void onClick() {
                        WeekSubPanel.this.nonTimedPortion += 0.16666666666666666;
                        WeekSubPanel.this.refresh();
                    }
                });
            }
            if (this.nonTimedPortion > 0.2) {
                this.boxes.add(new ButtonBox(cal.getTime(), "", new ImageIcon(this.getClass().getResource("/resource/Up16.gif")), new Rectangle(0, (int)aptop - smfontHeight, (int)this.timecolwidth, smfontHeight), null){

                    @Override
                    public void onClick() {
                        WeekSubPanel.this.nonTimedPortion -= 0.16666666666666666;
                        WeekSubPanel.this.refresh();
                    }
                });
            }
            this.drawBoxes(g2);
            g2.setColor(new Color(t.getDefaultFg()));
            cal.setTime(this.beg_);
            for (int col = 0; col < 7; ++col) {
                int colleft = (int)(this.timecolwidth + (double)col * this.colwidth);
                String dayofweek = dfw.format(cal.getTime());
                int swidth = g2.getFontMetrics().stringWidth(dayofweek);
                g2.drawString(dayofweek, (int)((double)colleft + (this.colwidth - (double)swidth) / 2.0), caltop + fontHeight);
                cal.add(5, 1);
            }
            g2.drawLine(0, caltop, (int)pageWidth, caltop);
            g2.drawLine(0, daytop, (int)pageWidth, daytop);
            g2.drawLine(0, (int)aptop, (int)pageWidth, (int)aptop);
            g2.drawLine(0, calbot, (int)pageWidth, calbot);
            g2.drawLine(0, caltop, 0, calbot);
            g2.setFont(sm_font);
            boolean mt = false;
            String mil = Prefs.getPref(PrefName.MILTIME);
            if (mil.equals("true")) {
                mt = true;
            }
            for (int row = 1; row < endhr - starthr; ++row) {
                int y = (int)((double)row * tickheight * 2.0 + aptop);
                int hr = row + starthr;
                if (!mt && hr > 12) {
                    hr -= 12;
                }
                String tmlabel = Integer.toString(hr) + ":00";
                g2.drawString(tmlabel, 2, y + smfontHeight / 2);
            }
            for (int col = 0; col < 8; ++col) {
                int colleft = (int)(this.timecolwidth + (double)col * this.colwidth);
                g2.drawLine(colleft, caltop, colleft, calbot);
            }
            return 0;
        }

        @Override
        public Date getDateForCoord(double x, double y) {
            double col = (x - this.timecolwidth) / this.colwidth;
            if (col > 6.0) {
                col = 6.0;
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.beg_);
            ((Calendar)cal).add(5, (int)col);
            return cal.getTime();
        }

        @Override
        public String getNavLabel() {
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, this.date_, 23, 59);
            int fdow = Prefs.getIntPref(PrefName.FIRSTDOW);
            cal.setFirstDayOfWeek(fdow);
            int offset = cal.get(7) - fdow;
            if (offset == -1) {
                offset = 6;
            }
            cal.add(5, -1 * offset);
            Date beg = cal.getTime();
            cal.add(5, 6);
            Date end = cal.getTime();
            DateFormat df = DateFormat.getDateInstance(1);
            return df.format(beg) + " " + Resource.getResourceString("__through__") + " " + df.format(end);
        }

        @Override
        public void goTo(Calendar cal) {
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.date_ = cal.get(5);
            this.clearData();
            this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() > 0) {
                this.next();
                WeekPanel.this.nav.setLabel(this.getNavLabel());
            } else if (e.getWheelRotation() < 0) {
                this.prev();
                WeekPanel.this.nav.setLabel(this.getNavLabel());
            }
        }

        @Override
        public void next() {
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, this.date_, 23, 59);
            cal.add(5, 7);
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.date_ = cal.get(5);
            this.clearData();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            try {
                Font sm_font = Font.decode(Prefs.getPref(PrefName.WEEKVIEWFONT));
                this.drawIt(g, this.getWidth(), this.getHeight(), this.getWidth() - 20, this.getHeight() - 20, 10.0, 10.0, sm_font);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void prefsChanged() {
            this.clearData();
            this.repaint();
        }

        @Override
        public void prev() {
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, this.date_, 23, 59);
            cal.add(5, -7);
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.date_ = cal.get(5);
            this.clearData();
            this.repaint();
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            Font sm_font = Font.decode(Prefs.getPref(PrefName.PRINTFONT));
            this.clearData();
            int ret = this.drawIt(g, pageFormat.getWidth(), pageFormat.getHeight(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight(), pageFormat.getImageableX(), pageFormat.getImageableY(), sm_font);
            this.refresh();
            return ret;
        }

        @Override
        public void refresh() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dim = toolkit.getScreenSize();
            int h = (this.zoom + 2) * (int)dim.getHeight() / 2;
            if (this.zoom == 0) {
                h = 0;
            }
            this.setPreferredSize(new Dimension(0, h));
            this.clearData();
            this.repaint();
            this.getParent().doLayout();
        }

        public void update(Model.ChangeEvent event) {
            this.refresh();
        }

        @Override
        public void today() {
            GregorianCalendar cal = new GregorianCalendar();
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.date_ = cal.get(5);
            this.clearData();
            this.repaint();
        }
    }
}

