/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.checklist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.CheckListModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.entity.CheckList;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.InputDialog;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

public class CheckListPanel
extends DockableView
implements ListSelectionListener,
MultiView.Module,
TableModelListener {
    private TableCellRenderer defaultTextRenderer = null;
    private static final int COMPLETE_COLUMN = 0;
    private static final long serialVersionUID = 1L;
    private static final int TEXT_COLUMN = 1;
    private StripedTable checkListListTable = null;
    private int editedCheckListIndex = -1;
    private boolean isCheckListEdited = false;
    private StripedTable itemTable = null;
    private boolean isInitialized = false;
    private ActionListener renameAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = CheckListPanel.this.getSelectedCheckListName();
            if (name == null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_CheckList_Warning"));
                return;
            }
            String newname = InputDialog.show(Resource.getResourceString("Enter_CheckList_Name"), 50);
            if (newname == null || newname.isEmpty() || newname.equals(name)) {
                return;
            }
            if (newname.length() > 50) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("max_length", new String[]{Resource.getResourceString("CheckList_Name"), "50"}));
                return;
            }
            try {
                CheckList m = CheckListModel.getReference().getCheckList(name);
                m.setCheckListName(newname);
                CheckListModel.getReference().saveCheckList(m);
                CheckListModel.getReference().delete(name, false);
                CheckListPanel.this.loadCheckListsFromModel();
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
            }
        }
    };

    @Override
    public boolean canClose() {
        int ret;
        if (this.isCheckListEdited && (ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_CheckList"), Resource.getResourceString("Discard_Text?"), 2, 3)) != 0) {
            return false;
        }
        try {
            this.isCheckListEdited = false;
            this.loadCheckListsFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return true;
    }

    private void deleteCheckList() {
        String name = this.getSelectedCheckListName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_CheckList_Warning"));
            return;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
        if (ret != 0) {
            return;
        }
        try {
            CheckListModel.getReference().delete(name, false);
            this.isCheckListEdited = false;
            this.loadCheckListsFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void copyCheckList() {
        String name = this.getSelectedCheckListName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_CheckList_Warning"));
            return;
        }
        if (this.isCheckListEdited) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Cannot_Copy"));
            return;
        }
        String newname = InputDialog.show(Resource.getResourceString("Enter_CheckList_Name"), 50);
        if (newname == null || newname.trim().isEmpty()) {
            return;
        }
        try {
            CheckList existing = CheckListModel.getReference().getCheckList(newname);
            if (existing != null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Existing_CheckList"));
                return;
            }
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
        }
        try {
            CheckList orig = CheckListModel.getReference().getCheckList(name);
            CheckList copy = orig.clone();
            copy.setCheckListName(newname);
            CheckListModel.getReference().saveCheckList(copy);
            this.loadCheckListsFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public JComponent getComponent() {
        if (!this.isInitialized) {
            this.initializeComponents();
            new PopupMenuHelper(this.checkListListTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(this.renameAction, "Rename")});
            this.refresh();
            CheckListModel.getReference().addListener((Model.Listener)this);
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public String getFrameTitle() {
        return this.getModuleName();
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("CheckLists");
    }

    private String getSelectedCheckListName() {
        int row = this.checkListListTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TableSorter tm = (TableSorter)this.checkListListTable.getModel();
        String checkListName = (String)tm.getValueAt(row, 0);
        return checkListName;
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.CHECKLIST;
    }

    private void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JSplitPane checkListSplitPane = new JSplitPane();
        checkListSplitPane.setResizeWeight(0.2);
        JScrollPane checkListListScroll = new JScrollPane();
        checkListListScroll.setHorizontalScrollBarPolicy(31);
        checkListListScroll.setPreferredSize(new Dimension(100, 423));
        this.checkListListTable = new StripedTable();
        this.checkListListTable.setSelectionMode(0);
        this.checkListListTable.setShowGrid(true);
        checkListListScroll.setViewportView(this.checkListListTable);
        this.checkListListTable.setModel(new TableSorter(new String[]{Resource.getResourceString("CheckList_Name")}, new Class[]{String.class}));
        ListSelectionModel rowSM = this.checkListListTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        checkListSplitPane.setLeftComponent(checkListListScroll);
        JScrollPane checkListTextScroll = new JScrollPane();
        checkListTextScroll.setPreferredSize(new Dimension(400, 400));
        this.itemTable = new StripedTable();
        this.defaultTextRenderer = this.itemTable.getDefaultRenderer(String.class);
        this.itemTable.setDefaultRenderer(String.class, new ItemTextRenderer());
        TableSorter ts = new TableSorter(new String[]{"", Resource.getResourceString("Item")}, new Class[]{Boolean.class, String.class}, new boolean[]{true, true});
        this.itemTable.setModel(ts);
        this.itemTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.itemTable.getColumnModel().getColumn(0).setMinWidth(20);
        this.itemTable.getModel().addTableModelListener(this);
        this.itemTable.getSelectionModel().setSelectionMode(0);
        ts.addMouseListenerToHeaderInTable(this.itemTable);
        new PopupMenuHelper(this.itemTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter model = (TableSorter)CheckListPanel.this.itemTable.getModel();
                int index = CheckListPanel.this.itemTable.getSelectedRow();
                Object[] row = new Object[]{Boolean.FALSE, ""};
                model.insertRow(index, row);
            }
        }, "Insert_Above"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableSorter model = (TableSorter)CheckListPanel.this.itemTable.getModel();
                int index = CheckListPanel.this.itemTable.getSelectedRow();
                Object[] row = new Object[]{Boolean.FALSE, ""};
                model.insertRow(index + 1, row);
            }
        }, "Insert_Below"), new PopupMenuHelper.Entry(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckListPanel.this.removeRow();
            }
        }, "Remove")});
        checkListTextScroll.setViewportView(this.itemTable);
        checkListSplitPane.setRightComponent(checkListTextScroll);
        this.add((Component)checkListSplitPane, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        GridBagConstraints gridBagConstraints1 = GridBagConstraintsFactory.create(0, 0, 2);
        gridBagConstraints1.anchor = 17;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton newButton = new JButton();
        newButton.setText(Resource.getResourceString("New_CheckList"));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListPanel.this.newCheckList();
            }
        });
        buttonPanel.add((Component)newButton, null);
        JButton saveButton = new JButton();
        saveButton.setText(Resource.getResourceString("Save_CheckList"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListPanel.this.saveCheckList();
            }
        });
        buttonPanel.add((Component)saveButton, null);
        JButton deleteButton = new JButton();
        deleteButton.setText(Resource.getResourceString("Delete_CheckList"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListPanel.this.deleteCheckList();
            }
        });
        buttonPanel.add((Component)deleteButton, null);
        JButton copyButton = new JButton();
        copyButton.setText(Resource.getResourceString("Copy_CheckList"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListPanel.this.copyCheckList();
            }
        });
        buttonPanel.add((Component)copyButton, null);
        JButton uncheckButton = new JButton();
        uncheckButton.setText(Resource.getResourceString("Uncheck_All"));
        uncheckButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListPanel.this.uncheckAll();
            }
        });
        buttonPanel.add((Component)uncheckButton, null);
        this.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1, 1));
        JPanel sidePanel = new JPanel();
        sidePanel.setLayout(new GridBagLayout());
        JButton upButton = new JButton();
        upButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Up16.gif")));
        sidePanel.add((Component)upButton, GridBagConstraintsFactory.create(0, 0));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableSorter model = (TableSorter)CheckListPanel.this.itemTable.getModel();
                int index = CheckListPanel.this.itemTable.getSelectedRow();
                if (index > 0) {
                    model.moveRow(index, index - 1);
                    CheckListPanel.this.itemTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
                }
            }
        });
        JButton downButton = new JButton();
        downButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Down16.gif")));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableSorter model = (TableSorter)CheckListPanel.this.itemTable.getModel();
                int index = CheckListPanel.this.itemTable.getSelectedRow();
                if (index < model.getRowCount() - 1) {
                    model.moveRow(index, index + 1);
                    CheckListPanel.this.itemTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
                }
            }
        });
        sidePanel.add((Component)downButton, GridBagConstraintsFactory.create(0, 1));
        this.add((Component)sidePanel, GridBagConstraintsFactory.create(1, 0, 1));
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.CHECKLIST);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.CHECKLIST);
            }
        });
    }

    private void loadCheckListsFromModel() throws Exception {
        this.checkListListTable.clearSelection();
        TableSorter tm = (TableSorter)this.checkListListTable.getModel();
        tm.setRowCount(0);
        Collection names = CheckListModel.getReference().getNames();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            tm.addRow(new Object[]{it.next()});
        }
        TableSorter model = (TableSorter)this.itemTable.getModel();
        model.setRowCount(0);
        this.isCheckListEdited = false;
    }

    private void loadItems(CheckList cl) {
        TableSorter model = (TableSorter)this.itemTable.getModel();
        model.setRowCount(0);
        if (cl != null) {
            for (CheckList.Item item : cl.getItems()) {
                Object[] row = new Object[]{item.getChecked(), item.getText()};
                model.addRow(row);
            }
            Object[] addrow = new Object[]{Boolean.FALSE, ""};
            model.addRow(addrow);
        }
    }

    private void newCheckList() {
        int ret;
        if (this.isCheckListEdited && (ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_CheckList"), Resource.getResourceString("Discard_Text?"), 2, 3)) != 0) {
            return;
        }
        String name = InputDialog.show(Resource.getResourceString("Enter_CheckList_Name"), 50);
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        try {
            CheckList existing = CheckListModel.getReference().getCheckList(name);
            if (existing != null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Existing_CheckList"));
                return;
            }
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
        }
        CheckList m = new CheckList();
        m.setCheckListName(name);
        try {
            CheckListModel.getReference().saveCheckList(m);
            this.isCheckListEdited = false;
            this.loadCheckListsFromModel();
            this.selectCheckList(name);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void print() {
        try {
            String selectedCheckList = this.getSelectedCheckListName();
            if (selectedCheckList == null) {
                return;
            }
            TablePrinter.printTable(this.itemTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void refresh() {
        if (this.isCheckListEdited) {
            return;
        }
        try {
            this.loadCheckListsFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void removeRow() {
        int index;
        int mapped;
        TableSorter model = (TableSorter)this.itemTable.getModel();
        String s = (String)model.getValueAt(mapped = model.getMappedIndex(index = this.itemTable.getSelectedRow()), 1);
        if ((s == null || s.isEmpty()) && index == model.getRowCount() - 1) {
            return;
        }
        model.removeRow(mapped);
    }

    private void saveCheckList() {
        String name = this.getSelectedCheckListName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_CheckList_Warning"));
            return;
        }
        try {
            CheckList m = CheckListModel.getReference().getCheckList(name);
            this.setItems(m);
            CheckListModel.getReference().saveCheckList(m);
            this.isCheckListEdited = false;
            this.loadCheckListsFromModel();
            this.selectCheckList(name);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void selectCheckList(String checkListName) {
        TableSorter tm = (TableSorter)this.checkListListTable.getModel();
        int rows = tm.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String name = (String)tm.getValueAt(i, 0);
            if (!checkListName.equals(name)) continue;
            this.checkListListTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    private void setItems(CheckList cl) {
        if (this.itemTable.isEditing()) {
            this.itemTable.getCellEditor().stopCellEditing();
        }
        cl.getItems().clear();
        TableSorter model = (TableSorter)this.itemTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            CheckList.Item item = new CheckList.Item();
            item.setChecked((Boolean)model.getValueAt(i, 0));
            item.setText((String)model.getValueAt(i, 1));
            if (item.getText().isEmpty()) continue;
            cl.getItems().add(item);
        }
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (arg0.getSource() instanceof TableSorter) {
            return;
        }
        if (arg0.getType() == 1) {
            return;
        }
        this.isCheckListEdited = true;
        this.editedCheckListIndex = this.checkListListTable.getSelectedRow();
        if (arg0.getType() == -1) {
            return;
        }
        TableSorter model = (TableSorter)this.itemTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String text = (String)model.getValueAt(i, 1);
            if (!text.isEmpty()) continue;
            return;
        }
        Object[] addrow = new Object[]{Boolean.FALSE, ""};
        model.addRow(addrow);
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String checkListName;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.isCheckListEdited) {
            if (this.editedCheckListIndex == this.checkListListTable.getSelectedRow()) {
                return;
            }
            int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_CheckList"), Resource.getResourceString("Discard_Text?"), 2, 3);
            if (ret != 0) {
                this.checkListListTable.getSelectionModel().setSelectionInterval(this.editedCheckListIndex, this.editedCheckListIndex);
                return;
            }
        }
        if ((checkListName = this.getSelectedCheckListName()) == null) {
            this.loadItems(null);
        } else {
            try {
                CheckList m = CheckListModel.getReference().getCheckList(checkListName);
                this.loadItems(m);
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
                return;
            }
        }
        this.isCheckListEdited = false;
    }

    private void uncheckAll() {
        String name = this.getSelectedCheckListName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_CheckList_Warning"));
            return;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Uncheck_All") + "?", Resource.getResourceString("Uncheck_All"), 2, 3);
        if (ret != 0) {
            return;
        }
        TableSorter model = (TableSorter)this.itemTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            model.setValueAt(Boolean.FALSE, i, 0);
        }
        model.fireTableDataChanged();
    }

    @Override
    public void cleanUp() {
        this.checkListListTable.clearSelection();
    }

    private class ItemTextRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ItemTextRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)CheckListPanel.this.defaultTextRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(l.getHorizontalAlignment());
            this.setForeground(l.getForeground());
            this.setBackground(l.getBackground());
            String text = l.getText();
            Boolean complete = (Boolean)table.getModel().getValueAt(row, 0);
            if (complete == Boolean.TRUE) {
                text = "<HTML><STRIKE>" + text + "</STRIKE></HTML>";
            }
            this.setText(text);
            return this;
        }
    }
}

