/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.ical;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.iharder.dnd.FileDrop;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.IOHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ical.AppointmentIcalAdapter;
import net.sf.borg.model.ical.CalDav;
import net.sf.borg.model.ical.IcalFTP;
import net.sf.borg.model.ical.IcalFileServer;
import net.sf.borg.model.ical.SyncLog;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.options.IcalOptionsPanel;
import net.sf.borg.ui.options.OptionsView;

public class IcalModule
implements MultiView.Module {
    private static PrefName url_pref = new PrefName("saved_import_url", "");

    @Override
    public Component getComponent() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "ICAL";
    }

    @Override
    public MultiView.ViewType getViewType() {
        return null;
    }

    public static JMenu getIcalMenu() {
        JMenu m = new JMenu();
        m.setText("Ical");
        m.setIcon(new ImageIcon(IcalModule.class.getResource("/resource/Export16.gif")));
        JMenu calmenu = new JMenu("CALDAV");
        JMenuItem caldavs = new JMenuItem();
        caldavs.setText(Resource.getResourceString("CALDAV-Sync"));
        caldavs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (!CalDav.isSyncing()) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Sync-Not-Set"), null, 0);
                        return;
                    }
                    IcalModule.runBackgroundSync(Synctype.FULL);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        calmenu.add(caldavs);
        JMenuItem caldavso = new JMenuItem();
        caldavso.setText(Resource.getResourceString("CALDAV-Sync-out"));
        caldavso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (!CalDav.isSyncing()) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Sync-Not-Set"), null, 0);
                        return;
                    }
                    IcalModule.runBackgroundSync(Synctype.ONEWAY);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        calmenu.add(caldavso);
        JMenuItem caldavo = new JMenuItem();
        caldavo.setText(Resource.getResourceString("CALDAV-Overwrite"));
        caldavo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (!CalDav.isSyncing()) {
                        JOptionPane.showMessageDialog(null, Resource.getResourceString("Sync-Not-Set"), null, 0);
                        return;
                    }
                    int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Caldav-Overwrite-Warn"), Resource.getResourceString("Confirm"), 2, 2);
                    if (ret != 0) {
                        return;
                    }
                    IcalModule.runBackgroundSync(Synctype.OVERWRITE);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        calmenu.add(caldavo);
        m.add(calmenu);
        JMenu icsmenu = new JMenu("ICS");
        JMenuItem imp = new JMenuItem();
        imp.setText(Resource.getResourceString("Import"));
        imp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter(Resource.getResourceString("ical_files"), "ics", "ICS", "ical", "ICAL", "icalendar");
                chooser.setFileFilter(filter);
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle(Resource.getResourceString("choose_file"));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                String s = chooser.getSelectedFile().getAbsolutePath();
                try {
                    String warning = AppointmentIcalAdapter.importIcalFromFile((String)s);
                    if (warning != null && !warning.isEmpty()) {
                        Errmsg.getErrorHandler().notice(warning);
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        icsmenu.add(imp);
        JMenuItem impUrl = new JMenuItem();
        impUrl.setText(Resource.getResourceString("ImportUrl"));
        impUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String urlString = JOptionPane.showInputDialog(null, Resource.getResourceString("enturl"), Prefs.getPref(url_pref));
                if (urlString == null) {
                    return;
                }
                Prefs.putPref(url_pref, urlString);
                try {
                    String warning = AppointmentIcalAdapter.importIcalFromUrl((String)urlString);
                    if (warning != null && !warning.isEmpty()) {
                        Errmsg.getErrorHandler().notice(warning);
                    }
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        icsmenu.add(impUrl);
        JMenuItem exp = new JMenuItem();
        exp.setText(Resource.getResourceString("exportToFile"));
        exp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IcalModule.export(Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS));
            }
        });
        icsmenu.add(exp);
        JMenuItem expftp = new JMenuItem();
        expftp.setText(Resource.getResourceString("exportToFTP"));
        expftp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    IcalFTP.exportftp((Integer)Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS));
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        icsmenu.add(expftp);
        JMenuItem exp3 = new JMenuItem();
        exp3.setText(Resource.getResourceString("start_server"));
        exp3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    IcalFileServer.start();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        icsmenu.add(exp3);
        JMenuItem exp4 = new JMenuItem();
        exp4.setText(Resource.getResourceString("stop_server"));
        exp4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IcalFileServer.stop();
                Errmsg.getErrorHandler().notice(Resource.getResourceString("server_stopped"));
            }
        });
        icsmenu.add(exp4);
        m.add(icsmenu);
        return m;
    }

    private static void runBackgroundSync(Synctype type) {
        Synctype ty = type;
        class SyncWorker
        extends SwingWorker<Void, Object> {
            final /* synthetic */ Synctype val$ty;

            SyncWorker(Synctype synctype) {
                this.val$ty = synctype;
            }

            @Override
            public Void doInBackground() {
                try {
                    IOHelper.sendMessage("lock:" + Resource.getResourceString("syncing"));
                    if (this.val$ty == Synctype.FULL) {
                        CalDav.sync((Integer)Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS), (boolean)false);
                    } else if (this.val$ty == Synctype.ONEWAY) {
                        CalDav.sync((Integer)Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS), (boolean)true);
                    } else if (this.val$ty == Synctype.OVERWRITE) {
                        CalDav.export((Integer)Prefs.getIntPref(PrefName.ICAL_EXPORTYEARS));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IOHelper.sendLogMessage(e.toString());
                }
                IOHelper.sendLogMessage(Resource.getResourceString("done"));
                return null;
            }

            @Override
            protected void done() {
                IOHelper.sendMessage("unlock");
            }
        }
        new SyncWorker(ty).execute();
    }

    @Override
    public void initialize(MultiView parent) {
        OptionsView.getReference().addPanel(new IcalOptionsPanel());
        new FileDrop(parent, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] files) {
                for (File f : files) {
                    try {
                        String warning = AppointmentIcalAdapter.importIcalFromFile((String)f.getAbsolutePath());
                        if (warning == null || warning.isEmpty()) continue;
                        Errmsg.getErrorHandler().notice(warning);
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
            }
        });
        String url = Prefs.getPref(PrefName.ICAL_IMPORT_URL);
        if (url != null && !url.isEmpty()) {
            try {
                String warning;
                int res = JOptionPane.showConfirmDialog(null, Resource.getResourceString("ImportUrl") + ": " + url + " ?", Resource.getResourceString("please_confirm"), 2);
                if (res == 0 && (warning = AppointmentIcalAdapter.importIcalFromUrl((String)url)) != null && !warning.isEmpty()) {
                    Errmsg.getErrorHandler().notice(warning);
                }
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        SyncLog.getReference();
    }

    @Override
    public void print() {
    }

    private static void export(Integer years) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Resource.getResourceString("ical_files"), "ics", "ICS", "ical", "ICAL", "icalendar");
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(Resource.getResourceString("choose_file"));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        String s = chooser.getSelectedFile().getAbsolutePath();
        if (chooser.getFileFilter() != chooser.getAcceptAllFileFilter() && !s.contains(".")) {
            s = s + ".ics";
        }
        try {
            if (years != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.add(1, -1 * years);
                AppointmentIcalAdapter.exportIcalToFile((String)s, (Date)cal.getTime());
            } else {
                AppointmentIcalAdapter.exportIcalToFile((String)s, null);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static enum Synctype {
        FULL,
        ONEWAY,
        OVERWRITE;

    }
}

