/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import edu.emory.mathcs.backport.java.util.Collections;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class AppearanceOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = -2799946173831477902L;
    private JCheckBox canadabox;
    private JCheckBox prioritySortBox;
    private JCheckBox doyBox = null;
    private JCheckBox hide_strike_box = new JCheckBox();
    private JCheckBox holiday1;
    private JCheckBox iso8601Box = new JCheckBox();
    private JComboBox<String> lnfBox;
    private JComboBox<String> themeBox;
    private JComboBox<String> localebox;
    private JCheckBox miltime;
    private JCheckBox mondaycb;
    private JCheckBox privbox = new JCheckBox();
    private JCheckBox pubbox = new JCheckBox();
    private JCheckBox truncbox = null;
    private JComboBox<String> wkendhr;
    private JComboBox<String> wkstarthr;

    public AppearanceOptionsPanel() {
        String[] themes;
        this.lnfBox = new JComboBox();
        this.themeBox = new JComboBox();
        this.holiday1 = new JCheckBox();
        this.mondaycb = new JCheckBox();
        this.miltime = new JCheckBox();
        this.wkstarthr = new JComboBox();
        this.wkendhr = new JComboBox();
        this.canadabox = new JCheckBox();
        this.localebox = new JComboBox();
        this.prioritySortBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setName(Resource.getResourceString("appearance"));
        ResourceHelper.setText(this.privbox, "Show_Private_Appointments");
        this.add((Component)this.privbox, GridBagConstraintsFactory.create(1, 2, 1));
        ResourceHelper.setText(this.pubbox, "Show_Public_Appointments");
        this.add((Component)this.pubbox, GridBagConstraintsFactory.create(0, 2, 1));
        JLabel jLabel4 = new JLabel();
        ResourceHelper.setText(jLabel4, "Look_and_Feel:");
        jLabel4.setLabelFor(this.lnfBox);
        this.add((Component)jLabel4, GridBagConstraintsFactory.create(0, 0, 1));
        this.lnfBox.setEditable(true);
        this.lnfBox.setMaximumSize(new Dimension(131, 24));
        this.lnfBox.setPreferredSize(new Dimension(50, 24));
        this.lnfBox.setAutoscrolls(true);
        this.add(this.lnfBox, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        JLabel themeLabel = new JLabel();
        ResourceHelper.setText(themeLabel, "JGoodies_Theme");
        jLabel4.setLabelFor(this.themeBox);
        this.add((Component)themeLabel, GridBagConstraintsFactory.create(0, 1, 1));
        this.themeBox.setEditable(true);
        this.themeBox.setMaximumSize(new Dimension(131, 24));
        this.themeBox.setPreferredSize(new Dimension(50, 24));
        this.themeBox.setAutoscrolls(true);
        this.add(this.themeBox, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        for (String theme : themes = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "ExperienceRoyale", "LightGray", "Silver", "SkyBlue", "SkyBluer", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"}) {
            this.themeBox.addItem(theme);
        }
        ResourceHelper.setText(this.holiday1, "Show_U.S._Holidays");
        this.add((Component)this.holiday1, GridBagConstraintsFactory.create(0, 4, 1));
        ResourceHelper.setText(this.mondaycb, "Week_Starts_with_Monday");
        this.add((Component)this.mondaycb, GridBagConstraintsFactory.create(1, 5, 1));
        ResourceHelper.setText(this.miltime, "Use_24_hour_time_format");
        this.add((Component)this.miltime, GridBagConstraintsFactory.create(0, 5, 1));
        JLabel jLabel5 = new JLabel();
        ResourceHelper.setText(jLabel5, "Week_View_Start_Hour:_");
        jLabel5.setLabelFor(this.wkstarthr);
        this.wkstarthr.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"}));
        this.add((Component)jLabel5, GridBagConstraintsFactory.create(0, 7, 1));
        this.wkendhr.setModel(new DefaultComboBoxModel<String>(new String[]{"12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}));
        this.add(this.wkstarthr, GridBagConstraintsFactory.create(1, 7, 1));
        JLabel jLabel6 = new JLabel();
        ResourceHelper.setText(jLabel6, "Week_View_End_Hour:_");
        jLabel6.setLabelFor(this.wkendhr);
        this.add(this.wkendhr, GridBagConstraintsFactory.create(1, 8, 1));
        this.add((Component)jLabel6, GridBagConstraintsFactory.create(0, 8, 1));
        ResourceHelper.setText(this.canadabox, "Show_Canadian_Holidays");
        this.add((Component)this.canadabox, GridBagConstraintsFactory.create(1, 4, 1));
        JLabel jLabel8 = new JLabel();
        ResourceHelper.setText(jLabel8, "locale");
        jLabel8.setLabelFor(this.localebox);
        this.add((Component)jLabel8, GridBagConstraintsFactory.create(0, 12, 1));
        this.add(this.localebox, GridBagConstraintsFactory.create(1, 12, 1));
        this.hide_strike_box.setText(Resource.getResourceString("hide_strike"));
        this.add((Component)this.hide_strike_box, GridBagConstraintsFactory.create(0, 3, 1));
        ResourceHelper.setText(this.iso8601Box, "ISO_week_number");
        this.add((Component)this.iso8601Box, GridBagConstraintsFactory.create(0, 9, 1, 0.0, 0.0));
        ResourceHelper.setText(this.prioritySortBox, "sort_by_priority");
        this.add((Component)this.prioritySortBox, GridBagConstraintsFactory.create(0, 6, 1));
        this.doyBox = new JCheckBox();
        ResourceHelper.setText(this.doyBox, "showdoy");
        this.add((Component)this.doyBox, GridBagConstraintsFactory.create(1, 6, 1));
        this.truncbox = new JCheckBox();
        ResourceHelper.setText(this.truncbox, "truncate_appts");
        this.add((Component)this.truncbox, GridBagConstraintsFactory.create(1, 3, 1));
        this.lnfBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppearanceOptionsPanel.this.lnfChanged();
            }
        });
    }

    @Override
    public void applyChanges() {
        String oldtheme;
        String newtheme;
        String oldlnf;
        OptionsView.OptionsPanel.setBooleanPref(this.pubbox, PrefName.SHOWPUBLIC);
        OptionsView.OptionsPanel.setBooleanPref(this.privbox, PrefName.SHOWPRIVATE);
        OptionsView.OptionsPanel.setBooleanPref(this.holiday1, PrefName.SHOWUSHOLIDAYS);
        OptionsView.OptionsPanel.setBooleanPref(this.canadabox, PrefName.SHOWCANHOLIDAYS);
        OptionsView.OptionsPanel.setBooleanPref(this.doyBox, PrefName.DAYOFYEAR);
        OptionsView.OptionsPanel.setBooleanPref(this.prioritySortBox, PrefName.PRIORITY_SORT);
        OptionsView.OptionsPanel.setBooleanPref(this.miltime, PrefName.MILTIME);
        OptionsView.OptionsPanel.setBooleanPref(this.truncbox, PrefName.TRUNCAPPT);
        OptionsView.OptionsPanel.setBooleanPref(this.iso8601Box, PrefName.ISOWKNUMBER);
        OptionsView.OptionsPanel.setBooleanPref(this.hide_strike_box, PrefName.HIDESTRIKETHROUGH);
        if (this.mondaycb.isSelected()) {
            Prefs.putPref(PrefName.FIRSTDOW, new Integer(2));
        } else {
            Prefs.putPref(PrefName.FIRSTDOW, new Integer(1));
        }
        Prefs.putPref(PrefName.WKENDHOUR, this.wkendhr.getSelectedItem());
        Prefs.putPref(PrefName.WKSTARTHOUR, this.wkstarthr.getSelectedItem());
        Locale[] locs = Locale.getAvailableLocales();
        String choice = (String)this.localebox.getSelectedItem();
        for (int ii = 0; ii < locs.length; ++ii) {
            if (!choice.equals(locs[ii].getDisplayName())) continue;
            Prefs.putPref(PrefName.COUNTRY, locs[ii].getCountry());
            Prefs.putPref(PrefName.LANGUAGE, locs[ii].getLanguage());
        }
        boolean lnfChange = false;
        String newlnf = (String)this.lnfBox.getSelectedItem();
        if (!newlnf.equals(oldlnf = Prefs.getPref(PrefName.LNF))) {
            lnfChange = true;
            Prefs.putPref(PrefName.LNF, newlnf);
        }
        if (!(newtheme = (String)this.themeBox.getSelectedItem()).equals(oldtheme = Prefs.getPref(PrefName.GOODIESTHEME))) {
            lnfChange = true;
            Prefs.putPref(PrefName.GOODIESTHEME, newtheme);
        }
        if (lnfChange) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("lfrestart"));
        }
    }

    @Override
    public void loadOptions() {
        String[] looks;
        OptionsView.OptionsPanel.setCheckBox(this.pubbox, PrefName.SHOWPUBLIC);
        OptionsView.OptionsPanel.setCheckBox(this.privbox, PrefName.SHOWPRIVATE);
        OptionsView.OptionsPanel.setCheckBox(this.holiday1, PrefName.SHOWUSHOLIDAYS);
        OptionsView.OptionsPanel.setCheckBox(this.canadabox, PrefName.SHOWCANHOLIDAYS);
        OptionsView.OptionsPanel.setCheckBox(this.doyBox, PrefName.DAYOFYEAR);
        OptionsView.OptionsPanel.setCheckBox(this.prioritySortBox, PrefName.PRIORITY_SORT);
        OptionsView.OptionsPanel.setCheckBox(this.miltime, PrefName.MILTIME);
        OptionsView.OptionsPanel.setCheckBox(this.truncbox, PrefName.TRUNCAPPT);
        OptionsView.OptionsPanel.setCheckBox(this.iso8601Box, PrefName.ISOWKNUMBER);
        OptionsView.OptionsPanel.setCheckBox(this.hide_strike_box, PrefName.HIDESTRIKETHROUGH);
        int fdow = Prefs.getIntPref(PrefName.FIRSTDOW);
        if (fdow == 2) {
            this.mondaycb.setSelected(true);
        } else {
            this.mondaycb.setSelected(false);
        }
        String shr = Prefs.getPref(PrefName.WKSTARTHOUR);
        String ehr = Prefs.getPref(PrefName.WKENDHOUR);
        this.wkstarthr.setSelectedItem(shr);
        this.wkendhr.setSelectedItem(ehr);
        this.localebox.removeAllItems();
        Object[] locs = Locale.getAvailableLocales();
        ArrayList loclist = new ArrayList();
        Collections.addAll(loclist, (Object[])locs);
        Comparator<Locale> comparator = new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        };
        Collections.sort(loclist, (Comparator)comparator);
        for (Locale locale : loclist) {
            this.localebox.addItem(locale.getDisplayName());
        }
        String currentlocale = Locale.getDefault().getDisplayName();
        this.localebox.setSelectedItem(currentlocale);
        this.lnfBox.removeAllItems();
        TreeSet<String> lnfs = new TreeSet<String>();
        String curlnf = Prefs.getPref(PrefName.LNF);
        UIManager.LookAndFeelInfo[] lnfinfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lnfinfo.length; ++i) {
            String name = lnfinfo[i].getClassName();
            lnfs.add(name);
        }
        for (String look : looks = new String[]{"com.jgoodies.looks.plastic.PlasticLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "com.incors.plaf.kunststoff.KunststoffLookAndFeel", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel", "net.infonode.gui.laf.InfoNodeLookAndFeel", "com.lipstikLF.LipstikLookAndFeel", "org.fife.plaf.Office2003.Office2003LookAndFeel"}) {
            try {
                Class.forName(look);
                lnfs.add(look);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        lnfs.add(curlnf);
        for (String lnf : lnfs) {
            this.lnfBox.addItem(lnf);
        }
        this.lnfBox.setSelectedItem(curlnf);
        this.lnfBox.setEditable(true);
        String curtheme = Prefs.getPref(PrefName.GOODIESTHEME);
        this.themeBox.setSelectedItem(curtheme);
        this.themeBox.setEditable(false);
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("appearance");
    }

    private void lnfChanged() {
        String lnf = (String)this.lnfBox.getSelectedItem();
        if (lnf == null) {
            return;
        }
        if (lnf.contains("goodies")) {
            this.themeBox.setEnabled(true);
        } else {
            this.themeBox.setEnabled(false);
        }
    }
}

