/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.Theme;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.ColorChooserButton;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class ColorOptionsPanel
extends OptionsView.OptionsPanel
implements Prefs.Listener {
    private static final long serialVersionUID = 2184312216077136324L;
    private ColorChooserButton btn_ucs_birthdays;
    private ColorChooserButton btn_ucs_black;
    private ColorChooserButton btn_ucs_blue;
    private ColorChooserButton btn_ucs_defaultBg;
    private ColorChooserButton btn_ucs_defaultFg;
    private ColorChooserButton btn_ucs_green;
    private ColorChooserButton btn_ucs_halfday;
    private ColorChooserButton btn_ucs_holiday;
    private ColorChooserButton btn_ucs_holidays;
    private ColorChooserButton btn_ucs_red;
    private ColorChooserButton btn_ucs_reminderBg;
    private ColorChooserButton btn_ucs_stripe;
    private ColorChooserButton btn_ucs_tasks;
    private ColorChooserButton btn_ucs_today;
    private ColorChooserButton btn_ucs_vacation;
    private ColorChooserButton btn_ucs_weekday;
    private ColorChooserButton btn_ucs_weekend;
    private ColorChooserButton btn_ucs_white;
    private ColorChooserButton btn_tray_fg;
    private ColorChooserButton btn_tray_bg;
    private JCheckBox cb_ucs_marktodo;
    private JCheckBox cb_ucs_ontodo;
    private JCheckBox gradientApptBox = new JCheckBox();
    private JTextField tf_ucs_marker;
    private JComboBox<String> themeChooser = new JComboBox();

    public ColorOptionsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel themePanel = new JPanel();
        themePanel.setLayout(new GridBagLayout());
        themePanel.add((Component)new JLabel(Resource.getResourceString("Theme") + ":"), GridBagConstraintsFactory.create(0, 0));
        this.themeChooser.setEditable(false);
        themePanel.add(this.themeChooser, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        this.themeChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = (String)ColorOptionsPanel.this.themeChooser.getSelectedItem();
                if (name == null) {
                    return;
                }
                Theme t = Theme.getTheme((String)name);
                ColorOptionsPanel.this.showTheme(t);
            }
        });
        JButton saveButton = new JButton();
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = JOptionPane.showInputDialog(Resource.getResourceString("New_Theme_Name"));
                if (name == null) {
                    return;
                }
                Theme newTheme = new Theme();
                ColorOptionsPanel.this.setTheme(newTheme);
                newTheme.setName(name);
                try {
                    newTheme.save();
                    ColorOptionsPanel.this.themeChooser.addItem(name);
                    ColorOptionsPanel.this.themeChooser.setSelectedItem(name);
                }
                catch (Warning e1) {
                    Errmsg.getErrorHandler().notice(e1.getLocalizedMessage());
                    return;
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                    return;
                }
            }
        });
        themePanel.add((Component)saveButton, GridBagConstraintsFactory.create(2, 0));
        JButton delButton = new JButton();
        delButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Theme.delete((String)((String)ColorOptionsPanel.this.themeChooser.getSelectedItem()));
                    ColorOptionsPanel.this.loadThemes();
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                    return;
                }
            }
        });
        themePanel.add((Component)delButton, GridBagConstraintsFactory.create(3, 0));
        this.add((Component)themePanel, GridBagConstraintsFactory.create(0, 0, 1));
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(12, 2));
        this.cb_ucs_ontodo = new JCheckBox();
        ResourceHelper.setText(this.cb_ucs_ontodo, "ucolortext1");
        this.cb_ucs_marktodo = new JCheckBox();
        ResourceHelper.setText(this.cb_ucs_marktodo, "ucolortext2");
        this.tf_ucs_marker = new JTextField("! ");
        this.btn_ucs_red = new ColorChooserButton(Resource.getResourceString("ucolortext4"), Color.WHITE);
        this.btn_ucs_blue = new ColorChooserButton(Resource.getResourceString("ucolortext5"), Color.WHITE);
        this.btn_ucs_green = new ColorChooserButton(Resource.getResourceString("ucolortext6"), Color.WHITE);
        this.btn_ucs_black = new ColorChooserButton(Resource.getResourceString("ucolortext7"), Color.WHITE);
        this.btn_ucs_white = new ColorChooserButton(Resource.getResourceString("ucolortext8"), Color.WHITE);
        this.btn_ucs_tasks = new ColorChooserButton(Resource.getResourceString("ucolortext9"), Color.WHITE);
        this.btn_ucs_holidays = new ColorChooserButton(Resource.getResourceString("ucolortext10"), Color.WHITE);
        this.btn_ucs_birthdays = new ColorChooserButton(Resource.getResourceString("ucolortext11"), Color.WHITE);
        this.btn_ucs_defaultBg = new ColorChooserButton(Resource.getResourceString("ucolortext12"), Color.WHITE);
        this.btn_ucs_defaultFg = new ColorChooserButton(Resource.getResourceString("defaultfg"), Color.WHITE);
        this.btn_ucs_holiday = new ColorChooserButton(Resource.getResourceString("ucolortext13"), Color.WHITE);
        this.btn_ucs_halfday = new ColorChooserButton(Resource.getResourceString("ucolortext14"), Color.WHITE);
        this.btn_ucs_vacation = new ColorChooserButton(Resource.getResourceString("ucolortext15"), Color.WHITE);
        this.btn_ucs_today = new ColorChooserButton(Resource.getResourceString("ucolortext16"), Color.WHITE);
        this.btn_ucs_weekend = new ColorChooserButton(Resource.getResourceString("ucolortext17"), Color.WHITE);
        this.btn_ucs_weekday = new ColorChooserButton(Resource.getResourceString("ucolortext18"), Color.WHITE);
        this.btn_ucs_stripe = new ColorChooserButton(Resource.getResourceString("stripecolor"), Color.WHITE);
        this.btn_tray_fg = new ColorChooserButton(Resource.getResourceString("tray_fg"), Color.WHITE);
        this.btn_tray_bg = new ColorChooserButton(Resource.getResourceString("tray_bg"), Color.WHITE);
        this.btn_ucs_reminderBg = new ColorChooserButton(Resource.getResourceString("reminder_bg"), Color.WHITE);
        JButton btn_ucs_restore = new JButton(Resource.getResourceString("restore_defaults"));
        btn_ucs_restore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Theme t = new Theme();
                ColorOptionsPanel.this.btn_ucs_red.setColorProperty(new Color(t.getTextColor1()));
                ColorOptionsPanel.this.btn_ucs_blue.setColorProperty(new Color(t.getTextColor2()));
                ColorOptionsPanel.this.btn_ucs_green.setColorProperty(new Color(t.getTextColor3()));
                ColorOptionsPanel.this.btn_ucs_black.setColorProperty(new Color(t.getTextColor4()));
                ColorOptionsPanel.this.btn_ucs_white.setColorProperty(new Color(t.getTextColor5()));
                ColorOptionsPanel.this.btn_ucs_tasks.setColorProperty(new Color(t.getTaskTextColor()));
                ColorOptionsPanel.this.btn_ucs_holidays.setColorProperty(new Color(t.getHolidayTextColor()));
                ColorOptionsPanel.this.btn_ucs_birthdays.setColorProperty(new Color(t.getBirthdayTextColor()));
                ColorOptionsPanel.this.btn_ucs_defaultBg.setColorProperty(new Color(t.getDefaultBg()));
                ColorOptionsPanel.this.btn_ucs_defaultFg.setColorProperty(new Color(t.getDefaultFg()));
                ColorOptionsPanel.this.btn_ucs_today.setColorProperty(new Color(t.getTodayBg()));
                ColorOptionsPanel.this.btn_ucs_holiday.setColorProperty(new Color(t.getHolidayBg()));
                ColorOptionsPanel.this.btn_ucs_vacation.setColorProperty(new Color(t.getVacationBg()));
                ColorOptionsPanel.this.btn_ucs_halfday.setColorProperty(new Color(t.getHalfdayBg()));
                ColorOptionsPanel.this.btn_ucs_weekend.setColorProperty(new Color(t.getWeekendBg()));
                ColorOptionsPanel.this.btn_ucs_weekday.setColorProperty(new Color(t.getWeekdayBg()));
                ColorOptionsPanel.this.btn_tray_fg.setColorProperty(new Color(t.getTrayIconFg()));
                ColorOptionsPanel.this.btn_tray_bg.setColorProperty(new Color(t.getTrayIconBg()));
                ColorOptionsPanel.this.btn_ucs_reminderBg.setColorProperty(new Color(t.getReminderBg()));
            }
        });
        colorPanel.add(this.btn_ucs_red);
        colorPanel.add(this.btn_ucs_defaultBg);
        colorPanel.add(this.btn_ucs_defaultFg);
        colorPanel.add(this.btn_ucs_blue);
        colorPanel.add(this.btn_ucs_today);
        colorPanel.add(this.btn_ucs_green);
        colorPanel.add(this.btn_ucs_holiday);
        colorPanel.add(this.btn_ucs_black);
        colorPanel.add(this.btn_ucs_halfday);
        colorPanel.add(this.btn_ucs_white);
        colorPanel.add(this.btn_ucs_vacation);
        colorPanel.add(this.btn_ucs_tasks);
        colorPanel.add(this.btn_ucs_weekend);
        colorPanel.add(this.btn_ucs_holidays);
        colorPanel.add(this.btn_ucs_weekday);
        colorPanel.add(this.btn_ucs_birthdays);
        colorPanel.add(this.btn_ucs_stripe);
        colorPanel.add(this.btn_tray_fg);
        colorPanel.add(this.btn_tray_bg);
        colorPanel.add(this.btn_ucs_reminderBg);
        colorPanel.add(btn_ucs_restore);
        colorPanel.add(this.cb_ucs_ontodo);
        JPanel njp = new JPanel();
        njp.setLayout(new BorderLayout());
        njp.add((Component)this.cb_ucs_marktodo, "West");
        njp.add((Component)this.tf_ucs_marker, "Center");
        colorPanel.add(njp);
        this.gradientApptBox.setText(Resource.getResourceString("gradient_appts"));
        colorPanel.add(this.gradientApptBox);
        this.add((Component)colorPanel, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
        this.loadThemes();
    }

    @Override
    public void applyChanges() {
        OptionsView.OptionsPanel.setBooleanPref(this.gradientApptBox, PrefName.GRADIENT_APPTS);
        OptionsView.OptionsPanel.setBooleanPref(this.cb_ucs_ontodo, PrefName.UCS_ONTODO);
        OptionsView.OptionsPanel.setBooleanPref(this.cb_ucs_marktodo, PrefName.UCS_MARKTODO);
        Prefs.putPref(PrefName.UCS_MARKER, this.tf_ucs_marker.getText());
        Theme t = new Theme();
        this.setTheme(t);
        try {
            t.save();
            Theme.setCurrentTheme((Theme)t);
            this.loadThemes();
        }
        catch (Warning e1) {
            Errmsg.getErrorHandler().notice(e1.getLocalizedMessage());
            return;
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
            return;
        }
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("UserColorScheme");
    }

    @Override
    public void loadOptions() {
        this.loadThemes();
        OptionsView.OptionsPanel.setCheckBox(this.gradientApptBox, PrefName.GRADIENT_APPTS);
        OptionsView.OptionsPanel.setCheckBox(this.cb_ucs_ontodo, PrefName.UCS_ONTODO);
        OptionsView.OptionsPanel.setCheckBox(this.cb_ucs_marktodo, PrefName.UCS_MARKTODO);
        this.tf_ucs_marker.setText(Prefs.getPref(PrefName.UCS_MARKER));
    }

    private void loadThemes() {
        this.themeChooser.removeAllItems();
        Collection themeNames = Theme.getThemeNames();
        for (String name : themeNames) {
            this.themeChooser.addItem(name);
        }
        Theme t = Theme.getCurrentTheme();
        this.themeChooser.setSelectedItem(t.getName());
        this.showTheme(t);
    }

    private void setTheme(Theme t) {
        t.setName((String)this.themeChooser.getSelectedItem());
        t.setTextColor1(this.btn_ucs_red.getColorProperty().getRGB());
        t.setTextColor2(this.btn_ucs_blue.getColorProperty().getRGB());
        t.setTextColor3(this.btn_ucs_green.getColorProperty().getRGB());
        t.setTextColor4(this.btn_ucs_black.getColorProperty().getRGB());
        t.setTextColor5(this.btn_ucs_white.getColorProperty().getRGB());
        t.setTaskTextColor(this.btn_ucs_tasks.getColorProperty().getRGB());
        t.setHolidayTextColor(this.btn_ucs_holidays.getColorProperty().getRGB());
        t.setBirthdayTextColor(this.btn_ucs_birthdays.getColorProperty().getRGB());
        t.setDefaultBg(this.btn_ucs_defaultBg.getColorProperty().getRGB());
        t.setDefaultFg(this.btn_ucs_defaultFg.getColorProperty().getRGB());
        t.setHolidayBg(this.btn_ucs_holiday.getColorProperty().getRGB());
        t.setHalfdayBg(this.btn_ucs_halfday.getColorProperty().getRGB());
        t.setVacationBg(this.btn_ucs_vacation.getColorProperty().getRGB());
        t.setTodayBg(this.btn_ucs_today.getColorProperty().getRGB());
        t.setWeekendBg(this.btn_ucs_weekend.getColorProperty().getRGB());
        t.setWeekdayBg(this.btn_ucs_weekday.getColorProperty().getRGB());
        t.setStripeBg(this.btn_ucs_stripe.getColorProperty().getRGB());
        t.setTrayIconFg(this.btn_tray_fg.getColorProperty().getRGB());
        t.setTrayIconBg(this.btn_tray_bg.getColorProperty().getRGB());
        t.setReminderBg(this.btn_ucs_reminderBg.getColorProperty().getRGB());
    }

    private void showTheme(Theme t) {
        this.btn_ucs_red.setColorProperty(new Color(t.getTextColor1()));
        this.btn_ucs_blue.setColorProperty(new Color(t.getTextColor2()));
        this.btn_ucs_green.setColorProperty(new Color(t.getTextColor3()));
        this.btn_ucs_black.setColorProperty(new Color(t.getTextColor4()));
        this.btn_ucs_white.setColorProperty(new Color(t.getTextColor5()));
        this.btn_ucs_tasks.setColorProperty(new Color(t.getTaskTextColor()));
        this.btn_ucs_holidays.setColorProperty(new Color(t.getHolidayTextColor()));
        this.btn_ucs_birthdays.setColorProperty(new Color(t.getBirthdayTextColor()));
        this.btn_ucs_defaultBg.setColorProperty(new Color(t.getDefaultBg()));
        this.btn_ucs_defaultFg.setColorProperty(new Color(t.getDefaultFg()));
        this.btn_ucs_today.setColorProperty(new Color(t.getTodayBg()));
        this.btn_ucs_holiday.setColorProperty(new Color(t.getHolidayBg()));
        this.btn_ucs_halfday.setColorProperty(new Color(t.getHalfdayBg()));
        this.btn_ucs_vacation.setColorProperty(new Color(t.getVacationBg()));
        this.btn_ucs_weekend.setColorProperty(new Color(t.getWeekendBg()));
        this.btn_ucs_weekday.setColorProperty(new Color(t.getWeekdayBg()));
        this.btn_ucs_stripe.setColorProperty(new Color(t.getStripeBg()));
        this.btn_tray_fg.setColorProperty(new Color(t.getTrayIconFg()));
        this.btn_tray_bg.setColorProperty(new Color(t.getTrayIconBg()));
        this.btn_ucs_reminderBg.setColorProperty(new Color(t.getReminderBg()));
    }

    @Override
    public void prefsChanged() {
        this.loadThemes();
    }
}

