/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sf.borg.common.EncryptionHelper;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class EncryptionOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = 3485306815964774388L;
    private JTextField keyStoreText = new JTextField();
    private JSpinner passwordTimeSpinner = null;

    public EncryptionOptionsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel ksPanel = new JPanel();
        ksPanel.setLayout(new GridBagLayout());
        ksPanel.add((Component)new JLabel(Resource.getResourceString("KeyStore") + ": "), GridBagConstraintsFactory.create(0, 0, 0));
        this.keyStoreText.setEditable(false);
        ksPanel.add((Component)this.keyStoreText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        JButton bb = new JButton();
        ResourceHelper.setText(bb, "Browse");
        bb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                chooser.setDialogTitle(Resource.getResourceString("SelectKeyStore"));
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                if (!file.canRead()) {
                    JTextArea ta = new JTextArea();
                    ta.setText(Resource.getResourceString("create_key_store"));
                    ta.setEditable(false);
                    ta.setRows(2);
                    JPasswordField jpf = new JPasswordField();
                    JPasswordField jpf2 = new JPasswordField();
                    int result = JOptionPane.showConfirmDialog(null, new Object[]{ta, jpf, jpf2}, Resource.getResourceString("Password"), 2);
                    if (result == 2) {
                        return;
                    }
                    if (!new String(jpf.getPassword()).equals(new String(jpf2.getPassword()))) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("PasswordsDoNotMatch"));
                        return;
                    }
                    if (new String(jpf.getPassword()).trim().isEmpty()) {
                        Errmsg.getErrorHandler().notice(Resource.getResourceString("PasswordWhitespace"));
                        return;
                    }
                    try {
                        EncryptionHelper.createStore(file.getAbsolutePath(), new String(jpf.getPassword()));
                        EncryptionHelper.generateKey(file.getAbsolutePath(), new String(jpf.getPassword()), Prefs.getPref(PrefName.KEYALIAS));
                    }
                    catch (Exception e) {
                        Errmsg.getErrorHandler().errmsg(e);
                    }
                }
                EncryptionOptionsPanel.this.keyStoreText.setText(file.getAbsolutePath());
            }
        });
        ksPanel.add((Component)bb, GridBagConstraintsFactory.create(2, 0, 0));
        GridBagConstraints gbc1 = GridBagConstraintsFactory.create(0, 0, 1, 1.0, 0.0);
        gbc1.gridwidth = 2;
        this.add((Component)ksPanel, gbc1);
        this.add((Component)new JLabel(Resource.getResourceString("pw_time")), GridBagConstraintsFactory.create(0, 1, 1));
        this.passwordTimeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 31536000, 1));
        this.add((Component)this.passwordTimeSpinner, GridBagConstraintsFactory.create(1, 1, 1));
    }

    @Override
    public void applyChanges() {
        Prefs.putPref(PrefName.KEYSTORE, this.keyStoreText.getText());
        Prefs.putPref(PrefName.PASSWORD_TTL, this.passwordTimeSpinner.getValue());
    }

    @Override
    public void loadOptions() {
        this.keyStoreText.setText(Prefs.getPref(PrefName.KEYSTORE));
        this.passwordTimeSpinner.setValue(new Integer(Prefs.getIntPref(PrefName.PASSWORD_TTL)));
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("Encryption");
    }
}

