/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.NwFontChooserS;

public class FontOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = -6568983838009839140L;
    JTextField monthFontText = new JTextField();
    JTextField dayFontText = new JTextField();
    JTextField weekFontText = new JTextField();
    JTextField yearFontText = new JTextField();
    JTextField printFontText = new JTextField();
    JTextField defaultFontText = new JTextField();
    JTextField trayFontText = new JTextField();

    public FontOptionsPanel() {
        this.monthFontText.setEditable(false);
        this.dayFontText.setEditable(false);
        this.weekFontText.setEditable(false);
        this.yearFontText.setEditable(false);
        this.printFontText.setEditable(false);
        this.defaultFontText.setEditable(false);
        this.trayFontText.setEditable(false);
        this.setLayout(new GridBagLayout());
        JButton defFontButton = new JButton();
        ResourceHelper.setText(defFontButton, "set_def_font");
        defFontButton.setBorder(new SoftBevelBorder(0));
        defFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.defaultFontText);
            }
        });
        JButton apptFontButton = new JButton();
        ResourceHelper.setText(apptFontButton, "set_appt_font");
        apptFontButton.setBorder(new SoftBevelBorder(0));
        apptFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.monthFontText);
            }
        });
        JButton dayFontButton = new JButton();
        ResourceHelper.setText(dayFontButton, "dview_font");
        dayFontButton.setBorder(new SoftBevelBorder(0));
        dayFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.dayFontText);
            }
        });
        JButton weekFontButton = new JButton();
        ResourceHelper.setText(weekFontButton, "wview_font");
        weekFontButton.setBorder(new SoftBevelBorder(0));
        weekFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.weekFontText);
            }
        });
        JButton printFontButton = new JButton();
        ResourceHelper.setText(printFontButton, "mview_font");
        printFontButton.setBorder(new SoftBevelBorder(0));
        printFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.printFontText);
            }
        });
        JButton yearFontButton = new JButton();
        ResourceHelper.setText(yearFontButton, "yview_font");
        yearFontButton.setBorder(new SoftBevelBorder(0));
        yearFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.yearFontText);
            }
        });
        JButton trayFontButton = new JButton();
        ResourceHelper.setText(trayFontButton, "tray_font");
        trayFontButton.setBorder(new SoftBevelBorder(0));
        trayFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontOptionsPanel.fontActionPerformed(FontOptionsPanel.this.trayFontText);
            }
        });
        this.add((Component)defFontButton, GridBagConstraintsFactory.create(0, 0, 1));
        this.add((Component)apptFontButton, GridBagConstraintsFactory.create(0, 1, 1));
        this.add((Component)dayFontButton, GridBagConstraintsFactory.create(0, 2, 1));
        this.add((Component)weekFontButton, GridBagConstraintsFactory.create(0, 3, 1));
        this.add((Component)yearFontButton, GridBagConstraintsFactory.create(0, 4, 1));
        this.add((Component)printFontButton, GridBagConstraintsFactory.create(0, 5, 1));
        this.add((Component)trayFontButton, GridBagConstraintsFactory.create(0, 6, 1));
        this.add((Component)this.defaultFontText, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        this.add((Component)this.monthFontText, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        this.add((Component)this.weekFontText, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        this.add((Component)this.dayFontText, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        this.add((Component)this.yearFontText, GridBagConstraintsFactory.create(1, 4, 1, 1.0, 0.0));
        this.add((Component)this.printFontText, GridBagConstraintsFactory.create(1, 5, 1, 1.0, 0.0));
        this.add((Component)this.trayFontText, GridBagConstraintsFactory.create(1, 6, 1, 1.0, 0.0));
    }

    @Override
    public void applyChanges() {
        String origDefaultFont = Prefs.getPref(PrefName.DEFFONT);
        Prefs.putPref(PrefName.APPTFONT, this.monthFontText.getText());
        Prefs.putPref(PrefName.DEFFONT, this.defaultFontText.getText());
        Prefs.putPref(PrefName.WEEKVIEWFONT, this.weekFontText.getText());
        Prefs.putPref(PrefName.YEARVIEWFONT, this.yearFontText.getText());
        Prefs.putPref(PrefName.DAYVIEWFONT, this.dayFontText.getText());
        Prefs.putPref(PrefName.PRINTFONT, this.printFontText.getText());
        Prefs.putPref(PrefName.TRAYFONT, this.trayFontText.getText());
        if (!origDefaultFont.equals(this.defaultFontText.getText())) {
            Font f = Font.decode(this.defaultFontText.getText());
            NwFontChooserS.setDefaultFont(f);
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    private static void fontActionPerformed(JTextField fontText) {
        Font pf = Font.decode(fontText.getText());
        Font f = NwFontChooserS.showDialog(null, null, pf);
        if (f == null) {
            return;
        }
        String s = NwFontChooserS.fontString(f);
        fontText.setText(s);
    }

    @Override
    public void loadOptions() {
        this.monthFontText.setText(Prefs.getPref(PrefName.APPTFONT));
        this.defaultFontText.setText(Prefs.getPref(PrefName.DEFFONT));
        this.weekFontText.setText(Prefs.getPref(PrefName.WEEKVIEWFONT));
        this.yearFontText.setText(Prefs.getPref(PrefName.YEARVIEWFONT));
        this.dayFontText.setText(Prefs.getPref(PrefName.DAYVIEWFONT));
        this.printFontText.setText(Prefs.getPref(PrefName.PRINTFONT));
        this.trayFontText.setText(Prefs.getPref(PrefName.TRAYFONT));
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("fonts");
    }
}

