/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class PopupOptionsView
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JCheckBox[] reminderTimeCheckBoxes;
    private PopupOptionsListener popupOptionsListener;
    private char[] reminderTimesOnOffArray;

    public PopupOptionsView(String remtimes, String appointmentName, PopupOptionsListener popupOptionsListener) {
        this.popupOptionsListener = popupOptionsListener;
        this.reminderTimesOnOffArray = remtimes.toCharArray();
        this.initialize(appointmentName);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                PopupOptionsView.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.setTitle("Popup_Times");
        this.pack();
        this.setModal(true);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton saveButton = new JButton();
        ResourceHelper.setText(saveButton, "Save");
        saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                    ((PopupOptionsView)PopupOptionsView.this).reminderTimesOnOffArray[i] = PopupOptionsView.this.reminderTimeCheckBoxes[i].isSelected() ? 89 : 78;
                }
                PopupOptionsView.this.popupOptionsListener.setPopupTimesString(new String(PopupOptionsView.this.reminderTimesOnOffArray));
                PopupOptionsView.this.dispose();
            }
        });
        buttonPanel.add((Component)saveButton, null);
        JButton clearAllButton = new JButton();
        ResourceHelper.setText(clearAllButton, "clear_all");
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                    PopupOptionsView.this.reminderTimeCheckBoxes[i].setSelected(false);
                }
            }
        });
        buttonPanel.add((Component)clearAllButton, null);
        JButton selectAllButton = new JButton();
        ResourceHelper.setText(selectAllButton, "select_all");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                    PopupOptionsView.this.reminderTimeCheckBoxes[i].setSelected(true);
                }
            }
        });
        buttonPanel.add((Component)selectAllButton, null);
        JButton dismissButton = new JButton();
        ResourceHelper.setText(dismissButton, "Dismiss");
        dismissButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Stop16.gif")));
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupOptionsView.this.dispose();
            }
        });
        buttonPanel.add((Component)dismissButton, null);
        return buttonPanel;
    }

    private void initialize(String appointmentName) {
        int i;
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new GridBagLayout());
        JLabel jAlarmLabel = new JLabel();
        ResourceHelper.setText(jAlarmLabel, "custom_times_header");
        jAlarmLabel.setText(jAlarmLabel.getText() + " '" + appointmentName + "'");
        checkBoxPanel.add((Component)jAlarmLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.reminderTimeCheckBoxes = new JCheckBox[ReminderTimes.getNum()];
        for (int i2 = 0; i2 < ReminderTimes.getNum(); ++i2) {
            this.reminderTimeCheckBoxes[i2] = new JCheckBox(PopupOptionsView.minutes_string(i2));
        }
        int boxesPerColumn = this.reminderTimeCheckBoxes.length / 2;
        for (i = 0; i < boxesPerColumn; ++i) {
            checkBoxPanel.add((Component)this.reminderTimeCheckBoxes[i], new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 4, 4, 4), 0, 0));
            if (this.reminderTimesOnOffArray[i] == 'Y') {
                this.reminderTimeCheckBoxes[i].setSelected(true);
                continue;
            }
            this.reminderTimeCheckBoxes[i].setSelected(false);
        }
        for (i = boxesPerColumn; i < this.reminderTimeCheckBoxes.length; ++i) {
            checkBoxPanel.add((Component)this.reminderTimeCheckBoxes[i], new GridBagConstraints(1, i - boxesPerColumn + 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 4, 4, 4), 0, 0));
            if (this.reminderTimesOnOffArray[i] == 'Y') {
                this.reminderTimeCheckBoxes[i].setSelected(true);
                continue;
            }
            this.reminderTimeCheckBoxes[i].setSelected(false);
        }
        topPanel.add((Component)checkBoxPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        topPanel.add((Component)this.createButtonPanel(), GridBagConstraintsFactory.create(0, 1, 1, 0.0, 1.0));
        this.setContentPane(topPanel);
    }

    private static String minutes_string(int i) {
        int reminderTimeMinutes = ReminderTimes.getTimes((int)i);
        int reminderTimeMinutesAbsoluteValue = reminderTimeMinutes >= 0 ? reminderTimeMinutes : -reminderTimeMinutes;
        int reminderTimeHours = reminderTimeMinutesAbsoluteValue / 60;
        int reminderTimeMinutesPastTheHour = reminderTimeMinutesAbsoluteValue % 60;
        String hoursString = reminderTimeHours > 1 ? reminderTimeHours + " " + Resource.getResourceString("Hours") : (reminderTimeHours > 0 ? reminderTimeHours + " " + Resource.getResourceString("Hour") : "");
        String minutesString = reminderTimeMinutesPastTheHour > 1 ? reminderTimeMinutesPastTheHour + " " + Resource.getResourceString("Minutes") : (reminderTimeMinutesPastTheHour > 0 ? reminderTimeMinutesPastTheHour + " " + Resource.getResourceString("Minute") : (reminderTimeHours >= 1 ? "" : reminderTimeMinutesPastTheHour + " " + Resource.getResourceString("Minutes")));
        if (!hoursString.equals("") && !minutesString.equals("")) {
            minutesString = " " + minutesString;
        }
        String beforeOrAfterString = reminderTimeMinutes > 0 ? " " + Resource.getResourceString("Before") : (reminderTimeMinutes == 0 ? "" : " " + Resource.getResourceString("After"));
        return hoursString + minutesString + beforeOrAfterString;
    }

    public static interface PopupOptionsListener {
        public void setPopupTimesString(String var1);
    }
}

