/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Date;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Project;
import net.sf.borg.ui.popup.ReminderInstance;

public class ProjectReminderInstance
extends ReminderInstance {
    private Project project;

    @Override
    public void do_todo(boolean delete) {
        try {
            TaskModel.getReference().closeProject(this.project.getKey());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectReminderInstance other = (ProjectReminderInstance)obj;
        if (this.project == null ? other.project != null : this.project.getKey() != other.project.getKey()) {
            return false;
        }
        return !(this.getInstanceTime() == null ? other.getInstanceTime() != null : !this.getInstanceTime().equals(other.getInstanceTime()));
    }

    @Override
    public int getCurrentReminder() {
        return -1;
    }

    public ProjectReminderInstance(Project project) {
        this.project = project;
        this.setInstanceTime(project.getDueDate());
    }

    @Override
    public String getText() {
        return this.project.getText();
    }

    @Override
    public String calculateToGoMessage() {
        return Resource.getResourceString("project");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.getKey());
        result = 31 * result + (this.getInstanceTime() == null ? 0 : this.getInstanceTime().hashCode());
        return result;
    }

    @Override
    public boolean isNote() {
        return true;
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public boolean reloadAndCheckForChanges() {
        try {
            Project orig = this.project;
            this.project = TaskModel.getReference().getProject(this.project.getKey());
            if (this.project == null) {
                return true;
            }
            if (TaskModel.isClosed((Project)this.project)) {
                return true;
            }
            if (!this.project.getDueDate().equals(orig.getDueDate())) {
                return true;
            }
            if (!this.project.getDescription().equals(orig.getDescription())) {
                return true;
            }
        }
        catch (Exception e) {
            this.project = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeShown() {
        if (!Prefs.getBoolPref(PrefName.TASKREMINDERS)) {
            return false;
        }
        if (this.project == null || TaskModel.isClosed((Project)this.project)) {
            return false;
        }
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        int earliestReminderTime = -100000;
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            int time = ReminderTimes.getTimes((int)i);
            if (time <= earliestReminderTime) continue;
            earliestReminderTime = time;
        }
        if (earliestReminderTime == -100000) {
            return false;
        }
        return minutesToGo < (long)earliestReminderTime;
    }
}

