/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Arrays;
import java.util.Date;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;

public abstract class ReminderInstance {
    private boolean hidden = false;
    private Date instanceTime;
    private char[] remindersShown;
    private boolean shown = false;

    public ReminderInstance() {
        this.setRemindersShown(new char[ReminderTimes.getNum()]);
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            this.getRemindersShown()[i] = 78;
        }
    }

    public String calculateToGoMessage() {
        String message = null;
        if (this.isNote() && this.isTodo()) {
            message = Resource.getResourceString("To_Do");
        } else {
            Date d = this.getInstanceTime();
            if (d == null) {
                return null;
            }
            int reminderIndex = this.getCurrentReminder();
            if (reminderIndex == -1) {
                return null;
            }
            this.markAsShown(reminderIndex);
            int minutesToGo = this.minutesToGo();
            String timeString = "";
            if (minutesToGo != 0) {
                int absmin = Math.abs(minutesToGo);
                int days = absmin / 1440;
                int hours = absmin % 1440 / 60;
                int mins = absmin % 60;
                if (days > 0) {
                    timeString = timeString + days + " " + Resource.getResourceString("Days") + " ";
                }
                if (hours > 0) {
                    timeString = timeString + hours + " " + Resource.getResourceString("Hours") + " ";
                }
                timeString = timeString + Integer.toString(mins);
            }
            message = minutesToGo < 0 ? timeString + " " + Resource.getResourceString("minutes_ago") : (minutesToGo == 0 ? Resource.getResourceString("Now") : timeString + " " + Resource.getResourceString("Minutes"));
        }
        return message;
    }

    public abstract void do_todo(boolean var1);

    public final int dueForPopup() {
        int index = this.getCurrentReminder();
        if (this.getRemindersShown()[index] == 'N') {
            return index;
        }
        return -1;
    }

    public abstract boolean equals(Object var1);

    public abstract int getCurrentReminder();

    public abstract String getText();

    public abstract int hashCode();

    public abstract boolean isNote();

    public abstract boolean isTodo();

    public final void markAsShown(int reminderNumber) {
        this.getRemindersShown()[reminderNumber] = 89;
    }

    public int minutesToGo() {
        return (int)(this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L);
    }

    public abstract boolean reloadAndCheckForChanges();

    public abstract boolean shouldBeShown();

    public boolean isHidden() {
        return this.hidden;
    }

    public Date getInstanceTime() {
        return this.instanceTime;
    }

    public char[] getRemindersShown() {
        return this.remindersShown;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setInstanceTime(Date instanceTime) {
        this.instanceTime = instanceTime;
    }

    public void setRemindersShown(char[] remindersShown) {
        this.remindersShown = remindersShown;
    }

    public void setShown(boolean shown) {
        this.shown = shown;
    }

    public String toString() {
        return "ReminderInstance(hidden=" + this.isHidden() + ", instanceTime=" + this.getInstanceTime() + ", remindersShown=" + Arrays.toString(this.getRemindersShown()) + ", shown=" + this.isShown() + ")";
    }
}

