/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.Theme;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.View;
import net.sf.borg.ui.popup.ReminderInstance;
import net.sf.borg.ui.popup.ReminderSound;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

class ReminderPopup
extends View {
    private static final long serialVersionUID = 1L;
    private ReminderInstance reminderInstance = null;
    private JLabel appointmentInformation = null;
    private JLabel timeToGoMessage = null;
    private JRadioButton noMoreRemindersButton = null;

    public ReminderPopup(ReminderInstance inst) {
        this.reminderInstance = inst;
        this.setTitle("Borg " + Resource.getResourceString("Reminder"));
        this.initialize();
        DateFormat df = DateFormat.getDateInstance(3);
        String apptinfoText = df.format(inst.getInstanceTime());
        apptinfoText = apptinfoText + " " + this.reminderInstance.getText();
        this.appointmentInformation.setText(apptinfoText);
        this.setDefaultCloseOperation(1);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        topPanel.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
        this.appointmentInformation = new JLabel();
        this.appointmentInformation.setHorizontalAlignment(0);
        topPanel.add((Component)this.appointmentInformation, GridBagConstraintsFactory.create(0, 0, 0, 1.0, 0.0));
        this.timeToGoMessage = new JLabel();
        this.timeToGoMessage.setText("");
        this.timeToGoMessage.setHorizontalAlignment(0);
        topPanel.add((Component)this.timeToGoMessage, GridBagConstraintsFactory.create(0, 1, 0, 1.0, 0.0));
        this.noMoreRemindersButton = new JRadioButton();
        ResourceHelper.setText(this.noMoreRemindersButton, "No_more");
        this.noMoreRemindersButton.setHorizontalAlignment(0);
        this.noMoreRemindersButton.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
        topPanel.add((Component)this.noMoreRemindersButton, GridBagConstraintsFactory.create(0, 2, 0, 1.0, 0.0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
        buttonPanel.setLayout(new GridBagLayout());
        JButton dismissButton = new JButton();
        ResourceHelper.setText(dismissButton, "Dismiss");
        dismissButton.setActionCommand("close_it");
        dismissButton.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReminderPopup.this.noMoreRemindersButton.isSelected()) {
                    ReminderPopup.this.reminderInstance.setHidden(true);
                    ReminderPopup.this.dispose();
                } else {
                    ReminderPopup.this.setVisible(false);
                }
            }
        });
        buttonPanel.add((Component)dismissButton, GridBagConstraintsFactory.create(0, 0));
        if (this.reminderInstance.isTodo()) {
            JButton doneButton = new JButton();
            doneButton.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
            ResourceHelper.setText(doneButton, "Done_(Delete)");
            doneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReminderPopup.this.reminderInstance.do_todo(true);
                    ReminderPopup.this.destroy();
                }
            });
            buttonPanel.add((Component)doneButton, GridBagConstraintsFactory.create(1, 0));
            JButton doneNoDeleteButton = new JButton();
            doneNoDeleteButton.setBackground(new Color(Theme.getCurrentTheme().getReminderBg()));
            ResourceHelper.setText(doneNoDeleteButton, "Done_(No_Delete)");
            doneNoDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReminderPopup.this.reminderInstance.do_todo(false);
                    ReminderPopup.this.destroy();
                }
            });
            buttonPanel.add((Component)doneNoDeleteButton, GridBagConstraintsFactory.create(2, 0));
        }
        topPanel.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 3));
        this.setContentPane(topPanel);
        this.setCursor(new Cursor(0));
        this.setSize(400, 250);
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    public ReminderInstance getReminderInstance() {
        return this.reminderInstance;
    }

    public void updateMessage() {
        String message;
        if (this.reminderInstance.isNote() && this.reminderInstance.isTodo()) {
            message = this.reminderInstance.calculateToGoMessage();
        } else {
            Date d = this.reminderInstance.getInstanceTime();
            if (d == null) {
                return;
            }
            int reminderIndex = this.reminderInstance.dueForPopup();
            if (reminderIndex == -1) {
                return;
            }
            int minutesToGo = ReminderTimes.getTimes((int)reminderIndex);
            message = minutesToGo < 0 ? -minutesToGo + " " + Resource.getResourceString("minutes_ago") : (minutesToGo == 0 ? Resource.getResourceString("Now") : minutesToGo + " " + Resource.getResourceString("minute_reminder"));
            this.getReminderInstance().markAsShown(reminderIndex);
        }
        this.timeToGoMessage.setText(message);
        this.setVisible(true);
        this.toFront();
        this.setVisible(true);
        this.getReminderInstance().setShown(true);
        ReminderSound.playReminderSound(Prefs.getPref(PrefName.BEEPINGREMINDERS));
    }
}

