/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.borg.model.Model;
import net.sf.borg.ui.popup.ReminderInstance;
import net.sf.borg.ui.popup.ReminderManager;
import net.sf.borg.ui.popup.ReminderPopup;

public class ReminderPopupManager
extends ReminderManager {
    private HashMap<ReminderInstance, ReminderPopup> pops = new HashMap();

    public static ReminderManager getReference() {
        if (singleton == null) {
            singleton = new ReminderPopupManager();
        }
        return singleton;
    }

    private ReminderPopupManager() {
    }

    @Override
    public void remove() {
        super.remove();
        Set<Map.Entry<ReminderInstance, ReminderPopup>> entrySet = this.pops.entrySet();
        for (Map.Entry<ReminderInstance, ReminderPopup> popupMapEntry : entrySet) {
            ReminderPopup popup = popupMapEntry.getValue();
            if (popup == null || !popup.isDisplayable()) continue;
            popup.dispose();
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    @Override
    public void refresh() {
        ArrayList<ReminderInstance> deletedPopupKeys = new ArrayList<ReminderInstance>();
        Set<Map.Entry<ReminderInstance, ReminderPopup>> entrySet = this.pops.entrySet();
        for (Map.Entry<ReminderInstance, ReminderPopup> mapEntry : entrySet) {
            ReminderInstance apptInstance = mapEntry.getKey();
            ReminderPopup popupWindow = mapEntry.getValue();
            if (popupWindow == null) continue;
            if (!popupWindow.isDisplayable()) {
                mapEntry.setValue(null);
                continue;
            }
            if (apptInstance.reloadAndCheckForChanges()) {
                popupWindow.dispose();
                deletedPopupKeys.add(apptInstance);
            }
            if (apptInstance.shouldBeShown()) continue;
            popupWindow.dispose();
            deletedPopupKeys.add(apptInstance);
        }
        for (ReminderInstance inst : deletedPopupKeys) {
            this.pops.remove(inst);
        }
    }

    @Override
    public void showAll() {
        Set<Map.Entry<ReminderInstance, ReminderPopup>> entrySet = this.pops.entrySet();
        for (Map.Entry<ReminderInstance, ReminderPopup> popupMapEntry : entrySet) {
            ReminderPopup popup = popupMapEntry.getValue();
            if (popup == null) continue;
            if (!popup.isDisplayable()) {
                popupMapEntry.setValue(null);
                continue;
            }
            popup.setVisible(true);
            popup.toFront();
        }
    }

    @Override
    public void hideAll() {
        Set<Map.Entry<ReminderInstance, ReminderPopup>> entrySet = this.pops.entrySet();
        for (Map.Entry<ReminderInstance, ReminderPopup> popupMapEntry : entrySet) {
            ReminderPopup popup = popupMapEntry.getValue();
            if (popup == null) continue;
            if (!popup.isDisplayable()) {
                popupMapEntry.setValue(null);
                continue;
            }
            popup.setVisible(false);
        }
    }

    @Override
    public void addToUI(ReminderInstance instance) {
        if (this.pops.containsKey(instance)) {
            return;
        }
        ReminderPopup popup = new ReminderPopup(instance);
        this.pops.put(instance, popup);
        popup.updateMessage();
    }

    @Override
    public void periodicUpdate() {
        Set<Map.Entry<ReminderInstance, ReminderPopup>> entrySet = this.pops.entrySet();
        for (Map.Entry<ReminderInstance, ReminderPopup> popupMapEntry : entrySet) {
            ReminderInstance instance = popupMapEntry.getKey();
            ReminderPopup popup = popupMapEntry.getValue();
            if (popup == null) continue;
            if (!popup.isDisplayable()) {
                popupMapEntry.setValue(null);
                continue;
            }
            if (instance.isHidden() || instance.isNote() && instance.isTodo() && popup.getReminderInstance().isShown() && !this.shouldShowUntimedTodosNow()) continue;
            popup.updateMessage();
        }
    }
}

